/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.security;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.security.JSSESecurityDomain;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

class Util {
    Util() {
    }

    static SSLContext forDomain(JSSESecurityDomain securityDomain) throws IOException {
        SSLContext sslCtx = null;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = securityDomain.getKeyManagers();
            if (keyManagers == null) {
                throw IIOPLogger.ROOT_LOGGER.errorObtainingKeyManagers(securityDomain.getSecurityDomain());
            }
            TrustManager[] trustManagers = securityDomain.getTrustManagers();
            sslCtx.init(keyManagers, trustManagers, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            throw IIOPLogger.ROOT_LOGGER.failedToGetSSLContext(e);
        }
        catch (KeyManagementException e) {
            throw IIOPLogger.ROOT_LOGGER.failedToGetSSLContext(e);
        }
        catch (SecurityException e) {
            throw IIOPLogger.ROOT_LOGGER.failedToGetSSLContext(e);
        }
    }
}

