/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalContextObjectFactory
implements ObjectFactory {
    private static final AtomicInteger PROXY_ID = new AtomicInteger();
    public static final String CACHE_CONTEXT = "cache-context";
    public static final String INITIAL_CONTEXT_CLASS = "initial-context-class";
    public static final String INITIAL_CONTEXT_MODULE = "initial-context-module";
    private static final String LOOKUP_BY_STRING = "org.jboss.as.naming.lookup.by.string";
    private volatile Context cachedObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean cache;
        String cacheString = (String)environment.get(CACHE_CONTEXT);
        boolean bl = cache = cacheString != null && cacheString.toLowerCase().equals("true");
        if (cache) {
            if (this.cachedObject == null) {
                ExternalContextObjectFactory externalContextObjectFactory = this;
                synchronized (externalContextObjectFactory) {
                    if (this.cachedObject == null) {
                        this.cachedObject = this.createContext(environment, true);
                    }
                }
            }
            return this.cachedObject;
        }
        return this.createContext(environment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context createContext(Hashtable<?, ?> environment, boolean useProxy) throws NamingException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ModuleLoadException {
        Context loadedContext;
        String initialContextClassName = (String)environment.get(INITIAL_CONTEXT_CLASS);
        String initialContextModule = (String)environment.get(INITIAL_CONTEXT_MODULE);
        boolean useStringLokup = ExternalContextObjectFactory.useStringLookup(environment);
        Hashtable newEnvironment = new Hashtable(environment);
        newEnvironment.remove(CACHE_CONTEXT);
        newEnvironment.remove(INITIAL_CONTEXT_CLASS);
        newEnvironment.remove(INITIAL_CONTEXT_MODULE);
        newEnvironment.remove(LOOKUP_BY_STRING);
        ClassLoader loader = !WildFlySecurityManager.isChecking() ? this.getClass().getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return this.getClass().getClassLoader();
            }
        });
        Class<?> initialContextClass = null;
        if (initialContextModule == null) {
            initialContextClass = Class.forName(initialContextClassName);
            Constructor<?> ctor = initialContextClass.getConstructor(Hashtable.class);
            loadedContext = (Context)ctor.newInstance(newEnvironment);
        } else {
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.fromString((String)initialContextModule));
            loader = module.getClassLoader();
            ClassLoader currentClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)loader);
                initialContextClass = Class.forName(initialContextClassName, true, loader);
                Constructor<?> ctor = initialContextClass.getConstructor(Hashtable.class);
                loadedContext = (Context)ctor.newInstance(newEnvironment);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)currentClassLoader);
            }
        }
        Context context = useStringLokup ? new LookupByStringContext(loadedContext) : loadedContext;
        if (!useProxy) {
            return context;
        }
        ProxyConfiguration config = new ProxyConfiguration();
        config.setClassLoader(loader);
        config.setSuperClass(initialContextClass);
        config.setProxyName(initialContextClassName + "$$$$Proxy" + PROXY_ID.incrementAndGet());
        ProxyFactory factory = new ProxyFactory(config);
        return (Context)factory.newInstance((InvocationHandler)new CachedContext(context));
    }

    private static boolean useStringLookup(Hashtable<?, ?> environment) {
        Object val = environment.get(LOOKUP_BY_STRING);
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return false;
    }

    private static class LookupByStringContext
    implements Context {
        private final Context context;

        public LookupByStringContext(Context context) {
            this.context = context;
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.context.lookup(name.toString());
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.context.lookup(name);
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
            this.context.bind(name, obj);
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
            this.context.bind(name, obj);
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
            this.context.rebind(name, obj);
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
            this.context.rebind(name, obj);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.context.unbind(name);
        }

        @Override
        public void unbind(String name) throws NamingException {
            this.context.unbind(name);
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
            this.context.rename(oldName, newName);
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
            this.context.rename(oldName, newName);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.context.list(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return this.context.list(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.context.listBindings(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return this.context.listBindings(name);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            this.context.destroySubcontext(name);
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
            this.context.destroySubcontext(name);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return this.context.createSubcontext(name);
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            return this.context.createSubcontext(name);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.context.lookupLink(name.toString());
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return this.context.lookupLink(name);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.context.getNameParser(name.toString());
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return this.context.getNameParser(name);
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return this.context.composeName(name, prefix);
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return this.context.composeName(name, prefix);
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            return this.context.addToEnvironment(propName, propVal);
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            return this.context.removeFromEnvironment(propName);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.context.getEnvironment();
        }

        @Override
        public void close() throws NamingException {
            this.context.close();
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.context.getNameInNamespace();
        }
    }

    static class CachedContext
    implements InvocationHandler {
        Context externalCtx;

        CachedContext(Context externalCtx) {
            this.externalCtx = externalCtx;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (!method.getName().equals("close")) {
                try {
                    value = method.invoke((Object)this.externalCtx, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return value;
        }
    }
}

