/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.url;

import com.github.tomakehurst.wiremock.common.url.Parser;
import com.github.tomakehurst.wiremock.common.url.ParserBuilder;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.Renderer;
import com.github.tomakehurst.wiremock.common.url.RendererBuilder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathTemplate {
    static final Pattern SPECIAL_SYMBOL_REGEX = Pattern.compile("(?:\\{(?<variable>[^}]+)\\})|(?<wildcard>\\*\\*)");
    private final String templateString;
    private final Parser parser;
    private final Renderer renderer;

    public static boolean couldBePathTemplate(String value) {
        return SPECIAL_SYMBOL_REGEX.matcher(value).find();
    }

    public PathTemplate(String templateString) {
        String text;
        this.templateString = templateString;
        Matcher matcher = SPECIAL_SYMBOL_REGEX.matcher(templateString);
        ParserBuilder parserBuilder = new ParserBuilder();
        RendererBuilder rendererBuilder = new RendererBuilder();
        int last = 0;
        while (matcher.find()) {
            String wildcard;
            text = templateString.substring(last, matcher.start());
            parserBuilder.addStatic(text);
            rendererBuilder.addStatic(text);
            String variable = matcher.group("variable");
            if (variable != null) {
                String variableName = PathTemplate.stripFormatCharacters(variable);
                parserBuilder.addVariable(variableName);
                rendererBuilder.addVariable(variableName);
            }
            if ((wildcard = matcher.group("wildcard")) != null) {
                parserBuilder.addWildcard();
                rendererBuilder.addWildcard();
            }
            last = matcher.end();
        }
        text = templateString.substring(last);
        parserBuilder.addStatic(text);
        rendererBuilder.addStatic(text);
        this.parser = parserBuilder.build();
        this.renderer = rendererBuilder.build();
    }

    public boolean matches(String url) {
        return this.parser.matches(url);
    }

    public PathParams parse(String url) {
        return this.parser.parse(url);
    }

    public String render(PathParams pathParams) {
        return this.renderer.render(pathParams);
    }

    public String withoutVariables() {
        return this.templateString.replaceAll(SPECIAL_SYMBOL_REGEX.pattern(), "");
    }

    private static String stripFormatCharacters(String parameter) {
        return parameter.replace(".", "").replace(";", "").replace("*", "");
    }

    public String toString() {
        return this.templateString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathTemplate that = (PathTemplate)o;
        return Objects.equals(this.templateString, that.templateString);
    }

    public int hashCode() {
        return Objects.hash(this.templateString);
    }
}

