/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.jakarta.servlet.http.HttpServletResponseWrapper;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.server.HttpChannel;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;

public class JettyUtils {
    private static final boolean IS_JETTY = JettyUtils.isClassExist("wiremock.org.eclipse.jetty.server.Request");

    private JettyUtils() {
    }

    public static boolean isJetty() {
        return IS_JETTY;
    }

    private static boolean isClassExist(String type) {
        try {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = contextCL == null ? JettyUtils.class.getClassLoader() : contextCL;
            Class.forName(type, false, loader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        return (Response)httpServletResponse;
    }

    public static Socket getTlsSocket(Response response) {
        HttpChannel httpChannel = response.getHttpOutput().getHttpChannel();
        SslConnection.DecryptedEndPoint sslEndpoint = (SslConnection.DecryptedEndPoint)httpChannel.getEndPoint();
        EndPoint endpoint = sslEndpoint.getSslConnection().getEndPoint();
        try {
            SocketChannel channel = (SocketChannel)endpoint.getClass().getMethod("getChannel", new Class[0]).invoke((Object)endpoint, new Object[0]);
            return channel.socket();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Socket.class);
        }
    }

    public static boolean isBrowserProxyRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            Request jettyRequest = (Request)request;
            return Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpsProxyRequest")) || "http".equals(jettyRequest.getMetaData().getURI().getScheme());
        }
        return false;
    }
}

