/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.Format;
import wiremock.com.networknt.schema.FormatValidator;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.format.DateTimeValidator;
import wiremock.com.networknt.schema.format.DurationFormat;

public class FormatKeyword
implements Keyword {
    private static final String DATE_TIME = "date-time";
    private static final String DURATION = "duration";
    private final ValidatorTypeCode type;
    private final Map<String, Format> formats;

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this.type = type;
        this.formats = formats;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
            if (format != null) {
                return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format, this.type);
            }
            switch (formatName) {
                case "duration": {
                    format = new DurationFormat(validationContext.getConfig().isStrict(DURATION));
                    break;
                }
                case "date-time": {
                    ValidatorTypeCode typeCode = ValidatorTypeCode.DATETIME;
                    typeCode.setCustomMessage(this.type.getCustomMessage());
                    return new DateTimeValidator(schemaPath, schemaNode, parentSchema, validationContext, typeCode);
                }
            }
        }
        return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format, this.type);
    }

    @Override
    public String getValue() {
        return this.type.getValue();
    }

    @Override
    public void setCustomMessage(String message) {
        this.type.setCustomMessage(message);
    }
}

