/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.trafficlistener;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

final class NotifyingWiremockNetworkTrafficListener
implements WiremockNetworkTrafficListener {
    private final Notifier notifier;
    private final Charset charset;
    private final CharsetDecoder charsetDecoder;

    NotifyingWiremockNetworkTrafficListener(Notifier notifier, Charset charset) {
        this.notifier = notifier;
        this.charset = charset;
        this.charsetDecoder = charset.newDecoder();
    }

    @Override
    public void opened(Socket socket) {
        this.notifier.info("Opened " + socket);
    }

    @Override
    public void incoming(Socket socket, ByteBuffer bytes) {
        try {
            this.notifier.info("Incoming bytes: " + this.charsetDecoder.decode(bytes));
        }
        catch (CharacterCodingException e) {
            this.notifier.error("Incoming bytes omitted. Could not decode with charset: " + this.charset);
        }
    }

    @Override
    public void outgoing(Socket socket, ByteBuffer bytes) {
        try {
            this.notifier.info("Outgoing bytes: " + this.charsetDecoder.decode(bytes));
        }
        catch (CharacterCodingException e) {
            this.notifier.error("Outgoing bytes omitted. Could not decode with charset: " + this.charset);
        }
    }

    @Override
    public void closed(Socket socket) {
        this.notifier.info("Closed " + socket);
    }
}

