/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.InMemoryObjectStore;
import com.github.tomakehurst.wiremock.store.InMemoryRecorderStateStore;
import com.github.tomakehurst.wiremock.store.InMemoryRequestJournalStore;
import com.github.tomakehurst.wiremock.store.InMemoryScenariosStore;
import com.github.tomakehurst.wiremock.store.InMemorySettingsStore;
import com.github.tomakehurst.wiremock.store.InMemoryStubMappingStore;
import com.github.tomakehurst.wiremock.store.ObjectStore;
import com.github.tomakehurst.wiremock.store.RecorderStateStore;
import com.github.tomakehurst.wiremock.store.RequestJournalStore;
import com.github.tomakehurst.wiremock.store.ScenariosStore;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.store.StubMappingStore;
import com.github.tomakehurst.wiremock.store.files.FileSourceBlobStore;
import com.github.tomakehurst.wiremock.store.files.FileSourceJsonObjectStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class DefaultStores
implements Stores {
    private final FileSource fileRoot;
    private final StubMappingStore stubMappingStore;
    private final RequestJournalStore requestJournalStore;
    private final SettingsStore settingsStore;
    private final ScenariosStore scenariosStore;
    private final Map<String, ObjectStore> objectStores;

    public DefaultStores(FileSource fileRoot) {
        this.fileRoot = fileRoot;
        this.stubMappingStore = new InMemoryStubMappingStore();
        this.requestJournalStore = new InMemoryRequestJournalStore();
        this.settingsStore = new InMemorySettingsStore();
        this.scenariosStore = new InMemoryScenariosStore();
        this.objectStores = new ConcurrentHashMap<String, ObjectStore>();
    }

    @Override
    public StubMappingStore getStubStore() {
        return this.stubMappingStore;
    }

    @Override
    public RequestJournalStore getRequestJournalStore() {
        return this.requestJournalStore;
    }

    @Override
    public SettingsStore getSettingsStore() {
        return this.settingsStore;
    }

    @Override
    public ScenariosStore getScenariosStore() {
        return this.scenariosStore;
    }

    @Override
    public RecorderStateStore getRecorderStateStore() {
        return new InMemoryRecorderStateStore();
    }

    @Override
    public BlobStore getBlobStore(String name) {
        FileSource child = this.fileRoot.child(name);
        return new FileSourceBlobStore(child);
    }

    @Override
    public ObjectStore getObjectStore(String name, Stores.PersistenceType persistenceTypeHint, int maxItems) {
        if (persistenceTypeHint == Stores.PersistenceType.EPHEMERAL) {
            return this.objectStores.computeIfAbsent(name, n -> new InMemoryObjectStore(maxItems));
        }
        FileSource child = this.fileRoot.child(name);
        return new FileSourceJsonObjectStore(child);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

