/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.format;

import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.function.Predicate;
import wiremock.com.ethlo.time.ITU;
import wiremock.com.ethlo.time.LeapSecondException;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.Format;
import wiremock.com.networknt.schema.utils.Classes;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DateTimeFormat
implements Format {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFormat.class);
    private static final boolean ETHLO_PRESENT = Classes.isPresent("wiremock.com.ethlo.time.ITU", DateTimeFormat.class.getClassLoader());
    private static final Predicate<String> VALIDATE = ETHLO_PRESENT ? Ethlo::isValid : JavaTimeOffsetDateTime::isValid;

    @Override
    public String getName() {
        return "date-time";
    }

    @Override
    public String getMessageKey() {
        return "format.date-time";
    }

    @Override
    public boolean matches(ExecutionContext executionContext, String value) {
        return DateTimeFormat.isValid(value);
    }

    private static boolean isValid(String value) {
        try {
            return VALIDATE.test(value);
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)"date-time", (Object)ex.getMessage());
            return false;
        }
    }

    public static class JavaTimeOffsetDateTime {
        public static boolean isValid(String value) {
            try {
                OffsetDateTime.parse(value);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
    }

    public static class Ethlo {
        public static boolean isValid(String value) {
            block2: {
                try {
                    ITU.parseDateTime(value);
                }
                catch (LeapSecondException ex) {
                    if (ex.isVerifiedValidLeapYearMonth()) break block2;
                    return false;
                }
            }
            return true;
        }
    }
}

