/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.utils;

import java.util.ArrayList;
import java.util.Collection;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.PathType;
import wiremock.com.networknt.schema.SchemaValidatorsConfig;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.utils.StringChecker;

public class JsonNodeUtil {
    private static final long V6_VALUE = SpecVersion.VersionFlag.V6.getVersionFlagValue();
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";

    public static Collection<String> allPaths(PathType pathType, String root, JsonNode node) {
        ArrayList<String> collector = new ArrayList<String>();
        JsonNodeUtil.visitNode(pathType, root, node, collector);
        return collector;
    }

    private static void visitNode(PathType pathType, String root, JsonNode node, Collection<String> collector) {
        if (node.isObject()) {
            JsonNodeUtil.visitObject(pathType, root, node, collector);
        } else if (node.isArray()) {
            JsonNodeUtil.visitArray(pathType, root, node, collector);
        }
    }

    private static void visitArray(PathType pathType, String root, JsonNode node, Collection<String> collector) {
        int size = node.size();
        for (int i = 0; i < size; ++i) {
            String path = pathType.append(root, i);
            collector.add(path);
            JsonNodeUtil.visitNode(pathType, path, node.get(i), collector);
        }
    }

    private static void visitObject(PathType pathType, String root, JsonNode node, Collection<String> collector) {
        node.fields().forEachRemaining(entry -> {
            String path = pathType.append(root, (String)entry.getKey());
            collector.add(path);
            JsonNodeUtil.visitNode(pathType, path, (JsonNode)entry.getValue(), collector);
        });
    }

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean isNodeNullable(JsonNode schema, SchemaValidatorsConfig config) {
        if (config.isNullableKeywordEnabled()) {
            return JsonNodeUtil.isNodeNullable(schema);
        }
        return false;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonType schemaType, JsonSchema parentSchema, ValidationContext validationContext) {
        SchemaValidatorsConfig config = validationContext.getConfig();
        JsonType nodeType = TypeFactory.getValueNodeType(node, config);
        if (nodeType != schemaType) {
            JsonSchema grandParentSchema;
            if (schemaType == JsonType.ANY) {
                return true;
            }
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (schemaType == JsonType.INTEGER && nodeType == JsonType.NUMBER && node.canConvertToExactIntegral() && V6_VALUE <= JsonNodeUtil.detectVersion(validationContext)) {
                return true;
            }
            if (nodeType == JsonType.NULL && parentSchema != null && config.isNullableKeywordEnabled() && ((grandParentSchema = parentSchema.getParentSchema()) != null && JsonNodeUtil.isNodeNullable(grandParentSchema.getSchemaNode()) || JsonNodeUtil.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (JsonNodeUtil.isEnumObjectSchema(parentSchema)) {
                return true;
            }
            if (config != null && config.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING) {
                    if (schemaType == JsonType.INTEGER) {
                        return StringChecker.isInteger(node.textValue());
                    }
                    if (schemaType == JsonType.BOOLEAN) {
                        return StringChecker.isBoolean(node.textValue());
                    }
                    if (schemaType == JsonType.NUMBER) {
                        return StringChecker.isNumeric(node.textValue());
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static long detectVersion(ValidationContext validationContext) {
        return validationContext.activeDialect().orElse(SpecVersion.VersionFlag.V4).getVersionFlagValue();
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return StringChecker.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        boolean refNode = false;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            refNode = REF.equals(jsonSchema.getEvaluationPath().getElement(-1));
        }
        if (typeNode != null && enumNode != null && refNode) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

