/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.Arrays;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;

public final class DifferenceEvaluators {
    private static final Short CDATA = 4;
    private static final Short TEXT = 3;
    public static final DifferenceEvaluator Accept = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            return outcome;
        }
    };
    public static final DifferenceEvaluator Default = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (outcome == ComparisonResult.DIFFERENT) {
                switch (comparison.getType()) {
                    case NODE_TYPE: {
                        Short control = (Short)comparison.getControlDetails().getValue();
                        Short test = (Short)comparison.getTestDetails().getValue();
                        if ((!control.equals(TEXT) || !test.equals(CDATA)) && (!control.equals(CDATA) || !test.equals(TEXT))) break;
                        outcome = ComparisonResult.SIMILAR;
                        break;
                    }
                    case HAS_DOCTYPE_DECLARATION: 
                    case DOCTYPE_SYSTEM_ID: 
                    case SCHEMA_LOCATION: 
                    case NO_NAMESPACE_SCHEMA_LOCATION: 
                    case NAMESPACE_PREFIX: 
                    case ATTR_VALUE_EXPLICITLY_SPECIFIED: 
                    case CHILD_NODELIST_SEQUENCE: 
                    case XML_ENCODING: {
                        outcome = ComparisonResult.SIMILAR;
                        break;
                    }
                }
            }
            return outcome;
        }
    };

    private DifferenceEvaluators() {
    }

    public static DifferenceEvaluator first(final DifferenceEvaluator ... evaluators) {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                for (DifferenceEvaluator ev : evaluators) {
                    ComparisonResult evaluated = ev.evaluate(comparison, orig);
                    if (evaluated == orig) continue;
                    return evaluated;
                }
                return orig;
            }
        };
    }

    public static DifferenceEvaluator chain(final DifferenceEvaluator ... evaluators) {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                ComparisonResult finalResult = orig;
                for (DifferenceEvaluator ev : evaluators) {
                    ComparisonResult evaluated;
                    finalResult = evaluated = ev.evaluate(comparison, finalResult);
                }
                return finalResult;
            }
        };
    }

    public static DifferenceEvaluator downgradeDifferencesToEqual(ComparisonType ... types) {
        return DifferenceEvaluators.recordDifferencesAs(ComparisonResult.EQUAL, types);
    }

    public static DifferenceEvaluator downgradeDifferencesToSimilar(ComparisonType ... types) {
        return DifferenceEvaluators.recordDifferencesAs(ComparisonResult.SIMILAR, types);
    }

    public static DifferenceEvaluator upgradeDifferencesToDifferent(ComparisonType ... types) {
        return DifferenceEvaluators.recordDifferencesAs(ComparisonResult.DIFFERENT, types);
    }

    public static DifferenceEvaluator ignorePrologDifferences() {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                return DifferenceEvaluators.belongsToProlog(comparison, true) || DifferenceEvaluators.isSequenceOfRootElement(comparison) ? ComparisonResult.EQUAL : orig;
            }
        };
    }

    public static DifferenceEvaluator ignorePrologDifferencesExceptDoctype() {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                return DifferenceEvaluators.belongsToProlog(comparison, false) || DifferenceEvaluators.isSequenceOfRootElement(comparison) ? ComparisonResult.EQUAL : orig;
            }
        };
    }

    private static DifferenceEvaluator recordDifferencesAs(final ComparisonResult outcome, ComparisonType ... types) {
        final EnumSet<ComparisonType> comparisonTypes = EnumSet.copyOf(Arrays.asList(types));
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                return orig != ComparisonResult.EQUAL && comparisonTypes.contains((Object)comparison.getType()) ? outcome : orig;
            }
        };
    }

    private static boolean belongsToProlog(Comparison comparison, boolean ignoreDoctypeDeclarationAsWell) {
        if (comparison.getType().isDoctypeComparison()) {
            return ignoreDoctypeDeclarationAsWell;
        }
        return DifferenceEvaluators.belongsToProlog(comparison.getControlDetails().getTarget(), ignoreDoctypeDeclarationAsWell) || DifferenceEvaluators.belongsToProlog(comparison.getTestDetails().getTarget(), ignoreDoctypeDeclarationAsWell);
    }

    private static boolean belongsToProlog(Node n, boolean ignoreDoctypeDeclarationAsWell) {
        if (n == null || n instanceof Element) {
            return false;
        }
        if (!ignoreDoctypeDeclarationAsWell && n instanceof DocumentType) {
            return false;
        }
        if (n instanceof Document) {
            return true;
        }
        return DifferenceEvaluators.belongsToProlog(n.getParentNode(), ignoreDoctypeDeclarationAsWell);
    }

    private static boolean isSequenceOfRootElement(Comparison comparison) {
        return comparison.getType() == ComparisonType.CHILD_NODELIST_SEQUENCE && comparison.getControlDetails().getTarget() instanceof Element && comparison.getControlDetails().getTarget().getParentNode() instanceof Document;
    }
}

