/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.global;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class GlobalSettings {
    private final Integer fixedDelay;
    private final DelayDistribution delayDistribution;
    private final Parameters extended;
    private final boolean proxyPassThrough;

    public static Builder builder() {
        return new Builder();
    }

    public static GlobalSettings defaults() {
        return new Builder().build();
    }

    public GlobalSettings(@JsonProperty(value="fixedDelay") Integer fixedDelay, @JsonProperty(value="delayDistribution") DelayDistribution delayDistribution, @JsonProperty(value="extended") Parameters extended, @JsonProperty(value="proxyPassThrough") boolean proxyPassThrough) {
        this.fixedDelay = fixedDelay;
        this.delayDistribution = delayDistribution;
        this.extended = extended;
        this.proxyPassThrough = proxyPassThrough;
    }

    public Integer getFixedDelay() {
        return this.fixedDelay;
    }

    public DelayDistribution getDelayDistribution() {
        return this.delayDistribution;
    }

    public Parameters getExtended() {
        return this.extended;
    }

    public boolean getProxyPassThrough() {
        return this.proxyPassThrough;
    }

    public Builder copy() {
        return new Builder().fixedDelay(this.fixedDelay).delayDistribution(this.delayDistribution).extended(this.extended);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSettings that = (GlobalSettings)o;
        return Objects.equals(this.getFixedDelay(), that.getFixedDelay()) && Objects.equals(this.getDelayDistribution(), that.getDelayDistribution()) && Objects.equals(this.getExtended(), that.getExtended());
    }

    public int hashCode() {
        return Objects.hash(this.getFixedDelay(), this.getDelayDistribution(), this.getExtended());
    }

    public static class Builder {
        private Integer fixedDelay;
        private DelayDistribution delayDistribution;
        private Parameters extended;
        private boolean proxyPassThrough = true;

        public Builder fixedDelay(Integer fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        public Builder delayDistribution(DelayDistribution delayDistribution) {
            this.delayDistribution = delayDistribution;
            return this;
        }

        public Builder extended(Parameters extended) {
            this.extended = extended;
            return this;
        }

        public Builder proxyPassThrough(boolean proxyPassThrough) {
            this.proxyPassThrough = proxyPassThrough;
            return this;
        }

        public GlobalSettings build() {
            return new GlobalSettings(this.fixedDelay, this.delayDistribution, this.extended, this.proxyPassThrough);
        }
    }
}

