/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ImmutableRequest
implements Request {
    private final String absoluteUrl;
    private final Map<String, QueryParameter> queryParams;
    private final RequestMethod method;
    private final String protocol;
    private final String scheme;
    private final String host;
    private final int port;
    private final String clientIp;
    private final HttpHeaders headers;
    private final byte[] body;
    private final boolean multipart;
    private final Map<String, Request.Part> parts;
    private final boolean browserProxyRequest;

    public static Builder create() {
        return new Builder();
    }

    protected ImmutableRequest(String absoluteUrl, RequestMethod method, String protocol, String clientIp, HttpHeaders headers, byte[] body, boolean multipart, boolean browserProxyRequest) {
        this.absoluteUrl = Objects.requireNonNull(absoluteUrl);
        this.queryParams = Urls.splitQueryFromUrl(absoluteUrl);
        this.method = Objects.requireNonNull(method);
        this.protocol = protocol;
        URI uri = URI.create(absoluteUrl);
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.clientIp = clientIp;
        this.headers = headers;
        this.body = body;
        this.multipart = multipart;
        this.parts = Collections.emptyMap();
        this.browserProxyRequest = browserProxyRequest;
    }

    @Override
    public String getUrl() {
        return Urls.getPathAndQuery(this.absoluteUrl);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Override
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        return header.isPresent() ? header.firstValue() : null;
    }

    @Override
    public HttpHeader header(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.headers.getContentTypeHeader();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean containsHeader(String key) {
        return this.headers.getHeader(key).isPresent();
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return this.queryParams.get(key);
    }

    @Override
    public FormParameter formParameter(String key) {
        return null;
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return null;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.body);
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public boolean isMultipart() {
        return this.multipart;
    }

    @Override
    public Collection<Request.Part> getParts() {
        return this.parts.values();
    }

    @Override
    public Request.Part getPart(String name) {
        return this.parts.get(name);
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.browserProxyRequest;
    }

    @Override
    public Optional<Request> getOriginalRequest() {
        return Optional.empty();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public static class Builder {
        private String absouteUrl;
        private RequestMethod requestMethod;
        private String protocol;
        private String clientIp;
        private List<HttpHeader> headers = new ArrayList<HttpHeader>();
        private byte[] body;
        private boolean multipart;
        private boolean browserProxyRequest;

        public Builder withAbsoluteUrl(String absouteUrl) {
            this.absouteUrl = absouteUrl;
            return this;
        }

        public Builder withMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withClientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public Builder withHeaders(HttpHeaders headers) {
            this.headers = new ArrayList<HttpHeader>(headers.all());
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.headers.add(new HttpHeader(key, (Collection<String>)Collections.singletonList(value)));
            return this;
        }

        public Builder withHeader(String key, Collection<String> values) {
            this.headers.add(new HttpHeader(key, values));
            return this;
        }

        public Builder withBody(byte[] body) {
            this.body = body;
            return this;
        }

        public Builder withMultipart(boolean multipart) {
            this.multipart = multipart;
            return this;
        }

        public Builder withBrowserProxyRequest(boolean browserProxyRequest) {
            this.browserProxyRequest = browserProxyRequest;
            return this;
        }

        public ImmutableRequest build() {
            return new ImmutableRequest(this.absouteUrl, this.requestMethod, this.protocol, this.clientIp, new HttpHeaders(this.headers), this.body, this.multipart, this.browserProxyRequest);
        }
    }
}

