/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.util.ArrayList;
import java.util.List;
import wiremock.com.github.jknack.handlebars.internal.HbsParser;
import wiremock.com.github.jknack.handlebars.internal.HbsParserBaseListener;
import wiremock.com.github.jknack.handlebars.internal.MustacheStringUtils;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonToken;
import wiremock.com.github.jknack.handlebars.internal.lang3.StringUtils;

public class MustacheSpec
extends HbsParserBaseListener {
    private Boolean standAlone;
    private List<CommonToken> textTokens = new ArrayList<CommonToken>();
    public static final int REMOVE_LAST_LINE_CHANNEL = 2;

    @Override
    public void exitTemplate(HbsParser.TemplateContext ctx) {
        this.removeWhitespace();
        this.textTokens.clear();
        this.standAlone = null;
    }

    @Override
    public void enterText(HbsParser.TextContext ctx) {
        CommonToken currentToken = (CommonToken)ctx.getStart();
        String currentText = currentToken.getText();
        Integer secondLineIndex = MustacheStringUtils.indexOfSecondLine(currentText);
        if (secondLineIndex == null) {
            this.textTokens.clear();
            this.standAlone = null;
        } else if (secondLineIndex >= 0) {
            boolean canRemoveWhitespace = this.removeWhitespace();
            if (canRemoveWhitespace) {
                String newText = StringUtils.substring(currentText, secondLineIndex);
                currentToken.setText(newText);
            }
            this.textTokens.clear();
            this.standAlone = null;
        }
        this.textTokens.add(currentToken);
    }

    @Override
    public void enterBlock(HbsParser.BlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitBlock(HbsParser.BlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterComment(HbsParser.CommentContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitPartial(HbsParser.PartialContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterDelimiters(HbsParser.DelimitersContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterUnless(HbsParser.UnlessContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterElseBlock(HbsParser.ElseBlockContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void exitUnless(HbsParser.UnlessContext ctx) {
        this.hasTag(true);
    }

    @Override
    public void enterAmpvar(HbsParser.AmpvarContext ctx) {
        this.hasTag(false);
    }

    @Override
    public void enterTvar(HbsParser.TvarContext ctx) {
        this.hasTag(false);
    }

    @Override
    public void enterVar(HbsParser.VarContext ctx) {
        this.hasTag(false);
    }

    private void hasTag(boolean hasTag) {
        if (this.standAlone != Boolean.FALSE) {
            this.standAlone = hasTag;
        }
    }

    private boolean removeWhitespace() {
        boolean canRemoveWhitespace;
        boolean bl = canRemoveWhitespace = this.standAlone == null ? false : this.standAlone;
        if (!canRemoveWhitespace) {
            return false;
        }
        if (this.textTokens.isEmpty()) {
            return true;
        }
        CommonToken lastToken = this.textTokens.get(this.textTokens.size() - 1);
        String lastText = lastToken.getText();
        int newlineIndex = StringUtils.lastIndexOfAny(lastText, "\r", "\n");
        if (newlineIndex >= 0) {
            String lastLine = lastText.substring(newlineIndex + 1);
            if (!StringUtils.isWhitespace(lastLine)) {
                return false;
            }
            lastToken.setChannel(2);
        } else {
            int maxIndex;
            for (int i = maxIndex = this.textTokens.size() - 1; i >= 0; --i) {
                CommonToken loopToken = this.textTokens.get(i);
                String loopText = loopToken.getText();
                if (!StringUtils.isWhitespace(loopText)) {
                    return false;
                }
                if (i != 0) continue;
                for (int j = 0; j <= maxIndex; ++j) {
                    CommonToken whiteSpaceToken = this.textTokens.get(j);
                    whiteSpaceToken.setChannel(1);
                }
                break;
            }
        }
        return true;
    }
}

