/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        AllOfValidator.debug(logger, node, rootNode, instanceLocation);
        ValidatorState state = executionContext.getValidatorState();
        LinkedHashSet<ValidationMessage> childSchemaErrors = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            Set<ValidationMessage> localErrors = null;
            localErrors = !state.isWalkEnabled() ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
            childSchemaErrors.addAll(localErrors);
            if (!this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) continue;
            Iterator<JsonNode> arrayElements = this.schemaNode.elements();
            while (arrayElements.hasNext()) {
                ObjectNode discriminator;
                DiscriminatorContext currentDiscriminatorContext;
                ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                JsonNode $ref = allOfEntry.get("$ref");
                if (null == $ref || null == (currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, instanceLocation);
                String discriminatorPropertyName = discriminator.get("propertyName").asText();
                JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                JsonSchema jsonSchema = this.parentSchema;
                AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
            }
        }
        return Collections.unmodifiableSet(childSchemaErrors);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

