/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.Format;
import wiremock.com.networknt.schema.FormatKeyword;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.Version201909;
import wiremock.com.networknt.schema.Version202012;
import wiremock.com.networknt.schema.Version4;
import wiremock.com.networknt.schema.Version6;
import wiremock.com.networknt.schema.Version7;
import wiremock.com.networknt.schema.Vocabularies;
import wiremock.com.networknt.schema.Vocabulary;
import wiremock.com.networknt.schema.format.DateFormat;
import wiremock.com.networknt.schema.format.DateTimeFormat;
import wiremock.com.networknt.schema.format.DurationFormat;
import wiremock.com.networknt.schema.format.EmailFormat;
import wiremock.com.networknt.schema.format.IPv6Format;
import wiremock.com.networknt.schema.format.IdnEmailFormat;
import wiremock.com.networknt.schema.format.IdnHostnameFormat;
import wiremock.com.networknt.schema.format.IriFormat;
import wiremock.com.networknt.schema.format.IriReferenceFormat;
import wiremock.com.networknt.schema.format.PatternFormat;
import wiremock.com.networknt.schema.format.RegexFormat;
import wiremock.com.networknt.schema.format.TimeFormat;
import wiremock.com.networknt.schema.format.UriFormat;
import wiremock.com.networknt.schema.format.UriReferenceFormat;
import wiremock.com.networknt.schema.utils.StringUtils;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class JsonMetaSchema {
    private static final Logger logger = LoggerFactory.getLogger(JsonMetaSchema.class);
    private static Map<String, String> UNKNOWN_KEYWORDS = new ConcurrentHashMap<String, String>();
    public static final List<Format> COMMON_BUILTIN_FORMATS = new ArrayList<Format>();
    private final String uri;
    private final String idKeyword;
    private Map<String, Keyword> keywords;
    private Map<String, Boolean> vocabularies;
    private final SpecVersion.VersionFlag specification;

    static PatternFormat pattern(String name, String regex, String messageKey) {
        return PatternFormat.of(name, regex, messageKey);
    }

    static PatternFormat pattern(String name, String regex) {
        return JsonMetaSchema.pattern(name, regex, null);
    }

    JsonMetaSchema(String uri, String idKeyword, Map<String, Keyword> keywords, Map<String, Boolean> vocabularies, SpecVersion.VersionFlag specification) {
        if (StringUtils.isBlank(uri)) {
            throw new IllegalArgumentException("uri must not be null or blank");
        }
        if (StringUtils.isBlank(idKeyword)) {
            throw new IllegalArgumentException("idKeyword must not be null or blank");
        }
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null ");
        }
        this.uri = uri;
        this.idKeyword = idKeyword;
        this.keywords = keywords;
        this.specification = specification;
        this.vocabularies = vocabularies;
    }

    public static JsonMetaSchema getV4() {
        return new Version4().getInstance();
    }

    public static JsonMetaSchema getV6() {
        return new Version6().getInstance();
    }

    public static JsonMetaSchema getV7() {
        return new Version7().getInstance();
    }

    public static JsonMetaSchema getV201909() {
        return new Version201909().getInstance();
    }

    public static JsonMetaSchema getV202012() {
        return new Version202012().getInstance();
    }

    public static Builder builder(String uri) {
        return new Builder(uri);
    }

    public static Builder builder(String uri, JsonMetaSchema blueprint) {
        FormatKeyword formatKeyword = (FormatKeyword)blueprint.keywords.get(ValidatorTypeCode.FORMAT.getValue());
        if (formatKeyword == null) {
            throw new IllegalArgumentException("The formatKeyword did not exist - blueprint is invalid.");
        }
        HashMap<String, Boolean> vocabularies = new HashMap<String, Boolean>(blueprint.getVocabularies());
        return JsonMetaSchema.builder(uri).idKeyword(blueprint.idKeyword).addKeywords(blueprint.keywords.values()).addFormats(formatKeyword.getFormats()).specification(blueprint.getSpecification()).vocabularies(vocabularies);
    }

    public String getIdKeyword() {
        return this.idKeyword;
    }

    public String readId(JsonNode schemaNode) {
        return JsonMetaSchema.readText(schemaNode, this.idKeyword);
    }

    public String readAnchor(JsonNode schemaNode) {
        boolean supportsAnchor = this.keywords.containsKey("$anchor");
        if (supportsAnchor) {
            return JsonMetaSchema.readText(schemaNode, "$anchor");
        }
        return null;
    }

    public String readDynamicAnchor(JsonNode schemaNode) {
        boolean supportsDynamicAnchor = this.keywords.containsKey("$dynamicAnchor");
        if (supportsDynamicAnchor) {
            return JsonMetaSchema.readText(schemaNode, "$dynamicAnchor");
        }
        return null;
    }

    private static String readText(JsonNode node, String field) {
        JsonNode idNode = node.get(field);
        if (idNode == null || !idNode.isTextual()) {
            return null;
        }
        return idNode.textValue();
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, Keyword> getKeywords() {
        return this.keywords;
    }

    public Map<String, Boolean> getVocabularies() {
        return this.vocabularies;
    }

    public SpecVersion.VersionFlag getSpecification() {
        return this.specification;
    }

    public JsonValidator newValidator(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, String keyword, JsonNode schemaNode, JsonSchema parentSchema) {
        try {
            Keyword kw = this.keywords.get(keyword);
            if (kw == null) {
                if (UNKNOWN_KEYWORDS.put(keyword, keyword) == null) {
                    logger.warn("Unknown keyword {} - you should define your own Meta Schema. If the keyword is irrelevant for validation, just use a NonValidationKeyword", (Object)keyword);
                }
                return null;
            }
            return kw.newValidator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof JsonSchemaException) {
                logger.error("Error:", e);
                throw (JsonSchemaException)e.getTargetException();
            }
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new JsonSchemaException(e.getTargetException());
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new JsonSchemaException(e);
        }
    }

    public String toString() {
        return this.uri;
    }

    static {
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("hostname", "^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]))*$", "format.hostname"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("ipv4", "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$", "format.ipv4"));
        COMMON_BUILTIN_FORMATS.add(new IPv6Format());
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("json-pointer", "^(/([^/#~]|[~](?=[01]))*)*$", "format.json-pointer"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("relative-json-pointer", "^(0|([1-9]\\d*))(#|(/([^/#~]|[~](?=[01]))*)*)$", "format.relative-json-pointer"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("uri-template", "^([^\\p{Cntrl}\"'%<>\\^`\\{|\\}]|%\\p{XDigit}{2}|\\{[+#./;?&=,!@|]?((\\w|%\\p{XDigit}{2})(\\.?(\\w|%\\p{XDigit}{2}))*(:[1-9]\\d{0,3}|\\*)?)(,((\\w|%\\p{XDigit}{2})(\\.?(\\w|%\\p{XDigit}{2}))*(:[1-9]\\d{0,3}|\\*)?))*\\})*$", "format.uri-template"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("uuid", "^\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}$", "format.uuid"));
        COMMON_BUILTIN_FORMATS.add(new DateFormat());
        COMMON_BUILTIN_FORMATS.add(new DateTimeFormat());
        COMMON_BUILTIN_FORMATS.add(new EmailFormat());
        COMMON_BUILTIN_FORMATS.add(new IdnEmailFormat());
        COMMON_BUILTIN_FORMATS.add(new IdnHostnameFormat());
        COMMON_BUILTIN_FORMATS.add(new IriFormat());
        COMMON_BUILTIN_FORMATS.add(new IriReferenceFormat());
        COMMON_BUILTIN_FORMATS.add(new RegexFormat());
        COMMON_BUILTIN_FORMATS.add(new TimeFormat());
        COMMON_BUILTIN_FORMATS.add(new UriFormat());
        COMMON_BUILTIN_FORMATS.add(new UriReferenceFormat());
        COMMON_BUILTIN_FORMATS.add(new DurationFormat());
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("alpha", "^[a-zA-Z]+$"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("alphanumeric", "^[a-zA-Z0-9]+$"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("color", "(#?([0-9A-Fa-f]{3,6})\\b)|(aqua)|(black)|(blue)|(fuchsia)|(gray)|(green)|(lime)|(maroon)|(navy)|(olive)|(orange)|(purple)|(red)|(silver)|(teal)|(white)|(yellow)|(rgb\\(\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*,\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*,\\s*\\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\b\\s*\\))|(rgb\\(\\s*(\\d?\\d%|100%)+\\s*,\\s*(\\d?\\d%|100%)+\\s*,\\s*(\\d?\\d%|100%)+\\s*\\))"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("ip-address", "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("phone", "^\\+(?:[0-9] ?){6,14}[0-9]$"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("style", "\\s*(.+?):\\s*([^;]+);?"));
        COMMON_BUILTIN_FORMATS.add(JsonMetaSchema.pattern("utc-millisec", "^[0-9]+(\\.?[0-9]+)?$"));
    }

    public static class Builder {
        private SpecVersion.VersionFlag specification = null;
        private Map<String, Keyword> keywords = new HashMap<String, Keyword>();
        private Map<String, Format> formats = new HashMap<String, Format>();
        private Map<String, Boolean> vocabularies = new HashMap<String, Boolean>();
        private String uri;
        private String idKeyword = "id";
        private FormatKeywordFactory formatKeywordFactory = null;

        public Builder(String uri) {
            this.uri = uri;
        }

        private Map<String, Keyword> createKeywordsMap(Map<String, Keyword> kwords, Map<String, Format> formats) {
            HashMap<String, Keyword> map = new HashMap<String, Keyword>();
            for (Map.Entry<String, Keyword> type : kwords.entrySet()) {
                String keywordName = type.getKey();
                Keyword keyword = type.getValue();
                if (ValidatorTypeCode.FORMAT.getValue().equals(keywordName)) {
                    if (keyword instanceof FormatKeyword) continue;
                    throw new IllegalArgumentException("Overriding the keyword 'format' is not supported. Use the formatKeywordFactory and extend the FormatKeyword.");
                }
                map.put(keyword.getValue(), keyword);
            }
            FormatKeyword formatKeyword = this.formatKeywordFactory != null ? this.formatKeywordFactory.newInstance(formats) : new FormatKeyword(formats);
            map.put(formatKeyword.getValue(), formatKeyword);
            return map;
        }

        public Builder formatKeywordFactory(FormatKeywordFactory formatKeywordFactory) {
            this.formatKeywordFactory = formatKeywordFactory;
            return this;
        }

        public Builder formats(Consumer<Map<String, Format>> customizer) {
            customizer.accept(this.formats);
            return this;
        }

        public Builder keywords(Consumer<Map<String, Keyword>> customizer) {
            customizer.accept(this.keywords);
            return this;
        }

        public Builder addKeyword(Keyword keyword) {
            this.keywords.put(keyword.getValue(), keyword);
            return this;
        }

        public Builder addKeywords(Collection<? extends Keyword> keywords) {
            for (Keyword keyword : keywords) {
                this.keywords.put(keyword.getValue(), keyword);
            }
            return this;
        }

        public Builder addFormat(Format format) {
            this.formats.put(format.getName(), format);
            return this;
        }

        public Builder addFormats(Collection<? extends Format> formats) {
            for (Format format : formats) {
                this.addFormat(format);
            }
            return this;
        }

        public Builder vocabulary(String vocabulary) {
            return this.vocabulary(vocabulary, true);
        }

        public Builder vocabulary(String vocabulary, boolean enabled) {
            this.vocabularies.put(vocabulary, enabled);
            return this;
        }

        public Builder vocabularies(Map<String, Boolean> vocabularies) {
            this.vocabularies = vocabularies;
            return this;
        }

        public Builder specification(SpecVersion.VersionFlag specification) {
            this.specification = specification;
            return this;
        }

        public Builder idKeyword(String idKeyword) {
            this.idKeyword = idKeyword;
            return this;
        }

        public JsonMetaSchema build() {
            Map<String, Keyword> kwords = this.createKeywordsMap(this.keywords, this.formats);
            if (this.specification != null && this.specification.getVersionFlagValue() >= SpecVersion.VersionFlag.V201909.getVersionFlagValue() && !this.uri.equals(this.specification.getId())) {
                Map<String, Boolean> vocabularies = JsonSchemaFactory.checkVersion(this.specification).getInstance().getVocabularies();
                Set<String> current = this.vocabularies.keySet();
                HashMap<String, String> format = new HashMap<String, String>();
                format.put(Vocabulary.V202012_FORMAT_ANNOTATION.getId(), Vocabulary.V202012_FORMAT_ASSERTION.getId());
                format.put(Vocabulary.V202012_FORMAT_ASSERTION.getId(), Vocabulary.V202012_FORMAT_ANNOTATION.getId());
                for (String vocabularyId : vocabularies.keySet()) {
                    String formatVocab;
                    if (current.contains(vocabularyId) || (formatVocab = (String)format.get(vocabularyId)) != null && current.contains(formatVocab)) continue;
                    Vocabulary vocabulary = Vocabularies.getVocabulary(vocabularyId);
                    for (String keywordToRemove : vocabulary.getKeywords()) {
                        kwords.remove(keywordToRemove);
                    }
                }
            }
            return new JsonMetaSchema(this.uri, this.idKeyword, kwords, this.vocabularies, this.specification);
        }
    }

    public static interface FormatKeywordFactory {
        public FormatKeyword newInstance(Map<String, Format> var1);
    }
}

