/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import wiremock.com.networknt.schema.ApplyDefaultsStrategy;
import wiremock.com.networknt.schema.ExecutionContextCustomizer;
import wiremock.com.networknt.schema.JsonSchemaIdValidator;
import wiremock.com.networknt.schema.PathType;
import wiremock.com.networknt.schema.i18n.DefaultMessageSource;
import wiremock.com.networknt.schema.i18n.MessageSource;
import wiremock.com.networknt.schema.walk.DefaultItemWalkListenerRunner;
import wiremock.com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import wiremock.com.networknt.schema.walk.DefaultPropertyWalkListenerRunner;
import wiremock.com.networknt.schema.walk.JsonSchemaWalkListener;
import wiremock.com.networknt.schema.walk.WalkListenerRunner;

public class SchemaValidatorsConfig {
    private JsonSchemaIdValidator schemaIdValidator = JsonSchemaIdValidator.DEFAULT;
    private boolean typeLoose;
    private boolean failFast;
    private ApplyDefaultsStrategy applyDefaultsStrategy = ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
    private boolean ecma262Validator;
    private boolean javaSemantics;
    private boolean losslessNarrowing;
    private boolean isCustomMessageSupported = true;
    private boolean openAPI3StyleDiscriminators = false;
    private final Map<String, Boolean> strictness = new HashMap<String, Boolean>(0);
    private boolean handleNullableField = true;
    private Boolean readOnly = null;
    private Boolean writeOnly = null;
    private PathType pathType = PathType.DEFAULT;
    private boolean preloadJsonSchema = true;
    public static final String ALL_KEYWORD_WALK_LISTENER_KEY = "wiremock.com.networknt.AllKeywordWalkListener";
    private final Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap = new HashMap<String, List<JsonSchemaWalkListener>>();
    private final List<JsonSchemaWalkListener> propertyWalkListeners = new ArrayList<JsonSchemaWalkListener>();
    private final List<JsonSchemaWalkListener> itemWalkListeners = new ArrayList<JsonSchemaWalkListener>();
    private ExecutionContextCustomizer executionContextCustomizer;
    private boolean loadCollectors = true;
    private Locale locale;
    private MessageSource messageSource;
    private Boolean formatAssertionsEnabled = null;
    private boolean disableUnevaluatedItems = false;
    private boolean disableUnevaluatedProperties = false;
    private final WalkListenerRunner itemWalkListenerRunner = new DefaultItemWalkListenerRunner(this.getArrayItemWalkListeners());
    private WalkListenerRunner keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.getKeywordWalkListenersMap());
    private WalkListenerRunner propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.getPropertyWalkListeners());

    public SchemaValidatorsConfig disableUnevaluatedAnalysis() {
        this.disableUnevaluatedItems();
        this.disableUnevaluatedProperties();
        return this;
    }

    public SchemaValidatorsConfig disableUnevaluatedItems() {
        this.disableUnevaluatedItems = true;
        return this;
    }

    public SchemaValidatorsConfig disableUnevaluatedProperties() {
        this.disableUnevaluatedProperties = true;
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedAnalysis() {
        this.enableUnevaluatedItems();
        this.enableUnevaluatedProperties();
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedItems() {
        this.disableUnevaluatedItems = false;
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedProperties() {
        this.disableUnevaluatedProperties = false;
        return this;
    }

    public boolean isUnevaluatedItemsAnalysisDisabled() {
        return this.disableUnevaluatedItems;
    }

    public boolean isUnevaluatedItemsAnalysisEnabled() {
        return !this.isUnevaluatedItemsAnalysisDisabled();
    }

    public boolean isUnevaluatedPropertiesAnalysisDisabled() {
        return this.disableUnevaluatedProperties;
    }

    public boolean isUnevaluatedPropertiesAnalysisEnabled() {
        return !this.isUnevaluatedPropertiesAnalysisDisabled();
    }

    public boolean isTypeLoose() {
        return this.typeLoose;
    }

    public void setTypeLoose(boolean typeLoose) {
        this.typeLoose = typeLoose;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setApplyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
        this.applyDefaultsStrategy = applyDefaultsStrategy != null ? applyDefaultsStrategy : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
    }

    public ApplyDefaultsStrategy getApplyDefaultsStrategy() {
        return this.applyDefaultsStrategy;
    }

    public boolean isHandleNullableField() {
        return this.handleNullableField;
    }

    public void setHandleNullableField(boolean handleNullableField) {
        this.handleNullableField = handleNullableField;
    }

    public boolean isEcma262Validator() {
        return this.ecma262Validator;
    }

    public void setEcma262Validator(boolean ecma262Validator) {
        this.ecma262Validator = ecma262Validator;
    }

    public boolean isJavaSemantics() {
        return this.javaSemantics;
    }

    public void setJavaSemantics(boolean javaSemantics) {
        this.javaSemantics = javaSemantics;
    }

    public boolean isCustomMessageSupported() {
        return this.isCustomMessageSupported;
    }

    public void setCustomMessageSupported(boolean customMessageSupported) {
        this.isCustomMessageSupported = customMessageSupported;
    }

    public void addKeywordWalkListener(JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).add(keywordWalkListener);
    }

    public void addKeywordWalkListener(String keyword, JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).add(keywordWalkListener);
    }

    public void addKeywordWalkListeners(List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).addAll(keywordWalkListeners);
    }

    public void addKeywordWalkListeners(String keyword, List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).addAll(keywordWalkListeners);
    }

    public void addPropertyWalkListeners(List<JsonSchemaWalkListener> propertyWalkListeners) {
        this.propertyWalkListeners.addAll(propertyWalkListeners);
    }

    public void addPropertyWalkListener(JsonSchemaWalkListener propertyWalkListener) {
        this.propertyWalkListeners.add(propertyWalkListener);
    }

    public void addItemWalkListener(JsonSchemaWalkListener itemWalkListener) {
        this.itemWalkListeners.add(itemWalkListener);
    }

    public void addItemWalkListeners(List<JsonSchemaWalkListener> itemWalkListeners) {
        this.itemWalkListeners.addAll(itemWalkListeners);
    }

    public List<JsonSchemaWalkListener> getPropertyWalkListeners() {
        return this.propertyWalkListeners;
    }

    public Map<String, List<JsonSchemaWalkListener>> getKeywordWalkListenersMap() {
        return this.keywordWalkListenersMap;
    }

    public List<JsonSchemaWalkListener> getArrayItemWalkListeners() {
        return this.itemWalkListeners;
    }

    WalkListenerRunner getItemWalkListenerRunner() {
        return this.itemWalkListenerRunner;
    }

    WalkListenerRunner getKeywordWalkListenerRunner() {
        return this.keywordWalkListenerRunner;
    }

    WalkListenerRunner getPropertyWalkListenerRunner() {
        return this.propertyWalkListenerRunner;
    }

    public ExecutionContextCustomizer getExecutionContextCustomizer() {
        return this.executionContextCustomizer;
    }

    public void setExecutionContextCustomizer(ExecutionContextCustomizer executionContextCustomizer) {
        this.executionContextCustomizer = executionContextCustomizer;
    }

    public boolean isLosslessNarrowing() {
        return this.losslessNarrowing;
    }

    public void setLosslessNarrowing(boolean losslessNarrowing) {
        this.losslessNarrowing = losslessNarrowing;
    }

    public boolean isOpenAPI3StyleDiscriminators() {
        return this.openAPI3StyleDiscriminators;
    }

    public void setOpenAPI3StyleDiscriminators(boolean openAPI3StyleDiscriminators) {
        this.openAPI3StyleDiscriminators = openAPI3StyleDiscriminators;
    }

    public void setLoadCollectors(boolean loadCollectors) {
        this.loadCollectors = loadCollectors;
    }

    public boolean doLoadCollectors() {
        return this.loadCollectors;
    }

    public boolean isReadOnly() {
        return null != this.readOnly && this.readOnly != false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isWriteOnly() {
        return null != this.writeOnly && this.writeOnly != false;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @Deprecated
    public boolean isWriteMode() {
        return null == this.writeOnly || this.writeOnly != false;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public boolean isStrict(String keyword) {
        return this.isStrict(keyword, Boolean.TRUE);
    }

    public boolean isStrict(String keyword, Boolean defaultValue) {
        return this.strictness.getOrDefault(Objects.requireNonNull(keyword, "keyword cannot be null"), defaultValue);
    }

    public void setStrict(String keyword, boolean strict) {
        this.strictness.put(Objects.requireNonNull(keyword, "keyword cannot be null"), strict);
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            return DefaultMessageSource.getInstance();
        }
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Boolean getFormatAssertionsEnabled() {
        return this.formatAssertionsEnabled;
    }

    public void setFormatAssertionsEnabled(Boolean formatAssertionsEnabled) {
        this.formatAssertionsEnabled = formatAssertionsEnabled;
    }

    public JsonSchemaIdValidator getSchemaIdValidator() {
        return this.schemaIdValidator;
    }

    public void setSchemaIdValidator(JsonSchemaIdValidator schemaIdValidator) {
        this.schemaIdValidator = schemaIdValidator;
    }

    public boolean isPreloadJsonSchema() {
        return this.preloadJsonSchema;
    }

    public void setPreloadJsonSchema(boolean preloadJsonSchema) {
        this.preloadJsonSchema = preloadJsonSchema;
    }
}

