/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class UnevaluatedPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedPropertiesValidator.class);
    private final JsonSchema schema;

    public UnevaluatedPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        UnevaluatedPropertiesValidator.debug(logger, node, rootNode, instanceLocation);
        Predicate<JsonNodeAnnotation> validEvaluationPathFilter = a -> executionContext.getResults().isValid(instanceLocation, a.getEvaluationPath());
        Predicate<JsonNodeAnnotation> adjacentEvaluationPathFilter = a -> a.getEvaluationPath().startsWith(this.evaluationPath.getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        LinkedHashSet<String> evaluatedProperties = new LinkedHashSet<String>();
        LinkedHashSet existingEvaluatedProperties = new LinkedHashSet();
        List properties = instanceLocationAnnotations.stream().filter(a -> "properties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : properties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List patternProperties = instanceLocationAnnotations.stream().filter(a -> "patternProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : patternProperties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List additionalProperties = instanceLocationAnnotations.stream().filter(a -> "additionalProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : additionalProperties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p);
        }
        List unevaluatedProperties = instanceLocationAnnotations.stream().filter(a -> "unevaluatedProperties".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (JsonNodeAnnotation annotation : unevaluatedProperties) {
            if (!(annotation.getValue() instanceof Set)) continue;
            Set p = (Set)annotation.getValue();
            existingEvaluatedProperties.addAll(p);
        }
        Set<ValidationMessage> messages = new LinkedHashSet<ValidationMessage>();
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            Iterator<String> it = node.fieldNames();
            while (it.hasNext()) {
                String fieldName = it.next();
                if (existingEvaluatedProperties.contains(fieldName)) continue;
                evaluatedProperties.add(fieldName);
                if (this.schemaNode.isBoolean() && !this.schemaNode.booleanValue()) {
                    messages.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation.append(fieldName))).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).build());
                    continue;
                }
                messages.addAll(this.schema.validate(executionContext, node.get(fieldName), node, instanceLocation.append(fieldName)));
            }
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        if (!messages.isEmpty()) {
            messages = messages.stream().map(m4 -> ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(m4.getInstanceLocation().getName(-1))).property(m4.getInstanceLocation().getName(-1))).failFast(executionContext.isFailFast())).build()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(evaluatedProperties).build());
        return messages == null || messages.isEmpty() ? Collections.emptySet() : messages;
    }
}

