/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.output;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.output.OutputUnitKey;

public class OutputUnitData {
    private final Map<OutputUnitKey, Boolean> valid = new LinkedHashMap<OutputUnitKey, Boolean>();
    private final Map<OutputUnitKey, Map<String, Object>> errors = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> annotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();

    public Map<OutputUnitKey, Boolean> getValid() {
        return this.valid;
    }

    public Map<OutputUnitKey, Map<String, Object>> getErrors() {
        return this.errors;
    }

    public Map<OutputUnitKey, Map<String, Object>> getAnnotations() {
        return this.annotations;
    }

    public Map<OutputUnitKey, Map<String, Object>> getDroppedAnnotations() {
        return this.droppedAnnotations;
    }

    public static String formatMessage(String message) {
        int index = message.indexOf(":");
        if (index != -1) {
            int length = message.length();
            while (index + 1 < length && message.charAt(index + 1) == ' ') {
                ++index;
            }
            return message.substring(index + 1);
        }
        return message;
    }

    public static OutputUnitData from(Set<ValidationMessage> validationMessages, ExecutionContext executionContext) {
        OutputUnitData data = new OutputUnitData();
        Map<OutputUnitKey, Boolean> valid = data.valid;
        Map<OutputUnitKey, Map<String, Object>> errors = data.errors;
        Map<OutputUnitKey, Map<String, Object>> annotations = data.annotations;
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.droppedAnnotations;
        for (ValidationMessage validationMessage : validationMessages) {
            SchemaLocation assertionSchemaLocation = new SchemaLocation(validationMessage.getSchemaLocation().getAbsoluteIri(), validationMessage.getSchemaLocation().getFragment().getParent());
            OutputUnitKey key = new OutputUnitKey(validationMessage.getEvaluationPath().getParent(), assertionSchemaLocation, validationMessage.getInstanceLocation());
            valid.put(key, false);
            Map errorMap = errors.computeIfAbsent(key, k -> new LinkedHashMap());
            Object value = errorMap.get(validationMessage.getType());
            if (value == null) {
                errorMap.put(validationMessage.getType(), OutputUnitData.formatMessage(validationMessage.getMessage()));
                continue;
            }
            if (value instanceof List) {
                ((List)value).add(OutputUnitData.formatMessage(validationMessage.getMessage()));
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value.toString());
            values.add(OutputUnitData.formatMessage(validationMessage.getMessage()));
            errorMap.put(validationMessage.getType(), values);
        }
        for (List list : executionContext.getAnnotations().asMap().values()) {
            for (JsonNodeAnnotation annotation : list) {
                if (!executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(annotation.getKeyword())) continue;
                SchemaLocation annotationSchemaLocation = new SchemaLocation(annotation.getSchemaLocation().getAbsoluteIri(), annotation.getSchemaLocation().getFragment().getParent());
                OutputUnitKey key = new OutputUnitKey(annotation.getEvaluationPath().getParent(), annotationSchemaLocation, annotation.getInstanceLocation());
                boolean validResult = executionContext.getResults().isValid(annotation.getInstanceLocation(), annotation.getEvaluationPath());
                valid.put(key, validResult);
                if (validResult) {
                    Map annotationMap = annotations.computeIfAbsent(key, k -> new LinkedHashMap());
                    annotationMap.put(annotation.getKeyword(), annotation.getValue());
                    continue;
                }
                Map droppedAnnotationMap = droppedAnnotations.computeIfAbsent(key, k -> new LinkedHashMap());
                droppedAnnotationMap.put(annotation.getKeyword(), annotation.getValue());
            }
        }
        return data;
    }
}

