/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import wiremock.webhooks.org.apache.hc.core5.annotation.Contract;
import wiremock.webhooks.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.hc.core5.http.EntityDetails;
import wiremock.webhooks.org.apache.hc.core5.http.HttpException;
import wiremock.webhooks.org.apache.hc.core5.http.HttpRequest;
import wiremock.webhooks.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.webhooks.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.webhooks.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent") && this.userAgent != null) {
            request.addHeader("User-Agent", this.userAgent);
        }
    }
}

