/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.analytics;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.mediators.APIMgtCommonExecutionPublisher;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.APIManagerAnalyticsConfiguration;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.tracing.TracingSpan;
import org.wso2.carbon.apimgt.tracing.TracingTracer;
import org.wso2.carbon.apimgt.tracing.Util;
import org.wso2.carbon.apimgt.usage.publisher.dto.RequestResponseStreamDTO;
import org.wso2.carbon.apimgt.usage.publisher.internal.UsageComponent;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class APIMgtResponseHandler
extends APIMgtCommonExecutionPublisher {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Override
    public boolean mediate(org.apache.synapse.MessageContext mc) {
        org.apache.synapse.MessageContext messageContext = mc;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIMgtResponseHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIMgtResponseHandler.mediate_aroundBody0(this, messageContext, joinPoint);
    }

    protected APIManagerAnalyticsConfiguration getApiAnalyticsConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerAnalyticsConfiguration)MethodTimeLogger.aspectOf().log(new APIMgtResponseHandler$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIMgtResponseHandler.getApiAnalyticsConfiguration_aroundBody2(this, joinPoint);
    }

    public boolean isContentAware() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIMgtResponseHandler$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIMgtResponseHandler.isContentAware_aroundBody4(this, joinPoint);
    }

    static {
        APIMgtResponseHandler.ajc$preClinit();
    }

    static final /* synthetic */ boolean mediate_aroundBody0(APIMgtResponseHandler ajc$this, org.apache.synapse.MessageContext mc, JoinPoint joinPoint) {
        block27: {
            TracingSpan span = null;
            if (Util.tracingEnabled()) {
                TracingSpan responseLatencySpan = (TracingSpan)mc.getProperty("API:Response_Latency");
                TracingTracer tracer = Util.getGlobalTracer();
                span = Util.startSpan((String)"API:API_MGT_Response_Handler", (TracingSpan)responseLatencySpan, (TracingTracer)tracer);
            }
            if (ajc$this.publisher == null) {
                ajc$this.initializeDataPublisher();
            }
            if (Util.tracingEnabled()) {
                Util.finishSpan(span);
            }
            if (ajc$this.enabled) break block27;
            return true;
        }
        try {
            long responseSize = 0L;
            long responseTime = 0L;
            long serviceTime = 0L;
            long backendTime = 0L;
            long endTime = System.currentTimeMillis();
            boolean cacheHit = false;
            Object startTimeProperty = mc.getProperty("api.ut.requestTime");
            long startTime = startTimeProperty == null ? 0L : Long.parseLong((String)startTimeProperty);
            Object beStartTimeProperty = mc.getProperty("api.ut.backendRequestTime");
            long backendStartTime = beStartTimeProperty == null ? 0L : Long.parseLong((String)beStartTimeProperty);
            Object beEndTimeProperty = mc.getProperty("api.ut.backendRequestEndTime");
            long backendEndTime = beEndTimeProperty == null ? 0L : ((Number)beEndTimeProperty).longValue();
            boolean isBuildMsg = ajc$this.getApiAnalyticsConfiguration().isBuildMsg();
            MessageContext axis2MC = ((Axis2MessageContext)mc).getAxis2MessageContext();
            if (isBuildMsg) {
                Map headers = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
                String contentLength = (String)headers.get("Content-Length");
                if (contentLength != null) {
                    responseSize = Integer.parseInt(contentLength);
                } else {
                    SOAPBody soapbody;
                    try {
                        RelayUtils.buildMessage((MessageContext)axis2MC);
                    }
                    catch (IOException ex) {
                        ajc$this.log.error((Object)"Error occurred while building the message to calculate the response body size", (Throwable)ex);
                    }
                    catch (XMLStreamException ex) {
                        ajc$this.log.error((Object)"Error occurred while building the message to calculate the response body size", (Throwable)ex);
                    }
                    SOAPEnvelope env = mc.getEnvelope();
                    if (env != null && (soapbody = env.getBody()) != null) {
                        byte[] size = soapbody.toString().getBytes(Charset.defaultCharset());
                        responseSize = size.length;
                    }
                }
            }
            if (startTime == 0L) {
                responseTime = 0L;
                backendTime = 0L;
                serviceTime = 0L;
            } else if (endTime != 0L && backendStartTime != 0L && backendEndTime != 0L) {
                responseTime = endTime - startTime;
                backendTime = backendEndTime - backendStartTime;
                serviceTime = responseTime - backendTime;
            } else if (endTime != 0L && backendStartTime == 0L) {
                serviceTime = responseTime = endTime - startTime;
                backendTime = 0L;
                cacheHit = true;
            }
            String keyType = (String)mc.getProperty("AM_KEY_TYPE");
            String correlationID = GatewayUtils.getAndSetCorrelationID(mc);
            JSONObject obj = new JSONObject();
            obj.put((Object)"keyType", (Object)keyType);
            obj.put((Object)"correlationID", (Object)correlationID);
            String metaClientType = obj.toJSONString();
            String fullRequestPath = (String)mc.getProperty("REST_FULL_REQUEST_PATH");
            String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)fullRequestPath);
            String apiVersion = (String)mc.getProperty("SYNAPSE_REST_API");
            String creator = (String)mc.getProperty("api.ut.apiPublisher");
            if (creator == null) {
                creator = APIUtil.getAPIProviderFromRESTAPI((String)apiVersion, (String)tenantDomain);
            }
            apiVersion = apiVersion.split(":v")[1];
            String url = (String)mc.getProperty("REST_URL_PREFIX");
            if (url == null) {
                url = (String)axis2MC.getProperty("SERVICE_PREFIX");
            }
            URL apiurl = new URL(url);
            int port = apiurl.getPort();
            String protocol = mc.getProperty("TRANSPORT_IN_NAME") + "-" + port;
            Object throttleOutProperty = mc.getProperty("isThrottleOutIgnored");
            boolean throttleOutHappened = false;
            if (throttleOutProperty instanceof Boolean) {
                throttleOutHappened = (Boolean)throttleOutProperty;
            }
            String consumerKey = "";
            String username = "";
            String applicationName = "";
            String applicationId = "";
            String applicationOwner = "";
            String tier = "";
            AuthenticationContext authContext = APISecurityUtils.getAuthenticationContext(mc);
            if (authContext != null) {
                consumerKey = authContext.getConsumerKey();
                username = authContext.getUsername();
                applicationName = authContext.getApplicationName();
                applicationId = authContext.getApplicationId();
                if (applicationName == null || "".equals(applicationName)) {
                    applicationName = "None";
                    applicationId = "0";
                }
                tier = authContext.getTier();
                applicationOwner = authContext.getSubscriber();
                if (applicationOwner == null || "".equals(applicationOwner)) {
                    applicationOwner = "None";
                }
            }
            RequestResponseStreamDTO stream = new RequestResponseStreamDTO();
            stream.setApiContext((String)mc.getProperty("api.ut.context"));
            stream.setApiHostname(GatewayUtils.getHostName(mc));
            stream.setApiMethod((String)mc.getProperty("api.ut.HTTP_METHOD"));
            stream.setApiName((String)mc.getProperty("api.ut.api"));
            stream.setApiCreatorTenantDomain(MultitenantUtils.getTenantDomain((String)creator));
            stream.setApiCreator(creator);
            stream.setApiResourcePath(GatewayUtils.extractResource(mc));
            stream.setApiResourceTemplate((String)mc.getProperty("API_ELECTED_RESOURCE"));
            stream.setApiTier(tier);
            stream.setApiVersion(apiVersion);
            consumerKey = (String)mc.getProperty("api.ut.consumerKey");
            if (consumerKey == null || "".equals(consumerKey)) {
                consumerKey = "None";
            }
            stream.setApplicationConsumerKey(consumerKey);
            stream.setApplicationId(applicationId);
            stream.setApplicationName(applicationName);
            stream.setApplicationOwner(applicationOwner);
            stream.setBackendTime(backendTime);
            stream.setDestination(GatewayUtils.extractAddressBasePath(mc));
            stream.setExecutionTime(GatewayUtils.getExecutionTime(mc));
            stream.setMetaClientType(metaClientType);
            stream.setProtocol(protocol);
            stream.setRequestTimestamp(Long.parseLong((String)mc.getProperty("api.ut.requestTime")));
            stream.setResponseCacheHit(cacheHit);
            int responseCode = axis2MC.getProperty("HTTP_SC") instanceof String ? Integer.parseInt((String)axis2MC.getProperty("HTTP_SC")) : (Integer)axis2MC.getProperty("HTTP_SC");
            stream.setResponseCode(responseCode);
            stream.setResponseSize(responseSize);
            stream.setServiceTime(serviceTime);
            stream.setThrottledOut(throttleOutHappened);
            stream.setUserAgent((String)mc.getProperty("clientUserAgent"));
            stream.setUserIp((String)mc.getProperty("clientIp"));
            stream.setUsername(username);
            stream.setUserTenantDomain(MultitenantUtils.getTenantDomain((String)username));
            stream.setResponseTime(responseTime);
            stream.setCorrelationID(correlationID);
            stream.setGatewayType("SYNAPSE");
            stream.setLabel("Synapse");
            Map<String, String> properties = Utils.getCustomAnalyticsProperties(mc);
            stream.setProperties(properties);
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)("Publishing success API invocation event from gateway to analytics for: " + mc.getProperty("api.ut.context") + " with ID: " + mc.getMessageID() + " started" + " at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date())));
            }
            ajc$this.publisher.publishEvent(stream);
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)("Publishing success API invocation event from gateway to analytics for: " + mc.getProperty("api.ut.context") + " with ID: " + mc.getMessageID() + " ended" + " at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date())));
            }
        }
        catch (Exception e) {
            ajc$this.log.error((Object)("Cannot publish response event. " + e.getMessage()), (Throwable)e);
        }
        return true;
    }

    static final /* synthetic */ APIManagerAnalyticsConfiguration getApiAnalyticsConfiguration_aroundBody2(APIMgtResponseHandler ajc$this, JoinPoint joinPoint) {
        return UsageComponent.getAmConfigService().getAPIAnalyticsConfiguration();
    }

    static final /* synthetic */ boolean isContentAware_aroundBody4(APIMgtResponseHandler ajc$this, JoinPoint joinPoint) {
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIMgtResponseHandler.java", APIMgtResponseHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mediate", "org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler", "org.apache.synapse.MessageContext", "mc", "", "boolean"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiAnalyticsConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerAnalyticsConfiguration"), 267);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isContentAware", "org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtResponseHandler", "", "", "", "boolean"), 271);
    }
}

