/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractHandler;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$1$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure29;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure31;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure33;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure35;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure37;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure39;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure41;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure43;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure45;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure47;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure49;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure51;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure53;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure55;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure57;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure59;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure61;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure63;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure65;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure67;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure69;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityConstants;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.tracing.TracingSpan;
import org.wso2.carbon.apimgt.tracing.TracingTracer;
import org.wso2.carbon.apimgt.tracing.Util;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;

public class APIAuthenticationHandler
extends AbstractHandler
implements ManagedLifecycle {
    private static final Log log;
    protected ArrayList<Authenticator> authenticators = new ArrayList();
    private SynapseEnvironment synapseEnvironment;
    private String authorizationHeader;
    private String apiSecurity;
    private String apiLevelPolicy;
    private String certificateInformation;
    private String apiUUID;
    private String apiType = String.valueOf(APIConstants.ApiTypes.API);
    private OpenAPI openAPI;
    private boolean removeOAuthHeadersFromOutMessage = true;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;

    static {
        APIAuthenticationHandler.ajc$preClinit();
        log = LogFactory.getLog(APIAuthenticationHandler.class);
    }

    public String getApiUUID() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiUUID;
    }

    public void setApiUUID(String apiUUID) {
        String string = apiUUID;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.apiUUID = string;
    }

    public String getCertificateInformation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.certificateInformation;
    }

    public void setCertificateInformation(String certificateInformation) {
        String string = certificateInformation;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.certificateInformation = string;
    }

    public String getAPILevelPolicy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiLevelPolicy;
    }

    public void setAPILevelPolicy(String apiLevelPolicy) {
        String string = apiLevelPolicy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.apiLevelPolicy = string;
    }

    public String getApiType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiType;
    }

    public void setApiType(String apiType) {
        String string = apiType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.setApiType_aroundBody14(this, string, joinPoint);
    }

    public void init(SynapseEnvironment synapseEnvironment) {
        SynapseEnvironment synapseEnvironment2 = synapseEnvironment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)synapseEnvironment2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.init_aroundBody16(this, synapseEnvironment2, joinPoint);
    }

    public String getAuthorizationHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        String string = authorizationHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.authorizationHeader = string;
    }

    public String getAPISecurity() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiSecurity;
    }

    public void setAPISecurity(String apiSecurity) {
        String string = apiSecurity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.apiSecurity = string;
    }

    public boolean getRemoveOAuthHeadersFromOutMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.removeOAuthHeadersFromOutMessage;
    }

    public void setRemoveOAuthHeadersFromOutMessage(boolean removeOAuthHeadersFromOutMessage) {
        boolean bl = removeOAuthHeadersFromOutMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.booleanObject((boolean)bl));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.removeOAuthHeadersFromOutMessage = bl;
    }

    protected APIManagerConfigurationService getApiManagerConfigurationService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerConfigurationService)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure31(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.getApiManagerConfigurationService_aroundBody30(this, joinPoint);
    }

    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure33(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.destroy_aroundBody32(this, joinPoint);
    }

    @SuppressWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="The exception needs to thrown for fault sequence invocation")
    protected void initializeAuthenticators() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure35(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.initializeAuthenticators_aroundBody34(this, joinPoint);
    }

    @MethodStats
    @SuppressWarnings(value={"EXS_EXCEPTION_SOFTENING_RETURN_FALSE"}, justification="Error is sent through payload")
    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure37(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIAuthenticationHandler.handleRequest_aroundBody36(this, messageContext2, joinPoint);
    }

    protected void stopMetricTimer(Timer.Context context) {
        Timer.Context context2 = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)((Object)this), (Object)((Object)this), (Object)context2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, context2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure39(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        context2.stop();
    }

    protected Timer.Context startMetricTimer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Timer.Context)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure41(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.startMetricTimer_aroundBody40(this, joinPoint);
    }

    protected boolean isAuthenticate(org.apache.synapse.MessageContext messageContext) throws APISecurityException {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure43(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIAuthenticationHandler.isAuthenticate_aroundBody42(this, messageContext2, joinPoint);
    }

    private Pair<Integer, String> getError(List<AuthenticationResponse> authResponses) {
        List<AuthenticationResponse> list = authResponses;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)((Object)this), (Object)((Object)this), list);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, list, joinPoint};
            return (Pair)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure45(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.getError_aroundBody44(this, list, joinPoint);
    }

    private String getAuthenticatorsChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure47(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.getAuthenticatorsChallengeString_aroundBody46(this, joinPoint);
    }

    protected boolean isAnalyticsEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)((Object)this), (Object)((Object)this));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure49(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIAuthenticationHandler.isAnalyticsEnabled_aroundBody48(this, joinPoint);
    }

    @MethodStats
    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure51(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return APIAuthenticationHandler.handleResponse_aroundBody50(this, messageContext2, joinPoint);
    }

    private void handleAuthFailure(org.apache.synapse.MessageContext messageContext, APISecurityException e) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        APISecurityException aPISecurityException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2, (Object)aPISecurityException);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, aPISecurityException, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure53(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.handleAuthFailure_aroundBody52(this, messageContext2, aPISecurityException, joinPoint);
    }

    protected void setFaultPayload(org.apache.synapse.MessageContext messageContext, APISecurityException e) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        APISecurityException aPISecurityException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2, (Object)aPISecurityException);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, aPISecurityException, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure55(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.setFaultPayload_aroundBody54(this, messageContext2, aPISecurityException, joinPoint);
    }

    protected void sendFault(org.apache.synapse.MessageContext messageContext, int status) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        int n = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2, (Object)Conversions.intObject((int)n));
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure57(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.sendFault_aroundBody56(this, messageContext2, n, joinPoint);
    }

    protected void setSOAPFault(org.apache.synapse.MessageContext messageContext, APISecurityException e) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        APISecurityException aPISecurityException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2, (Object)aPISecurityException);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, aPISecurityException, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure59(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.setSOAPFault_aroundBody58(this, messageContext2, aPISecurityException, joinPoint);
    }

    protected OMElement getFaultPayload(APISecurityException e) {
        APISecurityException aPISecurityException = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)((Object)this), (Object)((Object)this), (Object)aPISecurityException);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, aPISecurityException, joinPoint};
            return (OMElement)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure61(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.getFaultPayload_aroundBody60(this, aPISecurityException, joinPoint);
    }

    private String logMessageDetails(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure63(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.logMessageDetails_aroundBody62(this, messageContext2, joinPoint);
    }

    protected void setAPIParametersToMessageContext(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure65(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIAuthenticationHandler.setAPIParametersToMessageContext_aroundBody64(this, messageContext2, joinPoint);
    }

    protected AuthenticationContext getAuthenticationContext(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (AuthenticationContext)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure67(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.getAuthenticationContext_aroundBody66(this, messageContext2, joinPoint);
    }

    private String extractResource(org.apache.synapse.MessageContext mc) {
        org.apache.synapse.MessageContext messageContext = mc;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)((Object)this), (Object)((Object)this), (Object)messageContext);
        if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$AjcClosure69(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIAuthenticationHandler.extractResource_aroundBody68(this, messageContext, joinPoint);
    }

    static final /* synthetic */ void setApiType_aroundBody14(APIAuthenticationHandler ajc$this, String apiType, JoinPoint joinPoint) {
        if (APIConstants.ApiTypes.PRODUCT_API.name().equalsIgnoreCase(apiType)) {
            ajc$this.apiType = apiType;
        }
    }

    static final /* synthetic */ void init_aroundBody16(APIAuthenticationHandler ajc$this, SynapseEnvironment synapseEnvironment, JoinPoint joinPoint) {
        ajc$this.synapseEnvironment = synapseEnvironment;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing API authentication handler instance");
        }
        if (ajc$this.getApiManagerConfigurationService() != null) {
            ajc$this.initializeAuthenticators();
        }
    }

    static final /* synthetic */ APIManagerConfigurationService getApiManagerConfigurationService_aroundBody30(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getApiManagerConfigurationService();
    }

    static final /* synthetic */ void destroy_aroundBody32(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.authenticators.isEmpty()) {
            for (Authenticator authenticator : ajc$this.authenticators) {
                authenticator.destroy();
            }
        } else {
            log.warn((Object)"Unable to destroy uninitialized authentication handler instance");
        }
    }

    static final /* synthetic */ void initializeAuthenticators_aroundBody34(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        Authenticator authenticator;
        ajc$this.authenticators = new ArrayList();
        boolean isOAuthProtected = false;
        boolean isMutualSSLProtected = false;
        boolean isBasicAuthProtected = false;
        boolean isApiKeyProtected = false;
        boolean isMutualSSLMandatory = false;
        boolean isOAuthBasicAuthMandatory = false;
        if (ajc$this.apiSecurity == null) {
            isOAuthProtected = true;
        } else {
            String[] apiSecurityLevels;
            String[] stringArray = apiSecurityLevels = ajc$this.apiSecurity.split(",");
            int n = apiSecurityLevels.length;
            int n2 = 0;
            while (n2 < n) {
                String apiSecurityLevel = stringArray[n2];
                if (apiSecurityLevel.trim().equalsIgnoreCase("oauth2")) {
                    isOAuthProtected = true;
                } else if (apiSecurityLevel.trim().equalsIgnoreCase("mutualssl")) {
                    isMutualSSLProtected = true;
                } else if (apiSecurityLevel.trim().equalsIgnoreCase("basic_auth")) {
                    isBasicAuthProtected = true;
                } else if (apiSecurityLevel.trim().equalsIgnoreCase("mutualssl_mandatory")) {
                    isMutualSSLMandatory = true;
                } else if (apiSecurityLevel.trim().equalsIgnoreCase("oauth_basic_auth_api_key_mandatory")) {
                    isOAuthBasicAuthMandatory = true;
                } else if (apiSecurityLevel.trim().equalsIgnoreCase("api_key")) {
                    isApiKeyProtected = true;
                }
                ++n2;
            }
        }
        if (!isMutualSSLProtected && !isOAuthBasicAuthMandatory) {
            isOAuthBasicAuthMandatory = true;
        }
        if (!(isBasicAuthProtected || isOAuthProtected || isMutualSSLMandatory || isApiKeyProtected)) {
            isMutualSSLMandatory = true;
        }
        if (ajc$this.authorizationHeader == null) {
            try {
                ajc$this.authorizationHeader = APIUtil.getOAuthConfigurationFromAPIMConfig((String)"AuthorizationHeader");
                if (ajc$this.authorizationHeader == null) {
                    ajc$this.authorizationHeader = "Authorization";
                }
            }
            catch (APIManagementException e) {
                log.error((Object)"Error while reading authorization header from APIM configurations", (Throwable)e);
            }
        }
        if (isMutualSSLProtected) {
            authenticator = new MutualSSLAuthenticator(ajc$this.apiLevelPolicy, isMutualSSLMandatory, ajc$this.certificateInformation);
            authenticator.init(ajc$this.synapseEnvironment);
            ajc$this.authenticators.add(authenticator);
        }
        if (isOAuthProtected) {
            authenticator = new OAuthAuthenticator(ajc$this.authorizationHeader, isOAuthBasicAuthMandatory, ajc$this.removeOAuthHeadersFromOutMessage, ajc$this.apiLevelPolicy);
            authenticator.init(ajc$this.synapseEnvironment);
            ajc$this.authenticators.add(authenticator);
        }
        if (isBasicAuthProtected) {
            authenticator = new BasicAuthAuthenticator(ajc$this.authorizationHeader, isOAuthBasicAuthMandatory);
            authenticator.init(ajc$this.synapseEnvironment);
            ajc$this.authenticators.add(authenticator);
        }
        if (isApiKeyProtected) {
            authenticator = new ApiKeyAuthenticator("apikey", ajc$this.apiLevelPolicy, isOAuthBasicAuthMandatory);
            authenticator.init(ajc$this.synapseEnvironment);
            ajc$this.authenticators.add(authenticator);
        }
        ajc$this.authenticators.sort(new Comparator<Authenticator>(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            public int compare(Authenticator o1, Authenticator o2) {
                Authenticator authenticator = o1;
                Authenticator authenticator2 = o2;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)authenticator, (Object)authenticator2);
                if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                    Object[] objectArray = new Object[]{this, authenticator, authenticator2, joinPoint};
                    return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new APIAuthenticationHandler$1$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
                }
                return 1.compare_aroundBody0(this, authenticator, authenticator2, joinPoint);
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ int compare_aroundBody0(1 ajc$this, Authenticator o1, Authenticator o2, JoinPoint joinPoint) {
                return o1.getPriority() - o2.getPriority();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("APIAuthenticationHandler.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler$1", "org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator:org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator", "o1:o2", "", "int"), 311);
            }
        });
    }

    static final /* synthetic */ boolean handleRequest_aroundBody36(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        TracingSpan keySpan = null;
        if (Util.tracingEnabled()) {
            TracingSpan responseLatencySpan = (TracingSpan)messageContext.getProperty("API:Response_Latency");
            TracingTracer tracer = Util.getGlobalTracer();
            keySpan = Util.startSpan((String)"API:Key_Validation_Latency", (TracingSpan)responseLatencySpan, (TracingTracer)tracer);
            messageContext.setProperty("API:Key_Validation_Latency", (Object)keySpan);
            MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            axis2MC.setProperty("API:Key_Validation_Latency", (Object)keySpan);
        }
        Timer.Context context = ajc$this.startMetricTimer();
        long startTime = System.nanoTime();
        try {
            if (ajc$this.isAnalyticsEnabled()) {
                long currentTime = System.currentTimeMillis();
                messageContext.setProperty("api.ut.requestTime", (Object)Long.toString(currentTime));
            }
            messageContext.setProperty("api.ut.api_type", (Object)ajc$this.apiType);
            if (ajc$this.authenticators.isEmpty()) {
                ajc$this.initializeAuthenticators();
            }
            if (ajc$this.isAuthenticate(messageContext)) {
                ajc$this.setAPIParametersToMessageContext(messageContext);
                return true;
            }
        }
        catch (APISecurityException e) {
            String errorMessage;
            if (Util.tracingEnabled() && keySpan != null) {
                Util.setTag((TracingSpan)keySpan, (String)"error", (String)"API Authentication Failure");
            }
            if (log.isDebugEnabled()) {
                long endTime = System.nanoTime();
                long difference = (endTime - startTime) / 1000000L;
                String messageDetails = ajc$this.logMessageDetails(messageContext);
                log.debug((Object)("Call to Key Manager : " + messageDetails + ", elapsedTimeInMilliseconds=" + difference / 1000000L));
            }
            if ("Unclassified Authentication Failure".equals(errorMessage = APISecurityConstants.getAuthenticationFailureMessage(e.getErrorCode()))) {
                log.error((Object)"API authentication failure due to Unclassified Authentication Failure", (Throwable)e);
            } else {
                log.warn((Object)("API authentication failure due to " + errorMessage));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API authentication failed with error " + e.getErrorCode()), (Throwable)e);
                }
            }
            ajc$this.handleAuthFailure(messageContext, e);
        }
        finally {
            if (Util.tracingEnabled()) {
                Util.finishSpan((TracingSpan)keySpan);
            }
            messageContext.setProperty("security_latency", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            ajc$this.stopMetricTimer(context);
        }
        return false;
    }

    static final /* synthetic */ Timer.Context startMetricTimer_aroundBody40(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        Timer timer = MetricManager.timer((Level)Level.INFO, (String)MetricManager.name((String)"org.wso2.am", (String[])new String[]{((Object)((Object)ajc$this)).getClass().getSimpleName()}));
        return timer.start();
    }

    static final /* synthetic */ boolean isAuthenticate_aroundBody42(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        boolean authenticated = false;
        ArrayList<AuthenticationResponse> authResponses = new ArrayList<AuthenticationResponse>();
        for (Authenticator authenticator : ajc$this.authenticators) {
            AuthenticationResponse authenticationResponse = authenticator.authenticate(messageContext);
            if (authenticationResponse.isMandatoryAuthentication()) {
                authenticated = authenticationResponse.isAuthenticated();
            }
            if (!authenticationResponse.isAuthenticated()) {
                authResponses.add(authenticationResponse);
            }
            if (!authenticationResponse.isContinueToNextAuthenticator()) break;
        }
        if (!authenticated) {
            Pair<Integer, String> error = ajc$this.getError(authResponses);
            throw new APISecurityException((Integer)error.getKey(), (String)error.getValue());
        }
        return true;
    }

    static final /* synthetic */ Pair getError_aroundBody44(APIAuthenticationHandler ajc$this, List authResponses, JoinPoint joinPoint) {
        Pair error = null;
        boolean isMissingCredentials = false;
        for (AuthenticationResponse authResponse : authResponses) {
            if (!authResponse.isContinueToNextAuthenticator()) {
                error = Pair.of((Object)authResponse.getErrorCode(), (Object)authResponse.getErrorMessage());
                return error;
            }
            if (authResponse.isMandatoryAuthentication() && authResponse.getErrorCode() != 900902) {
                error = Pair.of((Object)authResponse.getErrorCode(), (Object)authResponse.getErrorMessage());
                continue;
            }
            isMissingCredentials = true;
        }
        if (error == null && isMissingCredentials) {
            error = Pair.of((Object)900902, (Object)"Invalid Credentials");
            return error;
        }
        if (error == null) {
            error = Pair.of((Object)900900, (Object)"Unclassified Authentication Failure");
        }
        return error;
    }

    static final /* synthetic */ String getAuthenticatorsChallengeString_aroundBody46(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        StringBuilder challengeString = new StringBuilder();
        if (ajc$this.authenticators != null) {
            for (Authenticator authenticator : ajc$this.authenticators) {
                challengeString.append(authenticator.getChallengeString()).append(" ");
            }
        }
        return challengeString.toString().trim();
    }

    static final /* synthetic */ boolean isAnalyticsEnabled_aroundBody48(APIAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        return APIUtil.isAnalyticsEnabled();
    }

    static final /* synthetic */ boolean handleResponse_aroundBody50(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        return true;
    }

    static final /* synthetic */ void handleAuthFailure_aroundBody52(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, APISecurityException e, JoinPoint joinPoint) {
        int status;
        messageContext.setProperty("ERROR_CODE", (Object)e.getErrorCode());
        messageContext.setProperty("ERROR_MESSAGE", (Object)APISecurityConstants.getAuthenticationFailureMessage(e.getErrorCode()));
        messageContext.setProperty("ERROR_EXCEPTION", (Object)e);
        Mediator sequence = messageContext.getSequence("_auth_failure_handler_");
        String errorDetail = APISecurityConstants.getFailureMessageDetailDescription(e.getErrorCode(), e.getMessage());
        if (e.getErrorCode() == 900902) {
            errorDetail = String.valueOf(APISecurityConstants.getFailureMessageDetailDescription(e.getErrorCode(), e.getMessage())) + "'" + ajc$this.authorizationHeader + " : Bearer ACCESS_TOKEN' or '" + ajc$this.authorizationHeader + " : Basic ACCESS_TOKEN' or 'apikey: API_KEY'";
        }
        messageContext.setProperty("ERROR_DETAIL", (Object)errorDetail);
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        axis2MC.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
        try {
            RelayUtils.consumeAndDiscardMessage((MessageContext)axis2MC);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occurred while consuming and discarding the message", (Throwable)axisFault);
        }
        axis2MC.setProperty("messageType", (Object)"application/soap+xml");
        if (e.getErrorCode() == 900900 || e.getErrorCode() == 900911) {
            status = 500;
        } else if (e.getErrorCode() == 900906 || e.getErrorCode() == 900908 || e.getErrorCode() == 900910) {
            status = 403;
        } else {
            status = 401;
            Map headers = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
            if (headers != null) {
                headers.put("WWW-Authenticate", String.valueOf(ajc$this.getAuthenticatorsChallengeString()) + ", error=\"invalid_token\"" + ", error_description=\"The access token expired\"");
                axis2MC.setProperty("TRANSPORT_HEADERS", (Object)headers);
            }
        }
        messageContext.setProperty("HTTP_RESPONSE_STATUS_CODE", (Object)status);
        if (sequence != null && !sequence.mediate(messageContext)) {
            return;
        }
        if (messageContext.isDoingPOX() || messageContext.isDoingGET()) {
            ajc$this.setFaultPayload(messageContext, e);
        } else {
            ajc$this.setSOAPFault(messageContext, e);
        }
        ajc$this.sendFault(messageContext, status);
    }

    static final /* synthetic */ void setFaultPayload_aroundBody54(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, APISecurityException e, JoinPoint joinPoint) {
        Utils.setFaultPayload(messageContext, ajc$this.getFaultPayload(e));
    }

    static final /* synthetic */ void sendFault_aroundBody56(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, int status, JoinPoint joinPoint) {
        Utils.sendFault(messageContext, status);
    }

    static final /* synthetic */ void setSOAPFault_aroundBody58(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, APISecurityException e, JoinPoint joinPoint) {
        Utils.setSOAPFault(messageContext, "Client", "Authentication Failure", e.getMessage());
    }

    static final /* synthetic */ OMElement getFaultPayload_aroundBody60(APIAuthenticationHandler ajc$this, APISecurityException e, JoinPoint joinPoint) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("http://wso2.org/apimanager/security", "ams");
        OMElement payload = fac.createOMElement("fault", ns);
        OMElement errorCode = fac.createOMElement("code", ns);
        errorCode.setText(String.valueOf(e.getErrorCode()));
        OMElement errorMessage = fac.createOMElement("message", ns);
        errorMessage.setText(APISecurityConstants.getAuthenticationFailureMessage(e.getErrorCode()));
        OMElement errorDetail = fac.createOMElement("description", ns);
        errorDetail.setText(APISecurityConstants.getFailureMessageDetailDescription(e.getErrorCode(), e.getMessage()));
        if (e.getErrorCode() == 900902) {
            String errorDescription = String.valueOf(APISecurityConstants.getFailureMessageDetailDescription(e.getErrorCode(), e.getMessage())) + "'" + ajc$this.authorizationHeader + " : Bearer ACCESS_TOKEN' or '" + ajc$this.authorizationHeader + " : Basic ACCESS_TOKEN' or 'apikey: API_KEY'";
            errorDetail.setText(errorDescription);
        }
        payload.addChild((OMNode)errorCode);
        payload.addChild((OMNode)errorMessage);
        payload.addChild((OMNode)errorDetail);
        return payload;
    }

    static final /* synthetic */ String logMessageDetails_aroundBody62(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String remoteIP;
        String requestReceivedTime;
        String requestURI;
        String accessToken;
        String userAgent;
        String applicationName = (String)messageContext.getProperty("api.ut.application.name");
        String endUserName = (String)messageContext.getProperty("api.ut.userName");
        Date incomingReqTime = null;
        MessageContext axisMC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String logMessage = "API call failed reason=API_authentication_failure";
        String logID = axisMC.getOptions().getMessageId();
        if (applicationName != null) {
            logMessage = " belonging to appName=" + applicationName;
        }
        if (endUserName != null) {
            logMessage = String.valueOf(logMessage) + " userName=" + endUserName;
        }
        if (logID != null) {
            logMessage = String.valueOf(logMessage) + " transactionId=" + logID;
        }
        if ((userAgent = (String)((TreeMap)axisMC.getProperty("TRANSPORT_HEADERS")).get("User-Agent")) != null) {
            logMessage = String.valueOf(logMessage) + " with userAgent=" + userAgent;
        }
        if ((accessToken = (String)((TreeMap)axisMC.getProperty("TRANSPORT_HEADERS")).get("Authorization")) != null) {
            logMessage = String.valueOf(logMessage) + " with accessToken=" + accessToken;
        }
        if ((requestURI = (String)messageContext.getProperty("REST_FULL_REQUEST_PATH")) != null) {
            logMessage = String.valueOf(logMessage) + " for requestURI=" + requestURI;
        }
        if ((requestReceivedTime = (String)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("wso2statistics.request.received.time")) != null) {
            long reqIncomingTimestamp = Long.parseLong(requestReceivedTime);
            incomingReqTime = new Date(reqIncomingTimestamp);
            logMessage = String.valueOf(logMessage) + " at time=" + incomingReqTime;
        }
        if ((remoteIP = (String)axisMC.getProperty("REMOTE_ADDR")) != null) {
            logMessage = String.valueOf(logMessage) + " from clientIP=" + remoteIP;
        }
        return logMessage;
    }

    static final /* synthetic */ void setAPIParametersToMessageContext_aroundBody64(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        int index;
        int ind;
        AuthenticationContext authContext = ajc$this.getAuthenticationContext(messageContext);
        MessageContext axis2MsgContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String consumerKey = "";
        String username = "";
        String applicationName = "";
        String applicationId = "";
        if (authContext != null) {
            consumerKey = authContext.getConsumerKey();
            username = authContext.getUsername();
            applicationName = authContext.getApplicationName();
            applicationId = authContext.getApplicationId();
        }
        String context = (String)messageContext.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)messageContext.getProperty("SYNAPSE_REST_API");
        String apiPublisher = (String)messageContext.getProperty("api.ut.apiPublisher");
        if (apiPublisher == null && (apiPublisher = apiVersion.substring(0, ind = apiVersion.indexOf("--"))).contains("-AT-")) {
            apiPublisher = apiPublisher.replace("-AT-", "@");
        }
        if ((index = apiVersion.indexOf("--")) != -1) {
            apiVersion = apiVersion.substring(index + 2);
        }
        String api = apiVersion.split(":")[0];
        String version = (String)messageContext.getProperty("SYNAPSE_REST_API_VERSION");
        String resource = ajc$this.extractResource(messageContext);
        String method = (String)axis2MsgContext.getProperty("HTTP_METHOD");
        String hostName = APIUtil.getHostAddress();
        messageContext.setProperty("api.ut.consumerKey", (Object)consumerKey);
        messageContext.setProperty("api.ut.userId", (Object)username);
        messageContext.setProperty("api.ut.context", (Object)context);
        messageContext.setProperty("api.ut.api_version", (Object)apiVersion);
        messageContext.setProperty("api.ut.api", (Object)api);
        messageContext.setProperty("api.ut.version", (Object)version);
        messageContext.setProperty("api.ut.resource", (Object)resource);
        messageContext.setProperty("api.ut.HTTP_METHOD", (Object)method);
        messageContext.setProperty("api.ut.hostName", (Object)hostName);
        messageContext.setProperty("api.ut.apiPublisher", (Object)apiPublisher);
        messageContext.setProperty("api.ut.application.name", (Object)applicationName);
        messageContext.setProperty("api.ut.application.id", (Object)applicationId);
    }

    static final /* synthetic */ AuthenticationContext getAuthenticationContext_aroundBody66(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        return APISecurityUtils.getAuthenticationContext(messageContext);
    }

    static final /* synthetic */ String extractResource_aroundBody68(APIAuthenticationHandler ajc$this, org.apache.synapse.MessageContext mc, JoinPoint joinPoint) {
        String resource = "/";
        Pattern pattern = Pattern.compile("^/.+?/.+?([/?].+)$");
        Matcher matcher = pattern.matcher((String)mc.getProperty("REST_FULL_REQUEST_PATH"));
        if (matcher.find()) {
            resource = matcher.group(1);
        }
        return resource;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIAuthenticationHandler.java", APIAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApiUUID", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 99);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiUUID", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "apiUUID", "", "void"), 103);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAuthorizationHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "authorizationHeader", "", "void"), 189);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAPISecurity", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 198);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAPISecurity", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "apiSecurity", "", "void"), 207);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "boolean"), 211);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "boolean", "removeOAuthHeadersFromOutMessage", "", "void"), 215);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiManagerConfigurationService", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerConfigurationService"), 219);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "void"), 223);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initializeAuthenticators", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "void"), 234);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleRequest", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 320);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "stopMetricTimer", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.wso2.carbon.metrics.manager.Timer$Context", "context", "", "void"), 396);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCertificateInformation", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 112);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "startMetricTimer", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "org.wso2.carbon.metrics.manager.Timer$Context"), 400);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "isAuthenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 413);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getError", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.util.List", "authResponses", "", "org.apache.commons.lang3.tuple.Pair"), 438);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAuthenticatorsChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 468);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "isAnalyticsEnabled", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "boolean"), 478);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleResponse", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 483);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleAuthFailure", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "messageContext:e", "", "void"), 487);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setFaultPayload", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "messageContext:e", "", "void"), 555);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "sendFault", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext:int", "messageContext:status", "", "void"), 559);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setSOAPFault", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "messageContext:e", "", "void"), 563);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCertificateInformation", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "certificateInformation", "", "void"), 121);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFaultPayload", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "e", "", "org.apache.axiom.om.OMElement"), 567);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logMessageDetails", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "", "java.lang.String"), 595);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setAPIParametersToMessageContext", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "", "void"), 641);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getAuthenticationContext", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "messageContext", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext"), 698);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractResource", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.MessageContext", "mc", "", "java.lang.String"), 702);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAPILevelPolicy", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 130);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAPILevelPolicy", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "apiLevelPolicy", "", "void"), 139);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApiType", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 147);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApiType", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "java.lang.String", "apiType", "", "void"), 155);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "org.apache.synapse.core.SynapseEnvironment", "synapseEnvironment", "", "void"), 165);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthorizationHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", "", "", "", "java.lang.String"), 180);
    }
}

