/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.apikey;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import io.swagger.v3.oas.models.OpenAPI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import javax.cache.Cache;
import net.minidev.json.JSONObject;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jaxen.JaxenException;
import org.json.JSONException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.JWTTokenPayloadInfo;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTDataHolder;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.VerbInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;

public class ApiKeyAuthenticator
implements Authenticator {
    private static final Log log;
    private boolean isGatewayTokenCacheEnabled;
    private static boolean gatewayApiKeyCacheInit;
    private static boolean gatewayApiKeyKeyCacheInit;
    private static boolean gatewayInvalidApiKeyCacheInit;
    private String securityParam;
    private String apiLevelPolicy;
    private boolean isMandatory;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        ApiKeyAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(ApiKeyAuthenticator.class);
        gatewayApiKeyCacheInit = false;
        gatewayApiKeyKeyCacheInit = false;
        gatewayInvalidApiKeyCacheInit = false;
    }

    public ApiKeyAuthenticator(String authorizationHeader, String apiLevelPolicy, boolean isApiKeyMandatory) {
        this.securityParam = authorizationHeader;
        this.apiLevelPolicy = apiLevelPolicy;
        this.isGatewayTokenCacheEnabled = GatewayUtils.isGatewayTokenCacheEnabled();
        this.isMandatory = isApiKeyMandatory;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        ApiKeyAuthenticator.init_aroundBody0(this, synapseEnvironment, joinPoint);
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        ApiKeyAuthenticator.destroy_aroundBody2(this, joinPoint);
    }

    @Override
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.authenticate_aroundBody4(this, messageContext, joinPoint);
    }

    private String extractApiKey(org.apache.synapse.MessageContext mCtx) throws APISecurityException {
        org.apache.synapse.MessageContext messageContext = mCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.extractApiKey_aroundBody6(this, messageContext, joinPoint);
    }

    private String removeApiKeyFromQueryParameters(String queryParam, String apiKey) {
        String string = queryParam;
        String string2 = apiKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.removeApiKeyFromQueryParameters_aroundBody8(this, string, string2, joinPoint);
    }

    private static boolean isJwtTokenExpired(JWTClaimsSet payload) {
        JWTClaimsSet jWTClaimsSet = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)jWTClaimsSet);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{jWTClaimsSet, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536)));
        }
        return ApiKeyAuthenticator.isJwtTokenExpired_aroundBody10(jWTClaimsSet, joinPoint);
    }

    private byte[] decode(String payload) throws IllegalArgumentException {
        String string = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (byte[])MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.decode_aroundBody12(this, string, joinPoint);
    }

    private Cache getGatewayApiKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.getGatewayApiKeyCache_aroundBody14(this, joinPoint);
    }

    private Cache getInvalidGatewayApiKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.getInvalidGatewayApiKeyCache_aroundBody16(this, joinPoint);
    }

    private Cache getGatewayApiKeyDataCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.getGatewayApiKeyDataCache_aroundBody18(this, joinPoint);
    }

    private String getApiLevelPolicy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiLevelPolicy;
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.getChallengeString_aroundBody22(this, joinPoint);
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return ApiKeyAuthenticator.getRequestOrigin_aroundBody24(this, joinPoint);
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new ApiKeyAuthenticator$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return ApiKeyAuthenticator.getPriority_aroundBody26(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody0(ApiKeyAuthenticator ajc$this, SynapseEnvironment env, JoinPoint joinPoint) {
    }

    static final /* synthetic */ void destroy_aroundBody2(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody4(ApiKeyAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ApiKey Authentication initialized");
        }
        try {
            JWSHeader decodedHeader;
            String apiKey = ajc$this.extractApiKey(synCtx);
            JWTTokenPayloadInfo payloadInfo = null;
            String[] splitToken = apiKey.split("\\.");
            JWTClaimsSet payload = null;
            SignedJWT signedJWT = null;
            if (splitToken.length != 3) {
                log.error((Object)"Api Key does not have the format {header}.{payload}.{signature} ");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            String tokenSignature = splitToken[2];
            try {
                decodedHeader = JWSHeader.parse((Base64URL)new Base64URL(splitToken[0]));
            }
            catch (IllegalArgumentException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid Api Key. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])), (Throwable)e);
                }
                log.error((Object)"Invalid JWT token. Failed to decode the Api Key header.");
                throw new APISecurityException(900901, "Invalid Credentials", e);
            }
            if (!decodedHeader.getType().equals((Object)JOSEObjectType.JWT)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid Api Key token type. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)"Invalid Api Key token type.");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            if (decodedHeader.getKeyID() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid Api Key. Could not find alias in header. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)"Invalid Api Key. Could not find alias in header");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            String certAlias = decodedHeader.getKeyID();
            String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
            String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
            String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
            String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
            OpenAPI openAPI = (OpenAPI)synCtx.getProperty("OPEN_API_OBJECT");
            if (openAPI == null && !"GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                log.error((Object)"Swagger is missing in the gateway. Therefore, Api Key authentication cannot be performed.");
                return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900911, "Internal Server Error");
            }
            String resourceCacheKey = APIUtil.getResourceInfoDTOCacheKey((String)apiContext, (String)apiVersion, (String)matchingResource, (String)httpMethod);
            VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
            verbInfoDTO.setHttpVerb(httpMethod);
            verbInfoDTO.setAuthType("None");
            verbInfoDTO.setRequestKey(resourceCacheKey);
            verbInfoDTO.setThrottling(OpenAPIUtils.getResourceThrottlingTier(openAPI, synCtx));
            ArrayList<VerbInfoDTO> verbInfoList = new ArrayList<VerbInfoDTO>();
            verbInfoList.add(verbInfoDTO);
            synCtx.setProperty("VERB_INFO", verbInfoList);
            String cacheKey = GatewayUtils.getAccessTokenCacheKey(tokenSignature, apiContext, apiVersion, matchingResource, httpMethod);
            String tenantDomain = GatewayUtils.getTenantDomain();
            boolean isVerified = false;
            if (ajc$this.isGatewayTokenCacheEnabled) {
                String cacheToken = (String)ajc$this.getGatewayApiKeyCache().get((Object)tokenSignature);
                if (cacheToken != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Api Key retrieved from the Api Key cache.");
                    }
                    if (ajc$this.getGatewayApiKeyDataCache().get((Object)cacheKey) != null) {
                        payloadInfo = (JWTTokenPayloadInfo)ajc$this.getGatewayApiKeyDataCache().get((Object)cacheKey);
                        String rawPayload = payloadInfo.getRawPayload();
                        isVerified = rawPayload.equals(splitToken[1]);
                    }
                } else {
                    if (ajc$this.getInvalidGatewayApiKeyCache().get((Object)tokenSignature) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Api Key retrieved from the invalid Api Key cache. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                        }
                        log.error((Object)("Invalid Api Key." + GatewayUtils.getMaskedToken(splitToken[0])));
                        throw new APISecurityException(900901, "Invalid Credentials");
                    }
                    if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                        }
                        log.error((Object)("Invalid API Key. " + GatewayUtils.getMaskedToken(splitToken[0])));
                        throw new APISecurityException(900901, "Invalid API Key");
                    }
                }
            } else if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
                throw new APISecurityException(900901, "Invalid JWT token");
            }
            if (!isVerified) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Api Key not found in the cache.");
                }
                try {
                    signedJWT = (SignedJWT)JWTParser.parse((String)apiKey);
                    payload = signedJWT.getJWTClaimsSet();
                }
                catch (IllegalArgumentException | ParseException | JSONException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invalid Api Key. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])), e);
                    }
                    log.error((Object)"Invalid JWT token. Failed to decode the Api Key body.");
                    throw new APISecurityException(900901, "Invalid Credentials", e);
                }
                try {
                    isVerified = GatewayUtils.verifyTokenSignature(signedJWT, certAlias);
                }
                catch (APISecurityException e) {
                    if (e.getErrorCode() == 900901) {
                        throw new APISecurityException(900901, "Invalid Credentials");
                    }
                    throw e;
                }
                if (ajc$this.isGatewayTokenCacheEnabled) {
                    if (isVerified) {
                        ajc$this.getGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                    } else {
                        ajc$this.getInvalidGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                    }
                    if (!"carbon.super".equals(tenantDomain)) {
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
                            if (isVerified) {
                                ajc$this.getGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                            } else {
                                ajc$this.getInvalidGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                            }
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
            }
            if (isVerified) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Api Key signature is verified.");
                }
                if (ajc$this.isGatewayTokenCacheEnabled && payloadInfo != null) {
                    payload = payloadInfo.getPayload();
                    if (ApiKeyAuthenticator.isJwtTokenExpired(payload)) {
                        ajc$this.getGatewayApiKeyCache().remove((Object)tokenSignature);
                        ajc$this.getInvalidGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                        log.error((Object)"Api Key is expired");
                        throw new APISecurityException(900901, "Invalid Credentials");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"ApiKey payload not found in the cache.");
                    }
                    if (payload == null) {
                        try {
                            signedJWT = (SignedJWT)JWTParser.parse((String)apiKey);
                            payload = signedJWT.getJWTClaimsSet();
                        }
                        catch (IllegalArgumentException | ParseException | JSONException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Invalid ApiKey. ApiKey: " + GatewayUtils.getMaskedToken(splitToken[0])));
                            }
                            log.error((Object)"Invalid Api Key. Failed to decode the Api Key body.");
                            throw new APISecurityException(900901, "Invalid Credentials", e);
                        }
                    }
                    if (ApiKeyAuthenticator.isJwtTokenExpired(payload)) {
                        if (ajc$this.isGatewayTokenCacheEnabled) {
                            ajc$this.getGatewayApiKeyCache().remove((Object)tokenSignature);
                            ajc$this.getInvalidGatewayApiKeyCache().put((Object)tokenSignature, (Object)tenantDomain);
                        }
                        log.error((Object)"Api Key is expired");
                        throw new APISecurityException(900901, "Invalid Credentials");
                    }
                    if (ajc$this.isGatewayTokenCacheEnabled) {
                        JWTTokenPayloadInfo jwtTokenPayloadInfo = new JWTTokenPayloadInfo();
                        jwtTokenPayloadInfo.setPayload(payload);
                        jwtTokenPayloadInfo.setRawPayload(splitToken[1]);
                        ajc$this.getGatewayApiKeyDataCache().put((Object)cacheKey, (Object)jwtTokenPayloadInfo);
                    }
                }
                JSONObject api = GatewayUtils.validateAPISubscription(apiContext, apiVersion, payload, splitToken, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Api Key authentication successful.");
                }
                AuthenticationContext authenticationContext = GatewayUtils.generateAuthenticationContext(tokenSignature, payload, api, null, ajc$this.getApiLevelPolicy(), null, false);
                APISecurityUtils.setAuthenticationContext(synCtx, authenticationContext, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User is authorized to access the resource using Api Key.");
                }
                return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Api Key signature verification failure. Api Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
            }
            log.error((Object)"Invalid Api Key. Signature verification failed.");
            throw new APISecurityException(900901, "Invalid Credentials");
        }
        catch (APISecurityException e) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, e.getErrorCode(), e.getMessage());
        }
        catch (ParseException e) {
            log.error((Object)"Error while parsing API Key", (Throwable)e);
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900900, "Unclassified Authentication Failure");
        }
    }

    static final /* synthetic */ String extractApiKey_aroundBody6(ApiKeyAuthenticator ajc$this, org.apache.synapse.MessageContext mCtx, JoinPoint joinPoint) {
        String apiKey;
        MessageContext axis2MC = ((Axis2MessageContext)mCtx).getAxis2MessageContext();
        Map headers = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
        if (headers != null && (apiKey = (String)headers.get(ajc$this.securityParam)) != null) {
            headers.remove(ajc$this.securityParam);
            return apiKey.trim();
        }
        try {
            apiKey = new SynapseXPath("$url:apikey").stringValueOf(mCtx);
            if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                String rest_url_postfix = (String)axis2MC.getProperty("REST_URL_POSTFIX");
                rest_url_postfix = ajc$this.removeApiKeyFromQueryParameters(rest_url_postfix, URLEncoder.encode(apiKey));
                axis2MC.setProperty("REST_URL_POSTFIX", (Object)rest_url_postfix);
                return apiKey.trim();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Api Key Authentication failed: Header or Query parameter with the name '".concat(ajc$this.securityParam).concat("' was not found."));
            }
            throw new APISecurityException(900902, "Missing Credentials");
        }
        catch (JaxenException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while retrieving apikey from the request query params.", (Throwable)e);
            }
            throw new APISecurityException(900902, "Missing Credentials");
        }
    }

    static final /* synthetic */ String removeApiKeyFromQueryParameters_aroundBody8(ApiKeyAuthenticator ajc$this, String queryParam, String apiKey, JoinPoint joinPoint) {
        queryParam = queryParam.replace("?apikey=" + apiKey, "?");
        queryParam = queryParam.replace("&apikey=" + apiKey, "");
        if ((queryParam = queryParam.replace("?&", "?")).lastIndexOf("?") == queryParam.length() - 1) {
            queryParam = queryParam.replace("?", "");
        }
        return queryParam;
    }

    static final /* synthetic */ boolean isJwtTokenExpired_aroundBody10(JWTClaimsSet payload, JoinPoint joinPoint) {
        block4: {
            int timestampSkew = (int)OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds();
            DefaultJWTClaimsVerifier jwtClaimsSetVerifier = new DefaultJWTClaimsVerifier();
            jwtClaimsSetVerifier.setMaxClockSkew(timestampSkew);
            try {
                jwtClaimsSetVerifier.verify(payload);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token is not expired. User: " + payload.getSubject()));
                }
            }
            catch (BadJWTException e) {
                if (!"Expired JWT".equals(e.getMessage())) break block4;
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Token is not expired. User: " + payload.getSubject()));
        }
        return false;
    }

    static final /* synthetic */ byte[] decode_aroundBody12(ApiKeyAuthenticator ajc$this, String payload, JoinPoint joinPoint) {
        return Base64.getUrlDecoder().decode(payload.getBytes(StandardCharsets.UTF_8));
    }

    static final /* synthetic */ Cache getGatewayApiKeyCache_aroundBody14(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayApiKeyCache();
    }

    static final /* synthetic */ Cache getInvalidGatewayApiKeyCache_aroundBody16(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidGatewayApiKeyCache();
    }

    static final /* synthetic */ Cache getGatewayApiKeyDataCache_aroundBody18(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayApiKeyDataCache();
    }

    static final /* synthetic */ String getChallengeString_aroundBody22(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ String getRequestOrigin_aroundBody24(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ int getPriority_aroundBody26(ApiKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return 30;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApiKeyAuthenticator.java", ApiKeyAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "void"), 92);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiLevelPolicy", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "java.lang.String"), 458);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "java.lang.String"), 463);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "java.lang.String"), 468);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "int"), 473);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractApiKey", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "org.apache.synapse.MessageContext", "mCtx", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "java.lang.String"), 361);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeApiKeyFromQueryParameters", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "java.lang.String:java.lang.String", "queryParam:apiKey", "", "java.lang.String"), 401);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isJwtTokenExpired", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "com.nimbusds.jwt.JWTClaimsSet", "payload", "", "boolean"), 418);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "decode", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "java.lang.String", "payload", "java.lang.IllegalArgumentException", "[B"), 440);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayApiKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "javax.cache.Cache"), 445);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInvalidGatewayApiKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "javax.cache.Cache"), 449);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayApiKeyDataCache", "org.wso2.carbon.apimgt.gateway.handlers.security.apikey.ApiKeyAuthenticator", "", "", "", "javax.cache.Cache"), 454);
    }
}

