/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.authenticator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.cert.X509Certificate;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.dto.VerbInfoDTO;

public class MutualSSLAuthenticator
implements Authenticator {
    private static final Log log;
    private String apiLevelPolicy;
    private String requestOrigin;
    private static String challengeString;
    private boolean isMandatory;
    private HashMap<String, String> certificates;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        MutualSSLAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(MutualSSLAuthenticator.class);
        challengeString = "Mutual SSL realm=\"" + ServiceReferenceHolder.getInstance().getServerConfigurationService().getFirstProperty("Name") + "\"";
    }

    public MutualSSLAuthenticator(String apiLevelPolicy, boolean isMandatory, String certificateDetails) {
        this.apiLevelPolicy = apiLevelPolicy;
        this.certificates = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)certificateDetails)) {
            String[] certificateParts;
            String[] stringArray = certificateParts = certificateDetails.substring(1, certificateDetails.length() - 1).split(",");
            int n = certificateParts.length;
            int n2 = 0;
            while (n2 < n) {
                String certificatePart = stringArray[n2];
                int tierDivisionIndex = certificatePart.lastIndexOf("=");
                if (tierDivisionIndex > 0) {
                    String uniqueIdentifier = certificatePart.substring(0, tierDivisionIndex).trim();
                    String tier = certificatePart.substring(tierDivisionIndex + 1);
                    this.certificates.put(uniqueIdentifier, tier);
                }
                ++n2;
            }
        }
        this.isMandatory = isMandatory;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        MutualSSLAuthenticator.init_aroundBody0(this, synapseEnvironment, joinPoint);
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        MutualSSLAuthenticator.destroy_aroundBody2(this, joinPoint);
    }

    @Override
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return MutualSSLAuthenticator.authenticate_aroundBody4(this, messageContext2, joinPoint);
    }

    private void setAuthContext(org.apache.synapse.MessageContext messageContext, X509Certificate x509Certificate) throws APISecurityException {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        X509Certificate x509Certificate2 = x509Certificate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)messageContext2, (Object)x509Certificate2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, x509Certificate2, joinPoint};
            MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        MutualSSLAuthenticator.setAuthContext_aroundBody6(this, messageContext2, x509Certificate2, joinPoint);
    }

    private APIIdentifier getAPIIdentifier(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)messageContext2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (APIIdentifier)MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return MutualSSLAuthenticator.getAPIIdentifier_aroundBody8(this, messageContext2, joinPoint);
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return MutualSSLAuthenticator.challengeString;
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.requestOrigin;
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new MutualSSLAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return MutualSSLAuthenticator.getPriority_aroundBody14(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody0(MutualSSLAuthenticator ajc$this, SynapseEnvironment env, JoinPoint joinPoint) {
    }

    static final /* synthetic */ void destroy_aroundBody2(MutualSSLAuthenticator ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody4(MutualSSLAuthenticator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        X509Certificate sslCertObject;
        MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        try {
            sslCertObject = Utils.getClientCertificate(axis2MessageContext);
        }
        catch (APIManagementException e) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, !ajc$this.isMandatory, 900900, e.getMessage());
        }
        if (sslCertObject == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mutual SSL authentication has not happened in the transport level for the API " + ajc$this.getAPIIdentifier(messageContext).toString() + ", hence API invocation is not allowed"));
            }
            if (ajc$this.isMandatory) {
                log.error((Object)"Mutual SSL authentication failure");
            }
            return new AuthenticationResponse(false, ajc$this.isMandatory, !ajc$this.isMandatory, 900901, "Invalid Credentials");
        }
        try {
            ajc$this.setAuthContext(messageContext, sslCertObject);
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, !ajc$this.isMandatory, ex.getErrorCode(), ex.getMessage());
        }
        return new AuthenticationResponse(true, ajc$this.isMandatory, true, 0, null);
    }

    static final /* synthetic */ void setAuthContext_aroundBody6(MutualSSLAuthenticator ajc$this, org.apache.synapse.MessageContext messageContext, X509Certificate x509Certificate, JoinPoint joinPoint) {
        String subjectDN = x509Certificate.getSubjectDN().getName();
        String uniqueIdentifier = (x509Certificate.getSerialNumber() + "_" + x509Certificate.getIssuerDN()).replaceAll(",", "#").replaceAll("\"", "'").trim();
        String tier = ajc$this.certificates.get(uniqueIdentifier);
        if (StringUtils.isEmpty((CharSequence)tier)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The client certificate presented is available in gateway, however it was not added against the API " + ajc$this.getAPIIdentifier(messageContext)));
            }
            if (ajc$this.isMandatory) {
                log.error((Object)"Mutual SSL authentication failure. API is not associated with the certificate");
            }
            throw new APISecurityException(900901, "Invalid Credentials");
        }
        AuthenticationContext authContext = new AuthenticationContext();
        authContext.setAuthenticated(true);
        authContext.setUsername(subjectDN);
        try {
            LdapName ldapDN = new LdapName(subjectDN);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                authContext.setUsername((String)rdn.getValue());
            }
        }
        catch (InvalidNameException e) {
            log.warn((Object)("Cannot get the CN name from certificate:" + e.getMessage() + ". Please make sure the " + "certificate to include a proper common name that follows naming convention."));
            authContext.setUsername(subjectDN);
        }
        authContext.setApiTier(ajc$this.apiLevelPolicy);
        APIIdentifier apiIdentifier = ajc$this.getAPIIdentifier(messageContext);
        authContext.setKeyType("PRODUCTION");
        authContext.setStopOnQuotaReach(true);
        authContext.setApiKey(String.valueOf(uniqueIdentifier) + "_" + apiIdentifier.toString());
        authContext.setTier(tier);
        ArrayList<VerbInfoDTO> verbInfoList = new ArrayList<VerbInfoDTO>(1);
        VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
        verbInfoDTO.setThrottling("Unlimited");
        verbInfoList.add(verbInfoDTO);
        messageContext.setProperty("VERB_INFO", verbInfoList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Auth context for the API " + ajc$this.getAPIIdentifier(messageContext) + ": Username[" + authContext.getUsername() + "APIKey[(" + authContext.getApiKey() + "] Tier[" + authContext.getTier() + "]"));
        }
        APISecurityUtils.setAuthenticationContext(messageContext, authContext, null);
    }

    static final /* synthetic */ APIIdentifier getAPIIdentifier_aroundBody8(MutualSSLAuthenticator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String apiWithversion = (String)messageContext.getProperty("SYNAPSE_REST_API");
        String apiPublisher = (String)messageContext.getProperty("api.ut.apiPublisher");
        String api = null;
        if (apiPublisher == null && apiWithversion != null) {
            int ind = apiWithversion.indexOf("--");
            apiPublisher = apiWithversion.substring(0, ind);
        }
        if (apiWithversion != null) {
            int index = apiWithversion.indexOf("--");
            if (index != -1) {
                apiWithversion = apiWithversion.substring(index + 2);
            }
            String[] splitParts = apiWithversion.split(":");
            api = splitParts[0];
            apiWithversion = splitParts[1].substring(1);
        }
        return new APIIdentifier(apiPublisher, api, apiWithversion);
    }

    static final /* synthetic */ int getPriority_aroundBody14(MutualSSLAuthenticator ajc$this, JoinPoint joinPoint) {
        return 0;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MutualSSLAuthenticator.java", MutualSSLAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "", "", "", "void"), 96);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "org.apache.synapse.MessageContext", "messageContext", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setAuthContext", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "org.apache.synapse.MessageContext:javax.security.cert.X509Certificate", "messageContext:x509Certificate", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "void"), 142);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAPIIdentifier", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "org.apache.synapse.MessageContext", "messageContext", "", "org.wso2.carbon.apimgt.api.model.APIIdentifier"), 200);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "", "", "", "java.lang.String"), 223);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "", "", "", "java.lang.String"), 228);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.MutualSSLAuthenticator", "", "", "", "int"), 233);
    }
}

