/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.basicauth;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.Base64;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.dto.VerbInfoDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BasicAuthAuthenticator
implements Authenticator {
    private static final Log log;
    private final String basicAuthKeyHeaderSegment = "Basic";
    static final String PUBLISHER_TENANT_DOMAIN = "tenant.info.domain";
    private String securityHeader;
    private String requestOrigin;
    private BasicAuthCredentialValidator basicAuthCredentialValidator;
    private OpenAPI openAPI = null;
    private boolean isMandatory;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        BasicAuthAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(BasicAuthAuthenticator.class);
    }

    public BasicAuthAuthenticator(String authorizationHeader, boolean isMandatory) {
        this.securityHeader = authorizationHeader;
        this.isMandatory = isMandatory;
    }

    public void setBasicAuthCredentialValidator(BasicAuthCredentialValidator basicAuthCredentialValidator) {
        BasicAuthCredentialValidator basicAuthCredentialValidator2 = basicAuthCredentialValidator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)basicAuthCredentialValidator2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, basicAuthCredentialValidator2, joinPoint};
            MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.basicAuthCredentialValidator = basicAuthCredentialValidator2;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        BasicAuthAuthenticator.init_aroundBody2(this, synapseEnvironment, joinPoint);
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        BasicAuthAuthenticator.destroy_aroundBody4(this, joinPoint);
    }

    @Override
    @MethodStats
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthAuthenticator.authenticate_aroundBody6(this, messageContext, joinPoint);
    }

    private String[] extractBasicAuthCredentials(String basicAuthHeader) throws APISecurityException {
        String string = basicAuthHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String[])MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthAuthenticator.extractBasicAuthCredentials_aroundBody8(this, string, joinPoint);
    }

    private String extractBasicAuthHeader(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthAuthenticator.extractBasicAuthHeader_aroundBody10(this, messageContext, joinPoint);
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthAuthenticator.getChallengeString_aroundBody12(this, joinPoint);
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.requestOrigin;
    }

    public void setRequestOrigin(String requestOrigin) {
        String string = requestOrigin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.requestOrigin = string;
    }

    private String getEndUserName(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthAuthenticator.getEndUserName_aroundBody18(this, string, joinPoint);
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthAuthenticator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthAuthenticator.getPriority_aroundBody20(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody2(BasicAuthAuthenticator ajc$this, SynapseEnvironment env, JoinPoint joinPoint) {
        try {
            ajc$this.basicAuthCredentialValidator = new BasicAuthCredentialValidator();
        }
        catch (APISecurityException e) {
            log.error((Object)e);
        }
    }

    static final /* synthetic */ void destroy_aroundBody4(BasicAuthAuthenticator ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody6(BasicAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        String[] credentials;
        String authenticationScheme;
        ArrayList<VerbInfoDTO> verbInfoList;
        if (log.isDebugEnabled()) {
            log.info((Object)"Basic Authentication initialized");
        }
        ajc$this.openAPI = (OpenAPI)synCtx.getProperty("OPEN_API_OBJECT");
        if (ajc$this.openAPI == null && !"GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
            log.error((Object)"OpenAPI definition is missing in the gateway. Basic authentication cannot be performed.");
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900911, "Basic authentication cannot be performed.");
        }
        String basicAuthHeader = ajc$this.extractBasicAuthHeader(synCtx);
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
        String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
            HashMap operationAuthSchemeMappingList = (HashMap)synCtx.getProperty("OperationAuthSchemeMapping");
            HashMap operationThrottlingMappingList = (HashMap)synCtx.getProperty("OperationThrottlingMapping");
            String[] operationList = matchingResource.split(",");
            verbInfoList = new ArrayList(1);
            authenticationScheme = "None";
            String[] stringArray = operationList;
            int n = operationList.length;
            int n2 = 0;
            while (n2 < n) {
                String operation = stringArray[n2];
                boolean operationAuthSchemeEnabled = (Boolean)operationAuthSchemeMappingList.get(operation);
                VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
                if (operationAuthSchemeEnabled) {
                    verbInfoDTO.setAuthType("Any");
                    authenticationScheme = "Any";
                } else {
                    verbInfoDTO.setAuthType("None");
                }
                verbInfoDTO.setThrottling((String)operationThrottlingMappingList.get(operation));
                verbInfoDTO.setRequestKey(String.valueOf(apiContext) + "/" + apiVersion + operation + ":" + httpMethod);
                verbInfoList.add(verbInfoDTO);
                ++n2;
            }
        } else {
            authenticationScheme = OpenAPIUtils.getResourceAuthenticationScheme(ajc$this.openAPI, synCtx);
            verbInfoList = new ArrayList<VerbInfoDTO>(1);
            VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
            verbInfoDTO.setAuthType(authenticationScheme);
            verbInfoDTO.setThrottling(OpenAPIUtils.getResourceThrottlingTier(ajc$this.openAPI, synCtx));
            verbInfoDTO.setRequestKey(String.valueOf(apiContext) + "/" + apiVersion + matchingResource + ":" + httpMethod);
            verbInfoList.add(verbInfoDTO);
        }
        if ("None".equals(authenticationScheme)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Basic Authentication: Found Resource Authentication Scheme: ".concat(authenticationScheme));
            }
            String clientIP = null;
            MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            TreeMap transportHeaderMap = (TreeMap)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (transportHeaderMap != null) {
                clientIP = (String)transportHeaderMap.get("X-Forwarded-For");
            }
            if (clientIP != null && !clientIP.isEmpty()) {
                if (clientIP.indexOf(",") > 0) {
                    clientIP = clientIP.substring(0, clientIP.indexOf(","));
                }
            } else {
                clientIP = (String)axis2MessageContext.getProperty("REMOTE_ADDR");
            }
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier("Unauthenticated");
            authContext.setStopOnQuotaReach(true);
            authContext.setApiKey(clientIP);
            authContext.setKeyType("PRODUCTION");
            authContext.setUsername("anonymous");
            authContext.setCallerToken(null);
            authContext.setApplicationName(null);
            authContext.setApplicationId(clientIP);
            authContext.setConsumerKey(null);
            APISecurityUtils.setAuthenticationContext(synCtx, authContext, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Basic Authentication: Authentication succeeded by ignoring auth headers for API resource: ".concat(matchingResource));
            }
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        try {
            credentials = ajc$this.extractBasicAuthCredentials(basicAuthHeader);
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
        }
        String username = ajc$this.getEndUserName(credentials[0]);
        String password = credentials[1];
        if (!MultitenantUtils.getTenantDomain((String)username).equals(synCtx.getProperty(PUBLISHER_TENANT_DOMAIN))) {
            log.error((Object)("Basic Authentication failure: tenant domain mismatch for user :" + username));
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900908, "Resource forbidden ");
        }
        boolean authenticated = false;
        try {
            authenticated = ajc$this.basicAuthCredentialValidator.validate(username, password);
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
        }
        if (!authenticated) {
            log.error((Object)"Basic Authentication failure: Username and Password mismatch");
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900901, "Invalid Credentials");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Basic Authentication: Username and Password authenticated");
        }
        boolean scopesValid = false;
        try {
            scopesValid = ajc$this.basicAuthCredentialValidator.validateScopes(username, ajc$this.openAPI, synCtx);
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
        }
        if (scopesValid) {
            if (APISecurityUtils.getAuthenticationContext(synCtx) == null) {
                AuthenticationContext authContext = new AuthenticationContext();
                authContext.setAuthenticated(true);
                authContext.setTier("Unauthenticated");
                authContext.setStopOnQuotaReach(true);
                synCtx.setProperty("VERB_INFO", verbInfoList);
                authContext.setApiKey(username);
                authContext.setKeyType("PRODUCTION");
                authContext.setUsername(username);
                authContext.setCallerToken(null);
                authContext.setApplicationName("BasicAuthApplication");
                authContext.setApplicationId(username);
                authContext.setConsumerKey(null);
                APISecurityUtils.setAuthenticationContext(synCtx, authContext, null);
            }
            log.debug((Object)"Basic Authentication: Scope validation passed");
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900910, "Scope validation failed");
    }

    static final /* synthetic */ String[] extractBasicAuthCredentials_aroundBody8(BasicAuthAuthenticator ajc$this, String basicAuthHeader, JoinPoint joinPoint) {
        if (basicAuthHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Basic Authentication: No Basic Auth Header found");
            }
            throw new APISecurityException(900902, "Missing Credentials");
        }
        if (basicAuthHeader.contains("Basic")) {
            try {
                String basicAuthKey = new String(Base64.decode((String)basicAuthHeader.substring("Basic".length() + 1).trim()));
                if (basicAuthKey.contains(":")) {
                    return basicAuthKey.split(":");
                }
                log.error((Object)"Basic Authentication: Invalid Basic Auth token");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            catch (WSSecurityException wSSecurityException) {
                log.error((Object)"Error occured during Basic Authentication: Invalid Basic Auth token");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Basic Authentication: No Basic Auth Header found");
        }
        throw new APISecurityException(900902, "Missing Credentials");
    }

    static final /* synthetic */ String extractBasicAuthHeader_aroundBody10(BasicAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            String authHeader = (String)headers.get(ajc$this.securityHeader);
            if (authHeader == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Basic Authentication: Expected authorization header with the name '".concat(ajc$this.securityHeader).concat("' was not found."));
                }
                return null;
            }
            if (authHeader.contains("Basic")) {
                String[] authHeaderArr = authHeader.split(",");
                ArrayList<String> remainingAuthHeaders = new ArrayList<String>();
                String basicAuthHeader = null;
                String[] stringArray = authHeaderArr;
                int n = authHeaderArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String headerSegment = stringArray[n2];
                    if (headerSegment.trim().split(" ")[0].equals("Basic")) {
                        basicAuthHeader = headerSegment.trim();
                    } else {
                        remainingAuthHeaders.add(headerSegment.trim());
                    }
                    ++n2;
                }
                String remainingAuthHeader = String.join((CharSequence)",", remainingAuthHeaders);
                if (StringUtils.isNotBlank((CharSequence)remainingAuthHeader)) {
                    headers.put(ajc$this.securityHeader, remainingAuthHeader);
                } else {
                    headers.remove(ajc$this.securityHeader);
                }
                return basicAuthHeader;
            }
        }
        return null;
    }

    static final /* synthetic */ String getChallengeString_aroundBody12(BasicAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return "Basic Auth realm=\"WSO2 API Manager\"";
    }

    static final /* synthetic */ String getEndUserName_aroundBody18(BasicAuthAuthenticator ajc$this, String username, JoinPoint joinPoint) {
        return String.valueOf(MultitenantUtils.getTenantAwareUsername((String)username)) + "@" + MultitenantUtils.getTenantDomain((String)username);
    }

    static final /* synthetic */ int getPriority_aroundBody20(BasicAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return 20;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BasicAuthAuthenticator.java", BasicAuthAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBasicAuthCredentialValidator", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "basicAuthCredentialValidator", "", "void"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 85);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "", "", "", "int"), 406);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "", "", "", "void"), 97);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 108);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractBasicAuthCredentials", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "java.lang.String", "basicAuthHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "[Ljava.lang.String;"), 293);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractBasicAuthHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "java.lang.String"), 333);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "", "", "", "java.lang.String"), 378);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "", "", "", "java.lang.String"), 388);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "java.lang.String", "requestOrigin", "", "void"), 397);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getEndUserName", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthAuthenticator", "java.lang.String", "username", "", "java.lang.String"), 401);
    }
}

