/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.basicauth;

import io.swagger.v3.oas.models.OpenAPI;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.keymgt.stub.usermanager.APIKeyMgtRemoteUserStoreMgtServiceAPIManagementException;
import org.wso2.carbon.apimgt.keymgt.stub.usermanager.APIKeyMgtRemoteUserStoreMgtServiceStub;
import org.wso2.carbon.utils.CarbonUtils;

public class BasicAuthCredentialValidator {
    private boolean gatewayKeyCacheEnabled;
    protected Log log = LogFactory.getLog(this.getClass());
    private APIKeyMgtRemoteUserStoreMgtServiceStub apiKeyMgtRemoteUserStoreMgtServiceStub;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    BasicAuthCredentialValidator() throws APISecurityException {
        this.gatewayKeyCacheEnabled = this.isGatewayTokenCacheEnabled();
        this.getGatewayUsernameCache();
        ConfigurationContext configurationContext = ServiceReferenceHolder.getInstance().getAxis2ConfigurationContext();
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
        String username = config.getFirstProperty("APIKeyValidator.Username");
        String password = config.getFirstProperty("APIKeyValidator.Password");
        String url = config.getFirstProperty("APIKeyValidator.ServerURL");
        if (url == null) {
            throw new APISecurityException(900900, "API key manager URL unspecified");
        }
        try {
            this.apiKeyMgtRemoteUserStoreMgtServiceStub = new APIKeyMgtRemoteUserStoreMgtServiceStub(configurationContext, String.valueOf(url) + "APIKeyMgtRemoteUserStoreMgtService");
            ServiceClient client = this.apiKeyMgtRemoteUserStoreMgtServiceStub._getServiceClient();
            Options options = client.getOptions();
            options.setCallTransportCleanup(true);
            options.setManageSession(true);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (ServiceClient)client);
        }
        catch (AxisFault axisFault) {
            throw new APISecurityException(900900, axisFault.getMessage(), axisFault);
        }
    }

    @MethodStats
    public boolean validate(String username, String password) throws APISecurityException {
        String string = username;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.validate_aroundBody0(this, string, string2, joinPoint);
    }

    @MethodStats
    public boolean validateScopes(String username, OpenAPI openAPI, MessageContext synCtx) throws APISecurityException {
        String string = username;
        OpenAPI openAPI2 = openAPI;
        MessageContext messageContext = synCtx;
        Object[] objectArray = new Object[]{string, openAPI2, messageContext};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, openAPI2, messageContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.validateScopes_aroundBody2(this, string, openAPI2, messageContext, joinPoint);
    }

    private String[] getUserRoles(String username) throws APISecurityException {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String[])MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getUserRoles_aroundBody4(this, string, joinPoint);
    }

    private String hashString(String str) {
        String string = str;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.hashString_aroundBody6(this, string, joinPoint);
    }

    private Cache getGatewayBasicAuthResourceCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getGatewayBasicAuthResourceCache_aroundBody8(this, joinPoint);
    }

    private Cache getGatewayUsernameCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getGatewayUsernameCache_aroundBody10(this, joinPoint);
    }

    private Cache getInvalidUsernameCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getInvalidUsernameCache_aroundBody12(this, joinPoint);
    }

    private APIManagerConfiguration getApiManagerConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerConfiguration)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getApiManagerConfiguration_aroundBody14(this, joinPoint);
    }

    private Cache getCacheFromCacheManager(String cacheName) {
        String string = cacheName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getCacheFromCacheManager_aroundBody16(this, string, joinPoint);
    }

    private boolean isGatewayTokenCacheEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.isGatewayTokenCacheEnabled_aroundBody18(this, joinPoint);
    }

    static {
        BasicAuthCredentialValidator.ajc$preClinit();
    }

    static final /* synthetic */ boolean validate_aroundBody0(BasicAuthCredentialValidator ajc$this, String username, String password, JoinPoint joinPoint) {
        boolean authenticated;
        String providedPasswordHash = null;
        if (ajc$this.gatewayKeyCacheEnabled) {
            providedPasswordHash = ajc$this.hashString(password);
            String cachedPasswordHash = (String)ajc$this.getGatewayUsernameCache().get((Object)username);
            if (cachedPasswordHash != null && cachedPasswordHash.equals(providedPasswordHash)) {
                ajc$this.log.debug((Object)"Basic Authentication: <Valid Username Cache> Username & password authenticated");
                return true;
            }
            String invalidCachedPasswordHash = (String)ajc$this.getInvalidUsernameCache().get((Object)username);
            if (invalidCachedPasswordHash != null && invalidCachedPasswordHash.equals(providedPasswordHash)) {
                ajc$this.log.debug((Object)"Basic Authentication: <Invalid Username Cache> Username & password authentication failed");
                return false;
            }
        }
        try {
            authenticated = ajc$this.apiKeyMgtRemoteUserStoreMgtServiceStub.authenticate(username, password);
        }
        catch (RemoteException | APIKeyMgtRemoteUserStoreMgtServiceAPIManagementException e) {
            ajc$this.log.debug((Object)"Basic Authentication: Username and Password authentication failure");
            throw new APISecurityException(900900, e.getMessage(), e);
        }
        if (ajc$this.gatewayKeyCacheEnabled) {
            if (authenticated) {
                ajc$this.getGatewayUsernameCache().put((Object)username, (Object)providedPasswordHash);
            } else {
                ajc$this.getInvalidUsernameCache().put((Object)username, (Object)providedPasswordHash);
            }
        }
        return authenticated;
    }

    /*
     * Unable to fully structure code
     */
    static final /* synthetic */ boolean validateScopes_aroundBody2(BasicAuthCredentialValidator ajc$this, String username, OpenAPI openAPI, MessageContext synCtx, JoinPoint var4_4) {
        apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        apiElectedResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        userRoles = null;
        axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        httpMethod = (String)axis2MessageContext.getProperty("HTTP_METHOD");
        resourceKey = String.valueOf(apiContext) + ":" + apiVersion + ":" + apiElectedResource + ":" + httpMethod;
        resourceCacheKey = String.valueOf(resourceKey) + ":" + username;
        if (ajc$this.gatewayKeyCacheEnabled && ajc$this.getGatewayBasicAuthResourceCache().get((Object)resourceCacheKey) != null) {
            return true;
        }
        if (openAPI == null) ** GOTO lbl34
        resourceRoles = null;
        resourceScope = OpenAPIUtils.getScopesOfResource(openAPI, synCtx);
        if (resourceScope != null) {
            resourceRoles = OpenAPIUtils.getRolesOfScope(openAPI, synCtx, resourceScope);
        }
        if (StringUtils.isNotBlank(resourceRoles)) {
            var25_17 = userRoles = ajc$this.getUserRoles(username);
            var27_19 = userRoles.length;
            var29_21 = 0;
            while (var29_21 < var27_19) {
                role = var25_17[var29_21];
                if (resourceRoles.contains(role)) {
                    if (ajc$this.gatewayKeyCacheEnabled) {
                        ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                    }
                    return true;
                }
                ++var29_21;
            }
        } else {
            if (ajc$this.gatewayKeyCacheEnabled) {
                ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
            }
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)"Basic Authentication: No scopes for the API resource: ".concat(resourceKey));
            }
            return true;
lbl34:
            // 1 sources

            if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                operationScopeMappingList = (HashMap)synCtx.getProperty("ScopeOperationMapping");
                scopeRoleMappingList = (HashMap)synCtx.getProperty("ScopeRoleMapping");
                operationList = ((String)synCtx.getProperty("API_ELECTED_RESOURCE")).split(",");
                userRoles = ajc$this.getUserRoles(username);
                var33_25 = operationList;
                var25_18 = operationList.length;
                var27_20 = 0;
                while (var27_20 < var25_18) {
                    operation = var33_25[var27_20];
                    operationScope = (String)operationScopeMappingList.get(operation);
                    if (operationScope != null) {
                        operationRoles = (ArrayList)scopeRoleMappingList.get(operationScope);
                        userHasOperationRole = false;
                        var41_29 = userRoles;
                        var43_30 = userRoles.length;
                        var45_31 = 0;
                        while (var45_31 < var43_30) {
                            role = var41_29[var45_31];
                            for (String operationRole : operationRoles) {
                                if (!operationRole.equals(role)) continue;
                                userHasOperationRole = true;
                                break;
                            }
                            if (userHasOperationRole) break;
                            ++var45_31;
                        }
                        if (!userHasOperationRole) {
                            throw new APISecurityException(900910, "Scope validation failed");
                        }
                    }
                    ++var27_20;
                }
                if (ajc$this.gatewayKeyCacheEnabled) {
                    ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                }
                return true;
            }
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)"Basic Authentication: No OpenAPI found in the gateway for the API: ".concat(apiContext).concat(":").concat(apiVersion));
            }
            return true;
        }
        if (ajc$this.log.isDebugEnabled()) {
            ajc$this.log.debug((Object)"Basic Authentication: Scope validation failed for the API resource: ".concat(apiElectedResource));
        }
        throw new APISecurityException(900910, "Scope validation failed");
    }

    static final /* synthetic */ String[] getUserRoles_aroundBody4(BasicAuthCredentialValidator ajc$this, String username, JoinPoint joinPoint) {
        String[] userRoles;
        try {
            userRoles = ajc$this.apiKeyMgtRemoteUserStoreMgtServiceStub.getUserRoles(username);
        }
        catch (RemoteException | APIKeyMgtRemoteUserStoreMgtServiceAPIManagementException e) {
            throw new APISecurityException(900900, e.getMessage(), e);
        }
        return userRoles;
    }

    static final /* synthetic */ String hashString_aroundBody6(BasicAuthCredentialValidator ajc$this, String str, JoinPoint joinPoint) {
        String generatedHash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = md.digest();
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte aByte = byArray[n2];
                sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
                ++n2;
            }
            generatedHash = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            ajc$this.log.error((Object)e.getMessage());
        }
        return generatedHash;
    }

    static final /* synthetic */ Cache getGatewayBasicAuthResourceCache_aroundBody8(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayBasicAuthResourceCache();
    }

    static final /* synthetic */ Cache getGatewayUsernameCache_aroundBody10(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayUsernameCache();
    }

    static final /* synthetic */ Cache getInvalidUsernameCache_aroundBody12(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidUsernameCache();
    }

    static final /* synthetic */ APIManagerConfiguration getApiManagerConfiguration_aroundBody14(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
    }

    static final /* synthetic */ Cache getCacheFromCacheManager_aroundBody16(BasicAuthCredentialValidator ajc$this, String cacheName, JoinPoint joinPoint) {
        return Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache(cacheName);
    }

    static final /* synthetic */ boolean isGatewayTokenCacheEnabled_aroundBody18(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        try {
            APIManagerConfiguration config = ajc$this.getApiManagerConfiguration();
            String cacheEnabled = config.getFirstProperty("CacheConfigurations.EnableGatewayTokenCache");
            return Boolean.parseBoolean(cacheEnabled);
        }
        catch (Exception e) {
            ajc$this.log.error((Object)("Did not found valid API Validation Information cache configuration. Use default configuration " + e), (Throwable)e);
            return true;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BasicAuthCredentialValidator.java", BasicAuthCredentialValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validate", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String:java.lang.String", "username:password", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 114);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateScopes", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String:io.swagger.v3.oas.models.OpenAPI:org.apache.synapse.MessageContext", "username:openAPI:synCtx", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 162);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserRoles", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String", "username", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "[Ljava.lang.String;"), 253);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "hashString", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String", "str", "", "java.lang.String"), 269);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayBasicAuthResourceCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 295);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayUsernameCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 302);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInvalidUsernameCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 309);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiManagerConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerConfiguration"), 318);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCacheFromCacheManager", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String", "cacheName", "", "javax.cache.Cache"), 328);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isGatewayTokenCacheEnabled", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "boolean"), 338);
    }
}

