/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.gateway.dto.JWTTokenPayloadInfo;
import org.wso2.carbon.apimgt.gateway.handlers.WebsocketUtil;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure29;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.transformer.JWTTransformer;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTDataHolder;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.dto.TokenIssuerDto;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;

public class JWTValidator {
    private static final Log log;
    private String apiLevelPolicy;
    private boolean isGatewayTokenCacheEnabled;
    private APIKeyValidator apiKeyValidator;
    private boolean jwtGenerationEnabled;
    private AbstractAPIMgtGatewayJWTGenerator apiMgtGatewayJWTGenerator;
    JWTConfigurationDto jwtConfigurationDto;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    static {
        JWTValidator.ajc$preClinit();
        log = LogFactory.getLog(JWTValidator.class);
    }

    public JWTValidator(String apiLevelPolicy, APIKeyValidator apiKeyValidator) {
        this.apiLevelPolicy = apiLevelPolicy;
        this.isGatewayTokenCacheEnabled = GatewayUtils.isGatewayTokenCacheEnabled();
        this.apiKeyValidator = apiKeyValidator;
        this.jwtConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getJwtConfigurationDto();
        this.jwtGenerationEnabled = this.jwtConfigurationDto.isEnabled();
        this.apiMgtGatewayJWTGenerator = ServiceReferenceHolder.getInstance().getApiMgtGatewayJWTGenerator().get(this.jwtConfigurationDto.getGatewayJWTGeneratorImpl());
    }

    @MethodStats
    public AuthenticationContext authenticate(String jwtToken, MessageContext synCtx, OpenAPI openAPI) throws APISecurityException {
        String string = jwtToken;
        MessageContext messageContext = synCtx;
        OpenAPI openAPI2 = openAPI;
        Object[] objectArray = new Object[]{string, messageContext, openAPI2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, messageContext, openAPI2, joinPoint};
            return (AuthenticationContext)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.authenticate_aroundBody0(this, string, messageContext, openAPI2, joinPoint);
    }

    private String generateAndRetrieveJWTToken(String tokenSignature, JWTInfoDto jwtInfoDto) throws APISecurityException {
        String string = tokenSignature;
        JWTInfoDto jWTInfoDto = jwtInfoDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)jWTInfoDto);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, jWTInfoDto, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.generateAndRetrieveJWTToken_aroundBody2(this, string, jWTInfoDto, joinPoint);
    }

    private APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager(MessageContext synCtx, JWTClaimsSet payload) throws APISecurityException {
        MessageContext messageContext = synCtx;
        JWTClaimsSet jWTClaimsSet = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext, (Object)jWTClaimsSet);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, jWTClaimsSet, joinPoint};
            return (APIKeyValidationInfoDTO)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.validateSubscriptionUsingKeyManager_aroundBody4(this, messageContext, jWTClaimsSet, joinPoint);
    }

    @MethodStats
    public AuthenticationContext authenticateForWebSocket(String jwtToken, String apiContext, String apiVersion) throws APISecurityException {
        String string = jwtToken;
        String string2 = apiContext;
        String string3 = apiVersion;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            return (AuthenticationContext)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.authenticateForWebSocket_aroundBody6(this, string, string2, string3, joinPoint);
    }

    private void validateScopes(MessageContext synCtx, OpenAPI openAPI, JWTClaimsSet payload) throws APISecurityException, ParseException {
        MessageContext messageContext = synCtx;
        OpenAPI openAPI2 = openAPI;
        JWTClaimsSet jWTClaimsSet = payload;
        Object[] objectArray = new Object[]{messageContext, openAPI2, jWTClaimsSet};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, messageContext, openAPI2, jWTClaimsSet, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidator.validateScopes_aroundBody8(this, messageContext, openAPI2, jWTClaimsSet, joinPoint);
    }

    private void checkTokenWithTheScope(String resource, String resourceScope, JWTClaimsSet payload) throws APISecurityException, ParseException {
        String string = resource;
        String string2 = resourceScope;
        JWTClaimsSet jWTClaimsSet = payload;
        Object[] objectArray = new Object[]{string, string2, jWTClaimsSet};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, jWTClaimsSet, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidator.checkTokenWithTheScope_aroundBody10(this, string, string2, jWTClaimsSet, joinPoint);
    }

    private void checkTokenExpiration(String tokenSignature, JWTClaimsSet payload, String tenantDomain) throws APISecurityException {
        String string = tokenSignature;
        JWTClaimsSet jWTClaimsSet = payload;
        String string2 = tenantDomain;
        Object[] objectArray = new Object[]{string, jWTClaimsSet, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, jWTClaimsSet, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidator.checkTokenExpiration_aroundBody12(this, string, jWTClaimsSet, string2, joinPoint);
    }

    private JWTClaimsSet transformJWTClaims(JWTClaimsSet body) {
        JWTClaimsSet jWTClaimsSet = body;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)jWTClaimsSet);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jWTClaimsSet, joinPoint};
            return (JWTClaimsSet)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.transformJWTClaims_aroundBody14(this, jWTClaimsSet, joinPoint);
    }

    private Cache getGatewayTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayTokenCache_aroundBody16(this, joinPoint);
    }

    private Cache getInvalidTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getInvalidTokenCache_aroundBody18(this, joinPoint);
    }

    private Cache getGatewayKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayKeyCache_aroundBody20(this, joinPoint);
    }

    private Cache getGatewayJWTTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayJWTTokenCache_aroundBody22(this, joinPoint);
    }

    private String getApiLevelPolicy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.apiLevelPolicy;
    }

    private boolean verifyTokenSignature(SignedJWT parsedJWTToken, String certificateAlias) throws APISecurityException {
        SignedJWT signedJWT = parsedJWTToken;
        String string = certificateAlias;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)signedJWT, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, signedJWT, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidator.verifyTokenSignature_aroundBody26(this, signedJWT, string, joinPoint);
    }

    private Cache getJWKSCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getJWKSCache_aroundBody28(this, joinPoint);
    }

    static final /* synthetic */ AuthenticationContext authenticate_aroundBody0(JWTValidator ajc$this, String jwtToken, MessageContext synCtx, OpenAPI openAPI, JoinPoint joinPoint) {
        SignedJWT parsedJWTToken;
        String[] splitToken = jwtToken.split("\\.");
        JWTClaimsSet payload = null;
        boolean isVerified = false;
        String tokenSignature = splitToken[2];
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
        String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        String cacheKey = GatewayUtils.getAccessTokenCacheKey(tokenSignature, apiContext, apiVersion, matchingResource, httpMethod);
        String tenantDomain = GatewayUtils.getTenantDomain();
        JWTTokenPayloadInfo payloadInfo = null;
        if (ajc$this.isGatewayTokenCacheEnabled) {
            String cacheToken = (String)ajc$this.getGatewayTokenCache().get((Object)tokenSignature);
            if (cacheToken != null) {
                log.debug((Object)"Token retrieved from the token cache.");
                if (ajc$this.getGatewayKeyCache().get((Object)cacheKey) != null) {
                    payloadInfo = (JWTTokenPayloadInfo)ajc$this.getGatewayKeyCache().get((Object)cacheKey);
                    String rawPayload = payloadInfo.getRawPayload();
                    isVerified = rawPayload.equals(splitToken[1]);
                }
            } else {
                if (ajc$this.getInvalidTokenCache().get((Object)tokenSignature) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Token retrieved from the invalid token cache. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
                    throw new APISecurityException(900901, "Invalid JWT token");
                }
                if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
                    throw new APISecurityException(900901, "Invalid JWT token");
                }
            }
        } else if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
            }
            log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        if (!isVerified) {
            JWSHeader header;
            log.debug((Object)"Token not found in the caches and revoked jwt token map.");
            try {
                parsedJWTToken = (SignedJWT)JWTParser.parse((String)jwtToken);
                header = parsedJWTToken.getHeader();
                payload = ajc$this.transformJWTClaims(parsedJWTToken.getJWTClaimsSet());
            }
            catch (IllegalArgumentException | ParseException | JSONException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid JWT token. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)"Invalid JWT token. Failed to decode the token.");
                throw new APISecurityException(900901, "Invalid JWT token. Failed to decode the token.", e);
            }
            log.debug((Object)"Verifying signature of JWT");
            String certificateAlias = "gateway_certificate_alias";
            if (header.getKeyID() != null) {
                certificateAlias = header.getKeyID();
            }
            isVerified = ajc$this.verifyTokenSignature(parsedJWTToken, certificateAlias);
            if (ajc$this.isGatewayTokenCacheEnabled) {
                if (isVerified) {
                    ajc$this.getGatewayTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                } else {
                    ajc$this.getInvalidTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                }
                if (!"carbon.super".equals(tenantDomain)) {
                    try {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
                        if (isVerified) {
                            ajc$this.getGatewayTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                        } else {
                            ajc$this.getInvalidTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                        }
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
            }
        }
        if (isVerified) {
            log.debug((Object)"Token signature is verified.");
            if (ajc$this.isGatewayTokenCacheEnabled && payloadInfo != null) {
                payload = payloadInfo.getPayload();
                ajc$this.checkTokenExpiration(tokenSignature, payload, tenantDomain);
            } else {
                log.debug((Object)"Token payload not found in the cache.");
                if (payload == null) {
                    try {
                        parsedJWTToken = (SignedJWT)JWTParser.parse((String)jwtToken);
                        payload = ajc$this.transformJWTClaims(parsedJWTToken.getJWTClaimsSet());
                    }
                    catch (IllegalArgumentException | ParseException | JSONException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Token decryption failure when retrieving payload. Token: " + GatewayUtils.getMaskedToken(splitToken[0])), e);
                        }
                        log.error((Object)"Invalid JWT token. Failed to decode the token");
                        throw new APISecurityException(900901, "Invalid JWT token");
                    }
                }
                ajc$this.checkTokenExpiration(tokenSignature, payload, tenantDomain);
                try {
                    ajc$this.validateScopes(synCtx, openAPI, payload);
                }
                catch (ParseException parseException) {
                    throw new APISecurityException(900900, "Unclassified Authentication Failure");
                }
                if (ajc$this.isGatewayTokenCacheEnabled) {
                    JWTTokenPayloadInfo jwtTokenPayloadInfo = new JWTTokenPayloadInfo();
                    jwtTokenPayloadInfo.setPayload(payload);
                    jwtTokenPayloadInfo.setRawPayload(splitToken[1]);
                    ajc$this.getGatewayKeyCache().put((Object)cacheKey, (Object)jwtTokenPayloadInfo);
                }
            }
            net.minidev.json.JSONObject api = GatewayUtils.validateAPISubscription(apiContext, apiVersion, payload, splitToken, true);
            if (api != null) {
                synCtx.setProperty("api.ut.apiPublisher", api.get((Object)"publisher"));
            } else {
                boolean validateSubscriptionViaKM = Boolean.parseBoolean(ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getFirstProperty("JWTAuthentication.EnableSubscriptionValidationViaKeyManager"));
                if (validateSubscriptionViaKM) {
                    log.debug((Object)"Begin subscription validation via Key Manager");
                    APIKeyValidationInfoDTO apiKeyValidationInfoDTO = ajc$this.validateSubscriptionUsingKeyManager(synCtx, payload);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Subscription validation via Key Manager. Status: " + apiKeyValidationInfoDTO.isAuthorized()));
                    }
                    if (apiKeyValidationInfoDTO.isAuthorized()) {
                        synCtx.setProperty("api.ut.apiPublisher", (Object)apiKeyValidationInfoDTO.getApiPublisher());
                        log.debug((Object)"JWT authentication successful.");
                        String endUserToken = null;
                        if (ajc$this.jwtGenerationEnabled) {
                            try {
                                JWTInfoDto jwtInfoDto = GatewayUtils.generateJWTInfoDto(payload, api, apiKeyValidationInfoDTO, synCtx);
                                endUserToken = ajc$this.generateAndRetrieveJWTToken(tokenSignature, jwtInfoDto);
                                return GatewayUtils.generateAuthenticationContext(tokenSignature, payload, null, apiKeyValidationInfoDTO, ajc$this.getApiLevelPolicy(), endUserToken, true);
                            }
                            catch (ParseException parseException) {
                                throw new APISecurityException(900900, "Unclassified Authentication Failure");
                            }
                        }
                    } else {
                        log.debug((Object)"User is NOT authorized to access the Resource. API Subscription validation failed.");
                        throw new APISecurityException(apiKeyValidationInfoDTO.getValidationStatus(), "User is NOT authorized to access the Resource. API Subscription validation failed.");
                    }
                }
                log.debug((Object)"Ignored subscription validation");
            }
            log.debug((Object)"JWT authentication successful.");
            String endUserToken = null;
            try {
                if (ajc$this.jwtGenerationEnabled) {
                    JWTInfoDto jwtInfoDto = GatewayUtils.generateJWTInfoDto(payload, api, null, synCtx);
                    endUserToken = ajc$this.generateAndRetrieveJWTToken(tokenSignature, jwtInfoDto);
                }
                return GatewayUtils.generateAuthenticationContext(tokenSignature, payload, api, null, ajc$this.getApiLevelPolicy(), endUserToken, true);
            }
            catch (ParseException parseException) {
                throw new APISecurityException(900900, "Unclassified Authentication Failure");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Token signature verification failure. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
        }
        throw new APISecurityException(900901, "Invalid JWT token. Signature verification failed.");
    }

    static final /* synthetic */ String generateAndRetrieveJWTToken_aroundBody2(JWTValidator ajc$this, String tokenSignature, JWTInfoDto jwtInfoDto, JoinPoint joinPoint) {
        String endUserToken = null;
        boolean valid = false;
        if (ajc$this.isGatewayTokenCacheEnabled) {
            Object token = ajc$this.getGatewayJWTTokenCache().get((Object)tokenSignature);
            if (token != null) {
                endUserToken = (String)token;
                String[] splitToken = ((String)token).split("\\.");
                JSONObject payload = new JSONObject(new String(Base64.getUrlDecoder().decode(splitToken[1])));
                long exp = payload.getLong("exp");
                long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
                boolean bl = valid = exp - System.currentTimeMillis() > timestampSkew;
            }
            if (StringUtils.isEmpty((String)endUserToken) || !valid) {
                try {
                    endUserToken = ajc$this.apiMgtGatewayJWTGenerator.generateToken(jwtInfoDto);
                    ajc$this.getGatewayJWTTokenCache().put((Object)tokenSignature, (Object)endUserToken);
                }
                catch (APIManagementException e) {
                    log.error((Object)"Error while Generating Backend JWT", (Throwable)e);
                    throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
                }
            }
        } else {
            try {
                endUserToken = ajc$this.apiMgtGatewayJWTGenerator.generateToken(jwtInfoDto);
            }
            catch (APIManagementException e) {
                log.error((Object)"Error while Generating Backend JWT", (Throwable)e);
                throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
            }
        }
        return endUserToken;
    }

    static final /* synthetic */ APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager_aroundBody4(JWTValidator ajc$this, MessageContext synCtx, JWTClaimsSet payload, JoinPoint joinPoint) {
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        try {
            String consumerkey = null;
            if (payload.getClaim("consumerKey") != null) {
                consumerkey = payload.getStringClaim("consumerKey");
            } else if (payload.getClaim("azp") != null) {
                consumerkey = payload.getStringClaim("azp");
            }
            if (consumerkey != null) {
                return ajc$this.apiKeyValidator.validateSubscription(apiContext, apiVersion, consumerkey);
            }
            log.debug((Object)"Cannot call Key Manager to validate subscription. Payload of the token does not contain the Authorized party - the party to which the ID Token was issued");
            throw new APISecurityException(900908, "Resource forbidden ");
        }
        catch (ParseException parseException) {
            throw new APISecurityException(900900, "Unclassified Authentication Failure");
        }
    }

    static final /* synthetic */ AuthenticationContext authenticateForWebSocket_aroundBody6(JWTValidator ajc$this, String jwtToken, String apiContext, String apiVersion, JoinPoint joinPoint) {
        String[] splitToken = jwtToken.split("\\.");
        SignedJWT parsedJWT = null;
        JWTClaimsSet payload = null;
        boolean isVerified = false;
        String tokenSignature = splitToken[2];
        String tenantDomain = GatewayUtils.getTenantDomain();
        JWTTokenPayloadInfo payloadInfo = null;
        String cacheKey = WebsocketUtil.getAccessTokenCacheKey(tokenSignature, apiContext);
        if (ajc$this.isGatewayTokenCacheEnabled) {
            String cacheToken = (String)ajc$this.getGatewayTokenCache().get((Object)tokenSignature);
            if (cacheToken != null) {
                log.debug((Object)"Token retrieved from the token cache.");
                if (ajc$this.getGatewayKeyCache().get((Object)cacheKey) != null) {
                    payloadInfo = (JWTTokenPayloadInfo)ajc$this.getGatewayKeyCache().get((Object)cacheKey);
                    String rawPayload = payloadInfo.getRawPayload();
                    isVerified = rawPayload.equals(splitToken[1]);
                }
            } else {
                if (ajc$this.getInvalidTokenCache().get((Object)tokenSignature) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Token retrieved from the invalid token cache. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
                    throw new APISecurityException(900901, "Invalid JWT token");
                }
                if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
                    throw new APISecurityException(900901, "Invalid JWT token");
                }
            }
        } else if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
            }
            log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(splitToken[0])));
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        if (!isVerified) {
            log.debug((Object)"Token not found in the caches and revoked jwt token map.");
            try {
                parsedJWT = (SignedJWT)JWTParser.parse((String)jwtToken);
                payload = parsedJWT.getJWTClaimsSet();
            }
            catch (IllegalArgumentException | ParseException | JSONException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid JWT token. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)"Invalid JWT token. Failed to decode the token.");
                throw new APISecurityException(900901, "Invalid JWT token. Failed to decode the token.", e);
            }
            log.debug((Object)"Verifying signature of JWT");
            isVerified = ajc$this.verifyTokenSignature(parsedJWT, "gateway_certificate_alias");
            if (ajc$this.isGatewayTokenCacheEnabled) {
                if (isVerified) {
                    ajc$this.getGatewayTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                } else {
                    ajc$this.getInvalidTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                }
                if (!"carbon.super".equals(tenantDomain)) {
                    try {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
                        if (isVerified) {
                            ajc$this.getGatewayTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                        } else {
                            ajc$this.getInvalidTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
                        }
                    }
                    finally {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
            }
        }
        if (isVerified) {
            log.debug((Object)"Token signature is verified.");
            if (ajc$this.isGatewayTokenCacheEnabled && payloadInfo != null) {
                payload = payloadInfo.getPayload();
                ajc$this.checkTokenExpiration(tokenSignature, payload, tenantDomain);
            } else {
                log.debug((Object)"Token payload not found in the cache.");
                if (payload == null) {
                    try {
                        parsedJWT = (SignedJWT)JWTParser.parse((String)jwtToken);
                        payload = parsedJWT.getJWTClaimsSet();
                    }
                    catch (IllegalArgumentException | ParseException | JSONException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Token decryption failure when retrieving payload. Token: " + GatewayUtils.getMaskedToken(splitToken[0])), e);
                        }
                        log.error((Object)"Invalid JWT token. Failed to decode the token");
                        throw new APISecurityException(900901, "Invalid JWT token");
                    }
                }
                ajc$this.checkTokenExpiration(tokenSignature, payload, tenantDomain);
                if (ajc$this.isGatewayTokenCacheEnabled) {
                    JWTTokenPayloadInfo jwtTokenPayloadInfo = new JWTTokenPayloadInfo();
                    jwtTokenPayloadInfo.setPayload(payload);
                    jwtTokenPayloadInfo.setRawPayload(splitToken[1]);
                    ajc$this.getGatewayKeyCache().put((Object)cacheKey, (Object)jwtTokenPayloadInfo);
                }
            }
            net.minidev.json.JSONObject api = GatewayUtils.validateAPISubscription(apiContext, apiVersion, payload, splitToken, true);
            log.debug((Object)"JWT authentication successful.");
            String endUserToken = null;
            try {
                if (ajc$this.jwtGenerationEnabled) {
                    JWTInfoDto jwtInfoDto = null;
                    jwtInfoDto = GatewayUtils.generateJWTInfoDto(payload, api, null, apiContext, apiVersion);
                    endUserToken = ajc$this.generateAndRetrieveJWTToken(tokenSignature, jwtInfoDto);
                }
                return GatewayUtils.generateAuthenticationContext(tokenSignature, payload, api, null, ajc$this.getApiLevelPolicy(), endUserToken, true);
            }
            catch (ParseException parseException) {
                throw new APISecurityException(900900, "Unclassified Authentication Failure");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Token signature verification failure. Token: " + GatewayUtils.getMaskedToken(splitToken[0])));
        }
        throw new APISecurityException(900901, "Invalid JWT token. Signature verification failed.");
    }

    static final /* synthetic */ void validateScopes_aroundBody8(JWTValidator ajc$this, MessageContext synCtx, OpenAPI openAPI, JWTClaimsSet payload, JoinPoint joinPoint) {
        if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
            String[] operationList;
            HashMap operationScopeMappingList = (HashMap)synCtx.getProperty("ScopeOperationMapping");
            String[] stringArray = operationList = ((String)synCtx.getProperty("API_ELECTED_RESOURCE")).split(",");
            int n = operationList.length;
            int n2 = 0;
            while (n2 < n) {
                String operation = stringArray[n2];
                String operationScope = (String)operationScopeMappingList.get(operation);
                ajc$this.checkTokenWithTheScope(operation, operationScope, payload);
                ++n2;
            }
        } else {
            String resource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
            String resourceScope = OpenAPIUtils.getScopesOfResource(openAPI, synCtx);
            ajc$this.checkTokenWithTheScope(resource, resourceScope, payload);
        }
    }

    static final /* synthetic */ void checkTokenWithTheScope_aroundBody10(JWTValidator ajc$this, String resource, String resourceScope, JWTClaimsSet payload, JoinPoint joinPoint) {
        if (StringUtils.isNotBlank((String)resourceScope)) {
            if (payload.getClaim("scope") == null) {
                log.error((Object)"Scopes not found in the token.");
                throw new APISecurityException(900910, "Scope validation failed");
            }
            String[] tokenScopes = payload.getStringClaim("scope").split(" ");
            boolean scopeFound = false;
            String[] stringArray = tokenScopes;
            int n = tokenScopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                if (scope.trim().equals(resourceScope)) {
                    scopeFound = true;
                    break;
                }
                ++n2;
            }
            if (!scopeFound) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scope validation failed. User: " + payload.getSubject()));
                }
                log.error((Object)"Scope validation failed.");
                throw new APISecurityException(900910, "Scope validation failed");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope validation successful for the resource: " + resource + ", Resource Scope: " + resourceScope + ", User: " + payload.getSubject()));
            }
        }
        log.debug((Object)("No scopes assigned to the resource: " + resource));
    }

    static final /* synthetic */ void checkTokenExpiration_aroundBody12(JWTValidator ajc$this, String tokenSignature, JWTClaimsSet payload, String tenantDomain, JoinPoint joinPoint) {
        long timestampSkew = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds();
        Date now = new Date();
        Date exp = payload.getExpirationTime();
        if (exp != null && !DateUtils.isAfter((Date)exp, (Date)now, (long)timestampSkew)) {
            if (ajc$this.isGatewayTokenCacheEnabled) {
                ajc$this.getGatewayTokenCache().remove((Object)tokenSignature);
                ajc$this.getGatewayJWTTokenCache().remove((Object)tokenSignature);
                ajc$this.getInvalidTokenCache().put((Object)tokenSignature, (Object)tenantDomain);
            }
            log.error((Object)("JWT token is expired :" + GatewayUtils.getMaskedToken(tokenSignature)));
            throw new APISecurityException(900901, "Invalid Credentials");
        }
    }

    static final /* synthetic */ JWTClaimsSet transformJWTClaims_aroundBody14(JWTValidator ajc$this, JWTClaimsSet body, JoinPoint joinPoint) {
        String issuer = body.getIssuer();
        JWTTransformer jwtTransformer = null;
        if (StringUtils.isNotEmpty((String)issuer)) {
            jwtTransformer = ServiceReferenceHolder.getInstance().getJwtTransformerMap().get(issuer);
        }
        if (jwtTransformer == null) {
            jwtTransformer = ServiceReferenceHolder.getInstance().getJwtTransformerMap().get("default");
        }
        return jwtTransformer.transform(body);
    }

    static final /* synthetic */ Cache getGatewayTokenCache_aroundBody16(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayTokenCache();
    }

    static final /* synthetic */ Cache getInvalidTokenCache_aroundBody18(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidTokenCache();
    }

    static final /* synthetic */ Cache getGatewayKeyCache_aroundBody20(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayKeyCache();
    }

    static final /* synthetic */ Cache getGatewayJWTTokenCache_aroundBody22(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayJWTTokenCache();
    }

    static final /* synthetic */ boolean verifyTokenSignature_aroundBody26(JWTValidator ajc$this, SignedJWT parsedJWTToken, String certificateAlias, JoinPoint joinPoint) {
        block6: {
            try {
                JWKSet jwkSet;
                TokenIssuerDto tokenIssuerDto;
                Map tokenIssuerDtoMap = ajc$this.jwtConfigurationDto.getTokenIssuerDtoMap();
                String issuer = parsedJWTToken.getJWTClaimsSet().getIssuer();
                if (!StringUtils.isNotEmpty((String)issuer) || (tokenIssuerDto = (TokenIssuerDto)tokenIssuerDtoMap.get(issuer)) == null || !tokenIssuerDto.getJwksConfigurationDTO().isEnabled() || !StringUtils.isNotEmpty((String)tokenIssuerDto.getJwksConfigurationDTO().getUrl())) break block6;
                Object jwks = ajc$this.getJWKSCache().get((Object)tokenIssuerDto.getIssuer());
                if (jwks != null) {
                    jwkSet = (JWKSet)jwks;
                } else {
                    String jwksInfo = GatewayUtils.retrieveJWKSConfiguration(tokenIssuerDto.getJwksConfigurationDTO().getUrl());
                    jwkSet = JWKSet.parse((String)jwksInfo);
                    ajc$this.getJWKSCache().put((Object)tokenIssuerDto.getIssuer(), (Object)jwkSet);
                }
                if (jwkSet.getKeyByKeyId(certificateAlias) instanceof RSAKey) {
                    RSAKey keyByKeyId = (RSAKey)jwkSet.getKeyByKeyId(certificateAlias);
                    RSAPublicKey rsaPublicKey = keyByKeyId.toRSAPublicKey();
                    if (rsaPublicKey != null) {
                        return GatewayUtils.verifyTokenSignature(parsedJWTToken, rsaPublicKey);
                    }
                    break block6;
                }
                throw new APISecurityException(900900, "Key Algoritm not supported");
            }
            catch (JOSEException | IOException | ParseException e) {
                log.error((Object)"Error while parsing JWT", e);
            }
        }
        return GatewayUtils.verifyTokenSignature(parsedJWTToken, certificateAlias);
    }

    static final /* synthetic */ Cache getJWKSCache_aroundBody28(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getJWKSCache();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JWTValidator.java", JWTValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:org.apache.synapse.MessageContext:io.swagger.v3.oas.models.OpenAPI", "jwtToken:synCtx:openAPI", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateAndRetrieveJWTToken", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:org.wso2.carbon.apimgt.gateway.dto.JWTInfoDto", "tokenSignature:jwtInfoDto", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "java.lang.String"), 336);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 687);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayJWTTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 691);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiLevelPolicy", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "java.lang.String"), 695);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "verifyTokenSignature", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "com.nimbusds.jwt.SignedJWT:java.lang.String", "parsedJWTToken:certificateAlias", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 699);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getJWKSCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 740);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateSubscriptionUsingKeyManager", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.apache.synapse.MessageContext:com.nimbusds.jwt.JWTClaimsSet", "synCtx:payload", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO"), 373);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticateForWebSocket", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:java.lang.String:java.lang.String", "jwtToken:apiContext:apiVersion", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext"), 411);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateScopes", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.apache.synapse.MessageContext:io.swagger.v3.oas.models.OpenAPI:com.nimbusds.jwt.JWTClaimsSet", "synCtx:openAPI:payload", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException:java.text.ParseException", "void"), 586);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTokenWithTheScope", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:java.lang.String:com.nimbusds.jwt.JWTClaimsSet", "resource:resourceScope:payload", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException:java.text.ParseException", "void"), 603);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTokenExpiration", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:com.nimbusds.jwt.JWTClaimsSet:java.lang.String", "tokenSignature:payload:tenantDomain", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "void"), 644);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformJWTClaims", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "com.nimbusds.jwt.JWTClaimsSet", "body", "", "com.nimbusds.jwt.JWTClaimsSet"), 663);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 679);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInvalidTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 683);
    }
}

