/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator;

import com.nimbusds.jwt.JWTClaimsSet;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator$AjcClosure9;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.core.util.KeyStoreManager;

public abstract class AbstractAPIMgtGatewayJWTGenerator {
    private static final Log log;
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    public static final String API_GATEWAY_ID = "wso2.org/products/am";
    private static volatile long ttl;
    private String dialectURI = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("ConsumerDialectURI");
    private String signatureAlgorithm;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        AbstractAPIMgtGatewayJWTGenerator.ajc$preClinit();
        log = LogFactory.getLog(AbstractAPIMgtGatewayJWTGenerator.class);
        ttl = -1L;
    }

    public AbstractAPIMgtGatewayJWTGenerator() {
        if (this.dialectURI == null) {
            this.dialectURI = "http://wso2.org/claims";
        }
        this.signatureAlgorithm = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("SignatureAlgorithm");
        if (this.signatureAlgorithm == null || !NONE.equals(this.signatureAlgorithm) && !SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            this.signatureAlgorithm = SHA256_WITH_RSA;
        }
    }

    public String generateToken(JWTInfoDto jwtInfoDto) throws APIManagementException {
        JWTInfoDto jWTInfoDto = jwtInfoDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jWTInfoDto);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jWTInfoDto, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.generateToken_aroundBody0(this, jWTInfoDto, joinPoint);
    }

    public String buildHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.buildHeader_aroundBody2(this, joinPoint);
    }

    public byte[] signJWT(String assertion) throws APIManagementException {
        String string = assertion;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (byte[])MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.signJWT_aroundBody4(this, string, joinPoint);
    }

    protected long getTTL() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return AbstractAPIMgtGatewayJWTGenerator.getTTL_aroundBody6(this, joinPoint);
    }

    protected String addCertToHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.addCertToHeader_aroundBody8(this, joinPoint);
    }

    public String buildBody(JWTInfoDto jwtInfoDto) {
        JWTInfoDto jWTInfoDto = jwtInfoDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)jWTInfoDto);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jWTInfoDto, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.buildBody_aroundBody10(this, jWTInfoDto, joinPoint);
    }

    public String encode(byte[] stringToBeEncoded) throws APIManagementException {
        byte[] byArray = stringToBeEncoded;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)byArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, byArray, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractAPIMgtGatewayJWTGenerator.encode_aroundBody12(this, byArray, joinPoint);
    }

    public String getDialectURI() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractAPIMgtGatewayJWTGenerator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.dialectURI;
    }

    public abstract Map<String, Object> populateStandardClaims(JWTInfoDto var1);

    public abstract Map<String, Object> populateCustomClaims(JWTInfoDto var1);

    static final /* synthetic */ String generateToken_aroundBody0(AbstractAPIMgtGatewayJWTGenerator ajc$this, JWTInfoDto jwtInfoDto, JoinPoint joinPoint) {
        String jwtHeader = ajc$this.buildHeader();
        String jwtBody = ajc$this.buildBody(jwtInfoDto);
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = ajc$this.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String base64UrlEncodedBody = "";
        if (jwtBody != null) {
            base64UrlEncodedBody = ajc$this.encode(jwtBody.getBytes());
        }
        if (SHA256_WITH_RSA.equals(ajc$this.signatureAlgorithm)) {
            String assertion = String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody;
            byte[] signedAssertion = ajc$this.signJWT(assertion);
            if (log.isDebugEnabled()) {
                log.debug((Object)("signed assertion value : " + new String(signedAssertion, Charset.defaultCharset())));
            }
            String base64UrlEncodedAssertion = ajc$this.encode(signedAssertion);
            return String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody + '.' + base64UrlEncodedAssertion;
        }
        return String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody + '.';
    }

    static final /* synthetic */ String buildHeader_aroundBody2(AbstractAPIMgtGatewayJWTGenerator ajc$this, JoinPoint joinPoint) {
        String jwtHeader = null;
        if (NONE.equals(ajc$this.signatureAlgorithm)) {
            StringBuilder jwtHeaderBuilder = new StringBuilder();
            jwtHeaderBuilder.append("{\"typ\":\"JWT\",");
            jwtHeaderBuilder.append("\"alg\":\"");
            jwtHeaderBuilder.append(APIUtil.getJWSCompliantAlgorithmCode((String)NONE));
            jwtHeaderBuilder.append('\"');
            jwtHeaderBuilder.append('}');
            jwtHeader = jwtHeaderBuilder.toString();
        } else if (SHA256_WITH_RSA.equals(ajc$this.signatureAlgorithm)) {
            jwtHeader = ajc$this.addCertToHeader();
        }
        return jwtHeader;
    }

    static final /* synthetic */ byte[] signJWT_aroundBody4(AbstractAPIMgtGatewayJWTGenerator ajc$this, String assertion, JoinPoint joinPoint) {
        try {
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
            PrivateKey privateKey = keyStoreManager.getDefaultPrivateKey();
            return APIUtil.signJwt((String)assertion, (PrivateKey)privateKey, (String)ajc$this.signatureAlgorithm);
        }
        catch (Exception e) {
            throw new APIManagementException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ long getTTL_aroundBody6(AbstractAPIMgtGatewayJWTGenerator ajc$this, JoinPoint joinPoint) {
        if (ttl != -1L) {
            return ttl;
        }
        Class<AbstractAPIMgtGatewayJWTGenerator> clazz = AbstractAPIMgtGatewayJWTGenerator.class;
        synchronized (AbstractAPIMgtGatewayJWTGenerator.class) {
            String ttlValue;
            String apimKeyCacheExpiry;
            if (ttl != -1L) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ttl;
            }
            APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String gwTokenCacheConfig = config.getFirstProperty("CacheConfigurations.EnableGatewayTokenCache");
            boolean isGWTokenCacheEnabled = Boolean.parseBoolean(gwTokenCacheConfig);
            ttl = isGWTokenCacheEnabled ? ((apimKeyCacheExpiry = config.getFirstProperty("CacheConfigurations.TokenCacheExpiry")) != null ? Long.parseLong(apimKeyCacheExpiry) : Long.valueOf(900L)) : ((ttlValue = config.getFirstProperty("APIKeyValidator.JWTExpiryTime")) != null ? Long.parseLong(ttlValue) : Long.valueOf(900L));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ttl;
        }
    }

    static final /* synthetic */ String addCertToHeader_aroundBody8(AbstractAPIMgtGatewayJWTGenerator ajc$this, JoinPoint joinPoint) {
        try {
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
            X509Certificate publicCert = keyStoreManager.getDefaultPrimaryCertificate();
            return APIUtil.generateHeader((Certificate)publicCert, (String)ajc$this.signatureAlgorithm);
        }
        catch (Exception e) {
            String error = "Error in obtaining keystore";
            throw new APIManagementException(error, (Throwable)e);
        }
    }

    static final /* synthetic */ String buildBody_aroundBody10(AbstractAPIMgtGatewayJWTGenerator ajc$this, JWTInfoDto jwtInfoDto, JoinPoint joinPoint) {
        JWTClaimsSet.Builder jwtClaimSetBuilder = new JWTClaimsSet.Builder();
        Map<String, Object> claims = ajc$this.populateStandardClaims(jwtInfoDto);
        Map<String, Object> customClaims = ajc$this.populateCustomClaims(jwtInfoDto);
        for (Map.Entry<String, Object> claimEntry : customClaims.entrySet()) {
            if (!claims.containsKey(claimEntry.getKey())) {
                claims.put(claimEntry.getKey(), claimEntry.getValue());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Claim key " + claimEntry.getKey() + " already exist"));
        }
        for (Map.Entry<String, Object> claimEntry : claims.entrySet()) {
            jwtClaimSetBuilder.claim(claimEntry.getKey(), claimEntry.getValue());
        }
        JWTClaimsSet jwtClaimsSet = jwtClaimSetBuilder.build();
        return jwtClaimsSet.toJSONObject().toString();
    }

    static final /* synthetic */ String encode_aroundBody12(AbstractAPIMgtGatewayJWTGenerator ajc$this, byte[] stringToBeEncoded, JoinPoint joinPoint) {
        return Base64.getUrlEncoder().encodeToString(stringToBeEncoded);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAPIMgtGatewayJWTGenerator.java", AbstractAPIMgtGatewayJWTGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateToken", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "org.wso2.carbon.apimgt.gateway.dto.JWTInfoDto", "jwtInfoDto", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 93);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signJWT", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "java.lang.String", "assertion", "org.wso2.carbon.apimgt.api.APIManagementException", "[B"), 112);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTTL", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "", "", "", "long"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addCertToHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 164);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildBody", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "org.wso2.carbon.apimgt.gateway.dto.JWTInfoDto", "jwtInfoDto", "", "java.lang.String"), 176);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "[B", "stringToBeEncoded", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 196);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDialectURI", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.generator.AbstractAPIMgtGatewayJWTGenerator", "", "", "", "java.lang.String"), 199);
    }
}

