/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.oauth;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityConstants;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure29;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure31;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure33;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure35;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure37;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure39;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure41;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure43;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure45;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure47;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure49;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure51;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure53;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure55;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure57;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure59;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure61;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure63;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.dto.VerbInfoDTO;
import org.wso2.carbon.apimgt.tracing.TracingSpan;
import org.wso2.carbon.apimgt.tracing.TracingTracer;
import org.wso2.carbon.apimgt.tracing.Util;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;

public class OAuthAuthenticator
implements Authenticator {
    private static final Log log;
    protected APIKeyValidator keyValidator;
    protected JWTValidator jwtValidator;
    private String securityHeader = "Authorization";
    private String defaultAPIHeader = "WSO2_AM_API_DEFAULT_VERSION";
    private String consumerKeyHeaderSegment = "Bearer";
    private String oauthHeaderSplitter = ",";
    private String consumerKeySegmentDelimiter = " ";
    private String securityContextHeader;
    private boolean removeOAuthHeadersFromOutMessage = true;
    private boolean removeDefaultAPIHeaderFromOutMessage = true;
    private boolean isJWTAnOpaqueToken = false;
    private String clientDomainHeader = "referer";
    private String requestOrigin;
    private String remainingAuthHeader;
    private boolean isMandatory;
    private String apiLevelPolicy;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;

    static {
        OAuthAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(OAuthAuthenticator.class);
    }

    public OAuthAuthenticator() {
    }

    public OAuthAuthenticator(String authorizationHeader, boolean isMandatory, boolean removeOAuthHeader, String apiLevelPolicy) {
        this.securityHeader = authorizationHeader;
        this.removeOAuthHeadersFromOutMessage = removeOAuthHeader;
        this.isMandatory = isMandatory;
        this.apiLevelPolicy = apiLevelPolicy;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        OAuthAuthenticator.init_aroundBody0(this, synapseEnvironment, joinPoint);
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        OAuthAuthenticator.destroy_aroundBody2(this, joinPoint);
    }

    @Override
    @MethodStats
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.authenticate_aroundBody4(this, messageContext, joinPoint);
    }

    public String extractCustomerKeyFromAuthHeader(Map headersMap) {
        Map map = headersMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)map);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, map, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.extractCustomerKeyFromAuthHeader_aroundBody6(this, map, joinPoint);
    }

    private String removeLeadingAndTrailing(String base) {
        String string = base;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.removeLeadingAndTrailing_aroundBody8(this, string, joinPoint);
    }

    protected void initOAuthParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        OAuthAuthenticator.initOAuthParams_aroundBody10(this, joinPoint);
    }

    protected APIManagerConfiguration getApiManagerConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerConfiguration)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getApiManagerConfiguration_aroundBody12(this, joinPoint);
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getChallengeString_aroundBody14(this, joinPoint);
    }

    private String getClientDomain(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)messageContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getClientDomain_aroundBody16(this, messageContext, joinPoint);
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.requestOrigin;
    }

    public String getSecurityHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.securityHeader;
    }

    public void setSecurityHeader(String securityHeader) {
        String string = securityHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.securityHeader = string;
    }

    public String getDefaultAPIHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.defaultAPIHeader;
    }

    public void setDefaultAPIHeader(String defaultAPIHeader) {
        String string = defaultAPIHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.defaultAPIHeader = string;
    }

    public String getConsumerKeyHeaderSegment() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.consumerKeyHeaderSegment;
    }

    public void setConsumerKeyHeaderSegment(String consumerKeyHeaderSegment) {
        String string = consumerKeyHeaderSegment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure31(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.consumerKeyHeaderSegment = string;
    }

    public String getOauthHeaderSplitter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure33(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.oauthHeaderSplitter;
    }

    public void setOauthHeaderSplitter(String oauthHeaderSplitter) {
        String string = oauthHeaderSplitter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure35(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.oauthHeaderSplitter = string;
    }

    public String getConsumerKeySegmentDelimiter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure37(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.consumerKeySegmentDelimiter;
    }

    public void setConsumerKeySegmentDelimiter(String consumerKeySegmentDelimiter) {
        String string = consumerKeySegmentDelimiter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure39(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.consumerKeySegmentDelimiter = string;
    }

    public String getSecurityContextHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure41(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.securityContextHeader;
    }

    public void setSecurityContextHeader(String securityContextHeader) {
        String string = securityContextHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure43(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.securityContextHeader = string;
    }

    public boolean isRemoveOAuthHeadersFromOutMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure45(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.removeOAuthHeadersFromOutMessage;
    }

    public void setRemoveOAuthHeadersFromOutMessage(boolean removeOAuthHeadersFromOutMessage) {
        boolean bl = removeOAuthHeadersFromOutMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure47(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.removeOAuthHeadersFromOutMessage = bl;
    }

    public String getClientDomainHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure49(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.clientDomainHeader;
    }

    public void setClientDomainHeader(String clientDomainHeader) {
        String string = clientDomainHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure51(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.clientDomainHeader = string;
    }

    public boolean isRemoveDefaultAPIHeaderFromOutMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure53(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.removeDefaultAPIHeaderFromOutMessage;
    }

    public void setRemoveDefaultAPIHeaderFromOutMessage(boolean removeDefaultAPIHeaderFromOutMessage) {
        boolean bl = removeDefaultAPIHeaderFromOutMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure55(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.removeDefaultAPIHeaderFromOutMessage = bl;
    }

    public void setRequestOrigin(String requestOrigin) {
        String string = requestOrigin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure57(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.requestOrigin = string;
    }

    protected Timer getTimer(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Timer)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure59(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getTimer_aroundBody58(this, string, joinPoint);
    }

    protected APIKeyValidator getAPIKeyValidator() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIKeyValidator)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure61(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.keyValidator;
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure63(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return OAuthAuthenticator.getPriority_aroundBody62(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody0(OAuthAuthenticator ajc$this, SynapseEnvironment env, JoinPoint joinPoint) {
        ajc$this.keyValidator = new APIKeyValidator(env.getSynapseConfiguration().getAxisConfiguration());
        ajc$this.jwtValidator = new JWTValidator(ajc$this.apiLevelPolicy, ajc$this.keyValidator);
        ajc$this.initOAuthParams();
    }

    static final /* synthetic */ void destroy_aroundBody2(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        if (ajc$this.keyValidator != null) {
            ajc$this.keyValidator.cleanup();
        }
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody4(OAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        APIKeyValidationInfoDTO info;
        String authenticationScheme;
        boolean isJwtToken = false;
        OpenAPI openAPI = null;
        String apiKey = null;
        boolean defaultVersionInvoked = false;
        TracingSpan getClientDomainSpan = null;
        TracingSpan authenticationSchemeSpan = null;
        TracingSpan keyInfo = null;
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            ajc$this.requestOrigin = (String)headers.get("Origin");
            apiKey = ajc$this.extractCustomerKeyFromAuthHeader(headers);
            if (log.isDebugEnabled()) {
                log.debug((Object)(apiKey != null ? "Received Token ".concat(apiKey) : "No valid Authorization header found"));
            }
            defaultVersionInvoked = headers.containsKey(ajc$this.defaultAPIHeader);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Default Version API invoked");
        }
        if (ajc$this.removeOAuthHeadersFromOutMessage) {
            if (StringUtils.isNotBlank((CharSequence)ajc$this.remainingAuthHeader)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Removing OAuth key from Authorization header");
                }
                headers.put(ajc$this.securityHeader, ajc$this.remainingAuthHeader);
                ajc$this.remainingAuthHeader = "";
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Removing Authorization header from headers");
                }
                headers.remove(ajc$this.securityHeader);
            }
        }
        if (ajc$this.removeDefaultAPIHeaderFromOutMessage) {
            headers.remove(ajc$this.defaultAPIHeader);
        }
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
        String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        if (Util.tracingEnabled()) {
            TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
            TracingTracer tracer = Util.getGlobalTracer();
            getClientDomainSpan = Util.startSpan((String)"API:Get_Client_Domain()", (TracingSpan)keySpan, (TracingTracer)tracer);
        }
        String clientDomain = ajc$this.getClientDomain(synCtx);
        if (Util.tracingEnabled()) {
            Util.finishSpan(getClientDomainSpan);
        }
        if (log.isDebugEnabled() && clientDomain != null) {
            log.debug((Object)"Received Client Domain ".concat(clientDomain));
        }
        Timer timer = ajc$this.getTimer(MetricManager.name((String)"org.wso2.am", (String[])new String[]{ajc$this.getClass().getSimpleName(), "GET_RESOURCE_AUTH"}));
        Timer.Context context = timer.start();
        MessageContext axis2MessageCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        MessageContext.setCurrentMessageContext((MessageContext)axis2MessageCtx);
        if (Util.tracingEnabled()) {
            TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
            TracingTracer tracer = Util.getGlobalTracer();
            authenticationSchemeSpan = Util.startSpan((String)"API:Get_Resource_Authentication_Scheme()", (TracingSpan)keySpan, (TracingTracer)tracer);
        }
        try {
            if (!ajc$this.isJWTAnOpaqueToken && StringUtils.isNotEmpty((CharSequence)apiKey) && apiKey.contains(".")) {
                try {
                    Base64.getUrlDecoder().decode(apiKey.split("\\.")[0]);
                    if (StringUtils.countMatches((CharSequence)apiKey, (CharSequence)".") != 2) {
                        log.debug((Object)"Invalid JWT token. The expected token format is <header.payload.signature>");
                        throw new APISecurityException(900901, "Invalid JWT token");
                    }
                    isJwtToken = true;
                }
                catch (IllegalArgumentException | JSONException e) {
                    isJwtToken = false;
                    log.debug((Object)"Not a JWT token. Failed to decode the token header.", e);
                }
            }
            if (isJwtToken) {
                ArrayList<VerbInfoDTO> verbInfoList;
                openAPI = (OpenAPI)synCtx.getProperty("OPEN_API_OBJECT");
                if (openAPI == null && !"GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                    log.error((Object)"Swagger is missing in the gateway. Therefore, JWT authentication cannot be performed.");
                    return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900911, "JWT authentication cannot be performed.");
                }
                if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                    HashMap operationAuthSchemeMappingList = (HashMap)synCtx.getProperty("OperationAuthSchemeMapping");
                    HashMap operationThrottlingMappingList = (HashMap)synCtx.getProperty("OperationThrottlingMapping");
                    String[] operationList = matchingResource.split(",");
                    verbInfoList = new ArrayList(1);
                    authenticationScheme = "None";
                    String[] stringArray = operationList;
                    int n = operationList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String operation = stringArray[n2];
                        boolean operationAuthSchemeEnabled = (Boolean)operationAuthSchemeMappingList.get(operation);
                        VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
                        if (operationAuthSchemeEnabled) {
                            verbInfoDTO.setAuthType("Any");
                            authenticationScheme = "Any";
                        } else {
                            verbInfoDTO.setAuthType("None");
                        }
                        verbInfoDTO.setHttpVerb(httpMethod);
                        verbInfoDTO.setThrottling((String)operationThrottlingMappingList.get(operation));
                        verbInfoDTO.setRequestKey(String.valueOf(apiContext) + "/" + apiVersion + operation + ":" + httpMethod);
                        verbInfoList.add(verbInfoDTO);
                        ++n2;
                    }
                } else {
                    authenticationScheme = OpenAPIUtils.getResourceAuthenticationScheme(openAPI, synCtx);
                    verbInfoList = new ArrayList<VerbInfoDTO>(1);
                    VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
                    verbInfoDTO.setHttpVerb(httpMethod);
                    verbInfoDTO.setAuthType(authenticationScheme);
                    verbInfoDTO.setThrottling(OpenAPIUtils.getResourceThrottlingTier(openAPI, synCtx));
                    verbInfoDTO.setContentAware(OpenAPIUtils.isContentAwareTierAvailable(openAPI, synCtx));
                    verbInfoDTO.setRequestKey(String.valueOf(apiContext) + "/" + apiVersion + matchingResource + ":" + httpMethod);
                    verbInfoList.add(verbInfoDTO);
                }
                synCtx.setProperty("VERB_INFO", verbInfoList);
            } else {
                authenticationScheme = ajc$this.getAPIKeyValidator().getResourceAuthenticationScheme(synCtx);
            }
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
        }
        if (Util.tracingEnabled()) {
            Util.finishSpan((TracingSpan)authenticationSchemeSpan);
        }
        context.stop();
        if ("None".equals(authenticationScheme)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found Authentication Scheme: ".concat(authenticationScheme));
            }
            String clientIP = null;
            MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            TreeMap transportHeaderMap = (TreeMap)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (transportHeaderMap != null) {
                clientIP = (String)transportHeaderMap.get("X-Forwarded-For");
            }
            if (clientIP != null && !clientIP.isEmpty()) {
                if (clientIP.indexOf(",") > 0) {
                    clientIP = clientIP.substring(0, clientIP.indexOf(","));
                }
            } else {
                clientIP = (String)axis2MessageContext.getProperty("REMOTE_ADDR");
            }
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier("Unauthenticated");
            authContext.setStopOnQuotaReach(true);
            authContext.setApiKey(clientIP);
            authContext.setKeyType("PRODUCTION");
            authContext.setUsername("anonymous");
            authContext.setCallerToken(null);
            authContext.setApplicationName(null);
            authContext.setApplicationId(clientIP);
            authContext.setConsumerKey(null);
            APISecurityUtils.setAuthenticationContext(synCtx, authContext, ajc$this.securityContextHeader);
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        if ("noMatchedAuthScheme".equals(authenticationScheme)) {
            info = new APIKeyValidationInfoDTO();
            info.setAuthorized(false);
            info.setValidationStatus(900906);
        } else {
            if (apiKey == null || apiContext == null || apiVersion == null) {
                if (log.isDebugEnabled()) {
                    if (apiKey == null) {
                        log.debug((Object)"OAuth headers not found");
                    } else if (apiContext == null) {
                        log.debug((Object)"Couldn't find API Context");
                    } else if (apiVersion == null) {
                        log.debug((Object)"Could not find api version");
                    }
                }
                return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900902, "Required OAuth credentials not provided");
            }
            if (isJwtToken) {
                try {
                    AuthenticationContext authenticationContext = ajc$this.jwtValidator.authenticate(apiKey, synCtx, openAPI);
                    APISecurityUtils.setAuthenticationContext(synCtx, authenticationContext, ajc$this.securityContextHeader);
                    log.debug((Object)"User is authorized using JWT token to access the resource.");
                    return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
                }
                catch (APISecurityException ex) {
                    return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Matching resource is: ".concat(matchingResource));
            }
            timer = ajc$this.getTimer(MetricManager.name((String)"org.wso2.am", (String[])new String[]{ajc$this.getClass().getSimpleName(), "GET_KEY_VALIDATION_INFO"}));
            context = timer.start();
            if (Util.tracingEnabled()) {
                TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
                TracingTracer tracer = Util.getGlobalTracer();
                keyInfo = Util.startSpan((String)"API:Get_Key_Validation_Info()", (TracingSpan)keySpan, (TracingTracer)tracer);
            }
            try {
                info = ajc$this.getAPIKeyValidator().getKeyValidationInfo(apiContext, apiKey, apiVersion, authenticationScheme, clientDomain, matchingResource, httpMethod, defaultVersionInvoked);
            }
            catch (APISecurityException ex) {
                return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
            }
            if (Util.tracingEnabled()) {
                Util.finishSpan((TracingSpan)keyInfo);
            }
            context.stop();
            synCtx.setProperty("api.ut.application.name", (Object)info.getApplicationName());
            synCtx.setProperty("api.ut.userName", (Object)info.getEndUserName());
            synCtx.setProperty("Scopes", info.getScopes() == null ? null : info.getScopes().toString());
        }
        if (info.isAuthorized()) {
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier(info.getTier());
            authContext.setApiKey(apiKey);
            authContext.setKeyType(info.getType());
            if (info.getEndUserName() != null) {
                authContext.setUsername(info.getEndUserName());
            } else {
                authContext.setUsername("anonymous");
            }
            authContext.setCallerToken(info.getEndUserToken());
            authContext.setApplicationId(info.getApplicationId());
            authContext.setApplicationName(info.getApplicationName());
            authContext.setApplicationTier(info.getApplicationTier());
            authContext.setSubscriber(info.getSubscriber());
            authContext.setConsumerKey(info.getConsumerKey());
            authContext.setApiTier(info.getApiTier());
            authContext.setThrottlingDataList(info.getThrottlingDataList());
            authContext.setSubscriberTenantDomain(info.getSubscriberTenantDomain());
            authContext.setSpikeArrestLimit(info.getSpikeArrestLimit());
            authContext.setSpikeArrestUnit(info.getSpikeArrestUnit());
            authContext.setStopOnQuotaReach(info.isStopOnQuotaReach());
            authContext.setIsContentAware(info.isContentAware());
            APISecurityUtils.setAuthenticationContext(synCtx, authContext, ajc$this.securityContextHeader);
            if (info.getProductName() != null && info.getProductProvider() != null) {
                authContext.setProductName(info.getProductName());
                authContext.setProductProvider(info.getProductProvider());
            }
            synCtx.setProperty("api.ut.apiPublisher", (Object)info.getApiPublisher());
            synCtx.setProperty("API_NAME", (Object)info.getApiName());
            if (log.isDebugEnabled()) {
                log.debug((Object)"User is authorized to access the Resource");
            }
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User is NOT authorized to access the Resource");
        }
        return new AuthenticationResponse(false, ajc$this.isMandatory, true, info.getValidationStatus(), "Access failure for API: " + apiContext + ", version: " + apiVersion + " status: (" + info.getValidationStatus() + ") - " + APISecurityConstants.getAuthenticationFailureMessage(info.getValidationStatus()));
    }

    static final /* synthetic */ String extractCustomerKeyFromAuthHeader_aroundBody6(OAuthAuthenticator ajc$this, Map headersMap, JoinPoint joinPoint) {
        String authHeader = (String)headersMap.get(ajc$this.securityHeader);
        if (authHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OAuth2 Authentication: Expected authorization header with the name '".concat(ajc$this.securityHeader).concat("' was not found."));
            }
            return null;
        }
        ArrayList<String> remainingAuthHeaders = new ArrayList<String>();
        String consumerKey = null;
        boolean consumerkeyFound = false;
        String[] headers = authHeader.split(ajc$this.oauthHeaderSplitter);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                String[] elements = headers[i].split(ajc$this.consumerKeySegmentDelimiter);
                if (elements != null && elements.length > 1) {
                    int j = 0;
                    boolean isConsumerKeyHeaderAvailable = false;
                    String[] stringArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        if (!"".equals(element.trim())) {
                            if (ajc$this.consumerKeyHeaderSegment.equals(elements[j].trim())) {
                                isConsumerKeyHeaderAvailable = true;
                            } else if (isConsumerKeyHeaderAvailable) {
                                consumerKey = ajc$this.removeLeadingAndTrailing(elements[j].trim());
                                consumerkeyFound = true;
                            }
                        }
                        ++j;
                        ++n2;
                    }
                }
                if (!consumerkeyFound) {
                    remainingAuthHeaders.add(headers[i]);
                } else {
                    consumerkeyFound = false;
                }
                ++i;
            }
        }
        ajc$this.remainingAuthHeader = String.join((CharSequence)ajc$this.oauthHeaderSplitter, remainingAuthHeaders);
        return consumerKey;
    }

    static final /* synthetic */ String removeLeadingAndTrailing_aroundBody8(OAuthAuthenticator ajc$this, String base, JoinPoint joinPoint) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    static final /* synthetic */ void initOAuthParams_aroundBody10(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        JWTConfigurationDto jwtConfigurationDto;
        APIManagerConfiguration config = ajc$this.getApiManagerConfiguration();
        String value = config.getFirstProperty("OAuthConfigurations.RemoveOAuthHeadersFromOutMessage");
        if (value != null) {
            ajc$this.removeOAuthHeadersFromOutMessage = Boolean.parseBoolean(value);
        }
        if ((value = config.getFirstProperty("OAuthConfigurations.JWTAsOpaqueToken")) != null) {
            ajc$this.isJWTAnOpaqueToken = Boolean.parseBoolean(value);
        }
        if ((value = (jwtConfigurationDto = config.getJwtConfigurationDto()).getJwtHeader()) != null) {
            ajc$this.setSecurityContextHeader(value);
        }
    }

    static final /* synthetic */ APIManagerConfiguration getApiManagerConfiguration_aroundBody12(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
    }

    static final /* synthetic */ String getChallengeString_aroundBody14(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return "OAuth2 realm=\"WSO2 API Manager\"";
    }

    static final /* synthetic */ String getClientDomain_aroundBody16(OAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        String clientDomainHeaderValue = null;
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            clientDomainHeaderValue = (String)headers.get(ajc$this.clientDomainHeader);
        }
        return clientDomainHeaderValue;
    }

    static final /* synthetic */ Timer getTimer_aroundBody58(OAuthAuthenticator ajc$this, String name, JoinPoint joinPoint) {
        return MetricManager.timer((Level)Level.INFO, (String)name);
    }

    static final /* synthetic */ int getPriority_aroundBody62(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return 10;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OAuthAuthenticator.java", OAuthAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "void"), 102);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecurityHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 526);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSecurityHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "securityHeader", "", "void"), 530);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultAPIHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 534);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultAPIHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "defaultAPIHeader", "", "void"), 538);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConsumerKeyHeaderSegment", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 542);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConsumerKeyHeaderSegment", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "consumerKeyHeaderSegment", "", "void"), 546);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOauthHeaderSplitter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 550);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOauthHeaderSplitter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "oauthHeaderSplitter", "", "void"), 554);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConsumerKeySegmentDelimiter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 558);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConsumerKeySegmentDelimiter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "consumerKeySegmentDelimiter", "", "void"), 562);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 109);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecurityContextHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 566);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSecurityContextHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "securityContextHeader", "", "void"), 570);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "boolean"), 574);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "boolean", "removeOAuthHeadersFromOutMessage", "", "void"), 578);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientDomainHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 582);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientDomainHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "clientDomainHeader", "", "void"), 586);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRemoveDefaultAPIHeaderFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "boolean"), 590);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoveDefaultAPIHeaderFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "boolean", "removeDefaultAPIHeaderFromOutMessage", "", "void"), 594);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "requestOrigin", "", "void"), 598);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTimer", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "name", "", "org.wso2.carbon.metrics.manager.Timer"), 602);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "extractCustomerKeyFromAuthHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.util.Map", "headersMap", "", "java.lang.String"), 432);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getAPIKeyValidator", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator"), 605);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "int"), 610);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeLeadingAndTrailing", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "base", "", "java.lang.String"), 478);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initOAuthParams", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "void"), 487);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiManagerConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerConfiguration"), 504);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 508);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClientDomain", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "java.lang.String"), 512);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 522);
    }
}

