/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.mediators;

import java.util.Arrays;
import java.util.Map;
import javax.cache.Cache;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.mediators.APIMgtCommonExecutionPublisher;
import org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator$AjcClosure9;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.usage.publisher.DataPublisherUtil;
import org.wso2.carbon.apimgt.usage.publisher.dto.BotDataDTO;

public class BotDetectionMediator
extends APIMgtCommonExecutionPublisher {
    private static final Log log;
    private static final String BOT_ACCESS_COUNT_CACHE = "BOT_ACCESS_CACHE";
    private static final Cache botAccessCountCache;
    private int throttleLimit = 2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        BotDetectionMediator.ajc$preClinit();
        log = LogFactory.getLog(BotDetectionMediator.class);
        botAccessCountCache = APIUtil.getCache((String)"API_MANAGER_CACHE", (String)BOT_ACCESS_COUNT_CACHE, (long)60L, (long)60L);
    }

    @Override
    public boolean mediate(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BotDetectionMediator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BotDetectionMediator.mediate_aroundBody0(this, messageContext2, joinPoint);
    }

    private String getPassedHeaderSet(MessageContext msgContext) {
        MessageContext messageContext = msgContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new BotDetectionMediator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BotDetectionMediator.getPassedHeaderSet_aroundBody2(this, messageContext, joinPoint);
    }

    private boolean isThrottledOut(String clientIp) {
        String string = clientIp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BotDetectionMediator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BotDetectionMediator.isThrottledOut_aroundBody4(this, string, joinPoint);
    }

    public int getThrottleLimit() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new BotDetectionMediator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.throttleLimit;
    }

    public void setThrottleLimit(int throttleLimit) {
        int n = throttleLimit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new BotDetectionMediator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.throttleLimit = n;
    }

    static final /* synthetic */ boolean mediate_aroundBody0(BotDetectionMediator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String messageBody;
        MessageContext msgContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String clientIP = DataPublisherUtil.getClientIp((MessageContext)msgContext);
        if (ajc$this.isThrottledOut(clientIP)) {
            messageContext.setProperty("BOT_THROTTLED_OUT", (Object)true);
            messageContext.setProperty("BOT_IP", (Object)clientIP);
            return true;
        }
        long currentTime = System.currentTimeMillis();
        String messageId = messageContext.getMessageID();
        String apiMethod = (String)msgContext.getProperty("HTTP_METHOD");
        try {
            RelayUtils.buildMessage((MessageContext)msgContext);
            SOAPEnvelope messageEnvelop = msgContext.getEnvelope();
            messageBody = messageEnvelop != null && messageEnvelop.getBody() != null ? String.valueOf(messageEnvelop.getBody()) : "Empty Message";
        }
        catch (Exception exception) {
            messageBody = "Malformed Message";
        }
        String headerSet = ajc$this.getPassedHeaderSet(msgContext);
        log.info((Object)String.format("MessageId : %s | Request Method : %s | Message Body : %s | client Ip : %s | Headers set : %s", messageId, apiMethod, messageBody, clientIP, headerSet));
        if (!ajc$this.enabled) {
            return true;
        }
        BotDataDTO botDataDTO = new BotDataDTO();
        botDataDTO.setCurrentTime(currentTime);
        botDataDTO.setMessageID(messageId);
        botDataDTO.setApiMethod(apiMethod);
        botDataDTO.setHeaderSet(headerSet);
        botDataDTO.setMessageBody(messageBody);
        botDataDTO.setClientIp(clientIP);
        ajc$this.publisher.publishEvent(botDataDTO);
        return true;
    }

    static final /* synthetic */ String getPassedHeaderSet_aroundBody2(BotDetectionMediator ajc$this, MessageContext msgContext, JoinPoint joinPoint) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        Object[] headersArray = headers.entrySet().toArray();
        return Arrays.toString(headersArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ boolean isThrottledOut_aroundBody4(BotDetectionMediator ajc$this, String clientIp, JoinPoint joinPoint) {
        String string = "BOT_DETECTION_".concat(clientIp).intern();
        synchronized (string) {
            int counter;
            block4: {
                counter = 0;
                Object counterObject = botAccessCountCache.get((Object)clientIp);
                if (counterObject == null || (counter = ((Integer)counterObject).intValue()) <= ajc$this.throttleLimit) break block4;
                return true;
            }
            botAccessCountCache.put((Object)clientIp, (Object)(++counter));
            return false;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BotDetectionMediator.java", BotDetectionMediator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mediate", "org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPassedHeaderSet", "org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator", "org.apache.axis2.context.MessageContext", "msgContext", "", "java.lang.String"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isThrottledOut", "org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator", "java.lang.String", "clientIp", "", "boolean"), 102);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getThrottleLimit", "org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator", "", "", "", "int"), 117);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setThrottleLimit", "org.wso2.carbon.apimgt.gateway.mediators.BotDetectionMediator", "int", "throttleLimit", "", "void"), 121);
    }
}

