/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.mediators;

import com.google.re2j.Pattern;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.rest.RESTUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RegularExpressionProtector
extends AbstractMediator {
    private static final Log logger;
    private Boolean enabledCheckBody = true;
    private String threatType = null;
    private Pattern pattern = null;
    private Boolean enabledCheckHeaders;
    private Boolean enabledCheckPathParam;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        RegularExpressionProtector.ajc$preClinit();
        logger = LogFactory.getLog(RegularExpressionProtector.class);
    }

    public boolean mediate(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.mediate_aroundBody0(this, messageContext2, joinPoint);
    }

    private boolean isTenantAllowed(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.isTenantAllowed_aroundBody2(this, messageContext2, joinPoint);
    }

    private boolean isPayloadSizeExceeded(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.isPayloadSizeExceeded_aroundBody4(this, messageContext2, joinPoint);
    }

    private boolean isRequestBodyVulnerable(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.isRequestBodyVulnerable_aroundBody6(this, messageContext2, joinPoint);
    }

    private boolean isRequestPathVulnerable(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.isRequestPathVulnerable_aroundBody8(this, messageContext2, joinPoint);
    }

    private boolean isRequestHeadersVulnerable(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RegularExpressionProtector.isRequestHeadersVulnerable_aroundBody10(this, messageContext2, joinPoint);
    }

    public boolean isContentAware() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RegularExpressionProtector$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.enabledCheckBody;
    }

    static final /* synthetic */ boolean mediate_aroundBody0(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"RegularExpressionProtector mediator is activated...");
        }
        if (!ajc$this.isTenantAllowed(messageContext)) {
            return true;
        }
        Object messageProperty = messageContext.getProperty("enabledCheckBody");
        if (messageProperty != null) {
            ajc$this.enabledCheckBody = Boolean.valueOf(messageProperty.toString());
        }
        if (ajc$this.isContentAware() && ajc$this.isPayloadSizeExceeded(messageContext)) {
            return true;
        }
        messageProperty = messageContext.getProperty("regex");
        if (messageProperty == null || ajc$this.pattern != null) {
            GatewayUtils.handleThreat(messageContext, "400", "Threat detection key words are missing");
            return true;
        }
        ajc$this.pattern = Pattern.compile((String)messageProperty.toString(), (int)1);
        messageProperty = messageContext.getProperty("enabledCheckPathParams");
        if (messageProperty != null) {
            ajc$this.enabledCheckPathParam = Boolean.valueOf(messageProperty.toString());
        }
        if ((messageProperty = messageContext.getProperty("enabledCheckHeaders")) != null) {
            ajc$this.enabledCheckHeaders = Boolean.valueOf(messageProperty.toString());
        }
        if ((messageProperty = messageContext.getProperty("threatType")) != null) {
            ajc$this.threatType = String.valueOf(messageProperty);
        }
        if (ajc$this.isRequestBodyVulnerable(messageContext) || ajc$this.isRequestHeadersVulnerable(messageContext) || ajc$this.isRequestPathVulnerable(messageContext)) {
            return true;
        }
        return true;
    }

    static final /* synthetic */ boolean isTenantAllowed_aroundBody2(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String allowedTenants = System.getProperty("regexThreatProtectorEnabledTenants");
        if (allowedTenants == null) {
            return true;
        }
        List<String> allowedTenantsList = Arrays.asList(allowedTenants.split(","));
        String tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)RESTUtils.getFullRequestPath((org.apache.synapse.MessageContext)messageContext));
        if (StringUtils.isEmpty((CharSequence)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        if (!allowedTenantsList.contains(tenantDomain) && !"carbon.super".equals(tenantDomain)) {
            GatewayUtils.handleThreat(messageContext, "400", "This tenant is not allowed to use Regular Expression Threat Protector mediator");
            return false;
        }
        return true;
    }

    static final /* synthetic */ boolean isPayloadSizeExceeded_aroundBody4(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        Integer payloadSizeLimit = Integer.getInteger("payloadSizeLimitForRegexThreatProtector");
        if (payloadSizeLimit == null) {
            return false;
        }
        long requestPayloadSize = 0L;
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        Map headers = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
        String contentLength = (String)headers.get("Content-Length");
        if (contentLength != null) {
            requestPayloadSize = Integer.parseInt(contentLength);
        } else {
            SOAPBody soapbody;
            SOAPEnvelope env = messageContext.getEnvelope();
            if (env != null && (soapbody = env.getBody()) != null) {
                byte[] size = soapbody.toString().getBytes(Charset.defaultCharset());
                requestPayloadSize = size.length;
            }
        }
        if (requestPayloadSize > (long)(payloadSizeLimit * 1024)) {
            GatewayUtils.handleThreat(messageContext, "400", "Exceeded Request Payload size limit allowed to be used with the enabledCheckBody option of Regular Expression Threat Protector mediator");
            return true;
        }
        return false;
    }

    static final /* synthetic */ boolean isRequestBodyVulnerable_aroundBody6(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        if (ajc$this.enabledCheckBody.booleanValue()) {
            SOAPEnvelope soapEnvelope = axis2MC.getEnvelope();
            if (soapEnvelope == null) {
                return false;
            }
            SOAPBody soapBody = soapEnvelope.getBody();
            if (soapBody == null) {
                return false;
            }
            OMElement omElement = soapBody.getFirstElement();
            if (omElement == null) {
                return false;
            }
            String payload = omElement.toString();
            if (ajc$this.pattern != null && payload != null && ajc$this.pattern.matcher((CharSequence)payload).find()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Threat detected in request payload [ %s ] by regex [ %s ]))", payload, ajc$this.pattern));
                }
                GatewayUtils.handleThreat(messageContext, "400", String.valueOf(ajc$this.threatType) + " " + "Threat detected in Payload");
                return true;
            }
        }
        return false;
    }

    static final /* synthetic */ boolean isRequestPathVulnerable_aroundBody8(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String parameter = null;
        if (ajc$this.enabledCheckPathParam.booleanValue()) {
            String queryParams = (String)axis2MC.getProperty("REST_URL_POSTFIX");
            try {
                parameter = URLDecoder.decode(queryParams, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                String message = "Error occurred while decoding the query/path parameters: " + parameter;
                logger.error((Object)message, (Throwable)e);
                GatewayUtils.handleThreat(messageContext, "400", String.valueOf(message) + e.getMessage());
                return true;
            }
            if (ajc$this.pattern != null && parameter != null && ajc$this.pattern.matcher((CharSequence)parameter).find()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Threat detected in query parameters [ %s ] by regex [ %s ]", queryParams, ajc$this.pattern));
                }
                GatewayUtils.handleThreat(messageContext, "400", String.valueOf(ajc$this.threatType) + " " + "Threat detected in Query Parameters");
                return true;
            }
        }
        return false;
    }

    static final /* synthetic */ boolean isRequestHeadersVulnerable_aroundBody10(RegularExpressionProtector ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        if (ajc$this.enabledCheckHeaders.booleanValue()) {
            Map transportHeaders = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
            if (ajc$this.pattern != null && transportHeaders != null && ajc$this.pattern.matcher((CharSequence)transportHeaders.toString()).find()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Threat detected in Transport headers [ %s ] by regex [ %s ]", transportHeaders, ajc$this.pattern));
                }
                GatewayUtils.handleThreat(messageContext, "400", String.valueOf(ajc$this.threatType) + " " + "Threat detected in HTTP Headers");
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RegularExpressionProtector.java", RegularExpressionProtector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mediate", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isTenantAllowed", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isPayloadSizeExceeded", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 150);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRequestBodyVulnerable", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 188);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRequestPathVulnerable", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 228);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRequestHeadersVulnerable", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 263);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isContentAware", "org.wso2.carbon.apimgt.gateway.mediators.RegularExpressionProtector", "", "", "", "boolean"), 290);
    }
}

