/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.configurations;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.configurations.ConfigurationErrorChecker;
import org.wso2.carbon.automation.engine.exceptions.ConfigurationMismatchException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.xml.sax.SAXException;

public class AutomationConfigurationReader {
    private static final Log log = LogFactory.getLog(AutomationConfigurationReader.class);
    private static AutomationConfigurationReader sessionAutomationConfiguration;
    private static Document document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutomationConfigurationReader readAutomationConfigurations() throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        Class<AutomationConfigurationReader> clazz = AutomationConfigurationReader.class;
        synchronized (AutomationConfigurationReader.class) {
            if (sessionAutomationConfiguration == null) {
                sessionAutomationConfiguration = new AutomationConfigurationReader();
                document = AutomationConfigurationReader.readConfigurationXmlDocument();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sessionAutomationConfiguration;
        }
    }

    public Document getConfigurationDocument() {
        return document;
    }

    private static Document readConfigurationXmlDocument() throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        File fXmlFile = new File(FrameworkPathUtil.getSystemResourceLocation() + "automation.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xmlDocument = dBuilder.parse(fXmlFile);
        AutomationConfigurationReader.removeText(xmlDocument);
        xmlDocument.normalizeDocument();
        return xmlDocument;
    }

    private static void removeText(Node doc) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
            Node emptyTextNode = emptyTextNodes.item(i);
            emptyTextNode.getParentNode().removeChild(emptyTextNode);
        }
    }

    protected static Document getConfigurationXmlDocument() throws ConfigurationMismatchException, XPathExpressionException {
        ConfigurationErrorChecker.checkPlatformErrors(document);
        return document;
    }
}

