/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.configurations;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.exceptions.ConfigurationMismatchException;

public class ConfigurationErrorChecker {
    private static final Log log = LogFactory.getLog(ConfigurationErrorChecker.class);

    public void checkErrors(Document document) throws ConfigurationMismatchException, XPathExpressionException {
        ConfigurationErrorChecker.checkUserContextErrors(document);
        ConfigurationErrorChecker.checkPlatformErrors(document);
    }

    public static void checkPlatformErrors(Document document) throws ConfigurationMismatchException, XPathExpressionException {
        String executionEnv = ConfigurationErrorChecker.getConfigurationValue(document, "//executionEnvironment/text()");
        int productGroupCount = ConfigurationErrorChecker.getConfigurationNodeList(document, "//platform/productGroup").getLength();
        if (executionEnv.equals("standalone")) {
            if (productGroupCount > 1) {
                log.error((Object)"Standalone execution mode cannot have multiple product groups");
                throw new ConfigurationMismatchException("PlatformContext", "Standalone execution mode cannot have multiple product groups");
            }
            int standaloneNodeCount = ConfigurationErrorChecker.getConfigurationNodeList(document, "//platform/productGroup/instance[@type='standalone']").getLength();
            if (standaloneNodeCount == 0) {
                log.error((Object)"Product execution mode should have at least one standalone instance");
                throw new ConfigurationMismatchException("PlatformContext", "Product execution mode should have at least one standalone instance");
            }
        }
    }

    public static void checkUserContextErrors(Document document) throws ConfigurationMismatchException {
    }

    private static String getConfigurationValue(Document xmlDocument, String expression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.compile(expression).evaluate(xmlDocument);
    }

    private static Node getConfigurationNode(Document xmlDocument, String expression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (Node)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODE);
    }

    private static NodeList getConfigurationNodeList(Document xmlDocument, String expression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
    }
}

