/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.context;

import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.configurations.AutomationConfiguration;
import org.wso2.carbon.automation.engine.context.InstanceType;

public class DefaultInstance
extends AutomationConfiguration {
    private static final Log log = LogFactory.getLog(DefaultInstance.class);

    public String getTenantDomain(boolean isTenantAdmin, boolean isClustered) throws XPathExpressionException {
        String tenantDomain = null;
        try {
            tenantDomain = isTenantAdmin ? DefaultInstance.getConfigurationValue("//superTenant/tenant/@domain") : DefaultInstance.getConfigurationValue("//tenants/tenant/@domain");
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while reading the super Tenant:", (Throwable)e);
            throw new XPathExpressionException("Error While Reading default Tenant Domain:- ");
        }
        return tenantDomain;
    }

    public String getUserKey(String tenantDomain, boolean isAdminUser) throws XPathExpressionException {
        String tenantKey = null;
        String adminUserReplacement = "admin";
        try {
            if (!isAdminUser) {
                adminUserReplacement = "users";
            }
            tenantKey = tenantDomain.equals(DefaultInstance.getConfigurationValue("//superTenant/tenant[@key='superTenant']/@domain")) ? DefaultInstance.getConfigurationValue(String.format("//superTenant/tenant/%s/user/@key", adminUserReplacement)) : DefaultInstance.getConfigurationValue(String.format("//tenants/tenant[@domain='%s']/%s/user/@key", tenantDomain, adminUserReplacement));
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Error while reading the Tenant:" + e.getMessage()));
            throw new XPathExpressionException("Error While Reading default User Key:- " + e.getMessage());
        }
        return tenantKey;
    }

    public String getDefaultManager(String productGroup) throws XPathExpressionException {
        String managerNode = null;
        try {
            boolean isClustered = Boolean.parseBoolean(DefaultInstance.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", productGroup)));
            String xpathNodeType = "//productGroup[@name='%s']/instance[@type='%s']";
            NodeList lbWorkerManagerList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.lb_worker_manager}));
            NodeList lbManagerNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.lb_manager}));
            NodeList managerNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.manager}));
            NodeList standAloneNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.standalone}));
            managerNode = isClustered ? (lbWorkerManagerList.getLength() >= 1 ? lbWorkerManagerList.item(0).getAttributes().getNamedItem("name").getTextContent() : (lbManagerNodeList.getLength() >= 1 ? lbManagerNodeList.item(0).getAttributes().getNamedItem("name").getTextContent() : (managerNodeList.getLength() >= 1 ? managerNodeList.item(0).getAttributes().getNamedItem("name").getTextContent() : standAloneNodeList.item(0).getAttributes().getNamedItem("name").getTextContent()))) : standAloneNodeList.item(0).getAttributes().getNamedItem("name").getTextContent();
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Error while reading the default Manager:" + e.getMessage()));
            throw new XPathExpressionException("Error While Reading default Tenant Domain:- " + e.getMessage());
        }
        return managerNode;
    }

    public String getDefaultWorker(String productGroup) throws XPathExpressionException {
        String workerNode = null;
        try {
            boolean isClustered = Boolean.parseBoolean(DefaultInstance.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", productGroup)));
            String xpathNodeType = "//productGroup[@name='%s']/instance[@type='%s']";
            NodeList lbWorkerManagerList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.lb_worker_manager}));
            NodeList lbWorkerNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.lb_worker}));
            NodeList workerNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.worker}));
            NodeList standAloneNodeList = DefaultInstance.getConfigurationNodeList(String.format(xpathNodeType, new Object[]{productGroup, InstanceType.standalone}));
            workerNode = isClustered ? (lbWorkerManagerList.getLength() >= 1 ? lbWorkerManagerList.item(0).getAttributes().getNamedItem("name").getTextContent() : (lbWorkerNodeList.getLength() >= 1 ? lbWorkerNodeList.item(0).getAttributes().getNamedItem("name").getTextContent() : (workerNodeList.getLength() >= 1 ? workerNodeList.item(0).getAttributes().getNamedItem("name").getTextContent() : standAloneNodeList.item(0).getAttributes().getNamedItem("name").getTextContent()))) : standAloneNodeList.item(0).getAttributes().getNamedItem("name").getTextContent();
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Error while reading the default worker:" + e.getMessage()));
            throw new XPathExpressionException("Error While Reading default Tenant Domain:- " + e.getMessage());
        }
        return workerNode;
    }
}

