/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.extensions;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.context.AutomationContext;

public class ListenerExtension {
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private AutomationContext automationContext;
    private static final String PARAMETER = "parameter";
    private static final String VALUE = "value";
    private static final String NAME = "name";

    public ListenerExtension() {
        try {
            this.automationContext = new AutomationContext();
        }
        catch (XPathExpressionException e) {
            this.log.warn((Object)"Failed to initializing the Extension Class");
            this.log.error((Object)"Error initializing the Automation Context", (Throwable)e);
        }
    }

    protected void setParameterMap(String xpathToClass, String className) throws XPathExpressionException {
        Node extensionClass = this.automationContext.getConfigurationNode(xpathToClass + "[.='" + className + "']").getParentNode();
        NodeList extensionClassChildNodes = extensionClass.getChildNodes();
        if (extensionClassChildNodes != null) {
            for (int i = 0; i < extensionClassChildNodes.getLength(); ++i) {
                if (!PARAMETER.equalsIgnoreCase(extensionClassChildNodes.item(i).getNodeName())) continue;
                NamedNodeMap attributes = extensionClassChildNodes.item(i).getAttributes();
                this.parameterMap.put(attributes.getNamedItem(NAME).getTextContent(), attributes.getNamedItem(VALUE).getTextContent());
            }
        }
    }

    protected Map<String, String> getParameters() {
        return this.parameterMap;
    }

    protected AutomationContext getAutomationContext() {
        return this.automationContext;
    }
}

