/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveExtractorUtil {
    private static final Log log = LogFactory.getLog(ArchiveExtractorUtil.class);

    public static void extractFile(String sourceFilePath, String extractedDir) throws IOException {
        FileOutputStream fileoutputstream = null;
        String fileDestination = extractedDir + File.separator;
        byte[] buf = new byte[1024];
        ZipInputStream zipinputstream = null;
        try {
            zipinputstream = new ZipInputStream(new FileInputStream(sourceFilePath));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                int n;
                String entryName = fileDestination + zipentry.getName();
                entryName = entryName.replace('/', File.separatorChar);
                entryName = entryName.replace('\\', File.separatorChar);
                File newFile = new File(entryName);
                if (zipentry.isDirectory()) {
                    if (!newFile.exists() && !newFile.mkdirs()) {
                        throw new IOException("Error occurred created new directory");
                    }
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                File resourceFile = new File(entryName.substring(0, entryName.lastIndexOf(File.separator)));
                if (!resourceFile.exists() && !resourceFile.mkdirs()) break;
                fileoutputstream = new FileOutputStream(entryName);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (IOException e) {
            log.error((Object)"Error on archive extraction ", (Throwable)e);
            throw new IOException("Error on archive extraction ", e);
        }
        finally {
            if (fileoutputstream != null) {
                fileoutputstream.close();
            }
            if (zipinputstream != null) {
                zipinputstream.close();
            }
        }
    }

    public static String setUpCarbonHome(String carbonServerZipFile) throws IOException {
        String fileSeparator;
        int indexOfZip = carbonServerZipFile.lastIndexOf(".zip");
        if (indexOfZip == -1) {
            throw new IllegalArgumentException(carbonServerZipFile + " is not a zip file");
        }
        String string = fileSeparator = File.separator.equals("\\") ? "\\" : "/";
        if (fileSeparator.equals("\\")) {
            carbonServerZipFile = carbonServerZipFile.replace("/", "\\");
        }
        String extractedCarbonDir = carbonServerZipFile.substring(carbonServerZipFile.lastIndexOf(fileSeparator) + 1, indexOfZip);
        ArchiveExtractorUtil.deleteDir(new File(extractedCarbonDir));
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        log.info((Object)"Extracting carbon zip file.. ");
        ArchiveExtractorUtil.extractFile(carbonServerZipFile, baseDir + File.separator + extractDir);
        File carbonDistribution = new File(new File(baseDir).getAbsolutePath() + File.separator + extractDir + File.separator + extractedCarbonDir);
        if (!carbonDistribution.exists()) {
            throw new FileNotFoundException("Carbon extracted distribution cannot be found at - " + carbonDistribution.getAbsolutePath());
        }
        return new File(baseDir).getAbsolutePath() + File.separator + extractDir + File.separator + extractedCarbonDir;
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                boolean success = ArchiveExtractorUtil.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

