/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveManipulator {
    private static final int BUFFER_SIZE = 40960;
    private static Log log = LogFactory.getLog(ArchiveManipulator.class);
    private String archiveSourceDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveDir(String archiveDestination, String sourceDir) throws IOException {
        File zipDir = new File(sourceDir);
        if (!zipDir.isDirectory()) {
            throw new IOException(sourceDir + " is not a directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archiveDestination));
        this.archiveSourceDir = sourceDir;
        try {
            this.zipDir(zipDir, zos);
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the ZipOutputStream ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveFile(String from, String to) throws IOException {
        ZipOutputStream out = null;
        FileInputStream in = new FileInputStream(from);
        try {
            int bytesRead;
            out = new ZipOutputStream(new FileOutputStream(to));
            byte[] buffer = new byte[40960];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the InputStream ", (Throwable)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the OutputStream ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] check(String archive) throws IOException {
        ZipInputStream zin = null;
        FileInputStream in = null;
        ArrayList<String> entries = new ArrayList<String>();
        try {
            ZipEntry entry;
            in = new FileInputStream(archive);
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                entries.add(entry.getName());
            }
            String[] stringArray = entries.toArray(new String[entries.size()]);
            return stringArray;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Could not close ZipInputStream ", (Throwable)e);
            }
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Could not close InputStream ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(String archive, String extractDir) throws IOException {
        FileInputStream inputStream = new FileInputStream(archive);
        try {
            this.extractFromStream(inputStream, extractDir);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Could not close InputStream ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFromStream(InputStream inputStream, String extractDir) throws IOException {
        ZipInputStream zin = null;
        OutputStream out = null;
        try {
            ZipEntry entry;
            File unzipped = new File(extractDir);
            if (!unzipped.exists() && !unzipped.mkdirs()) {
                throw new IOException("Fail to create the directory: " + unzipped.getAbsolutePath());
            }
            zin = new ZipInputStream(inputStream);
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                File f = new File(extractDir + File.separator + entryName);
                if (entryName.endsWith("/") && !f.exists()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Fail to create the directory: " + f.getAbsolutePath());
                }
                int lastIndexOfSlash = entryName.lastIndexOf(47);
                String dirPath = "";
                if (lastIndexOfSlash != -1) {
                    dirPath = entryName.substring(0, lastIndexOfSlash);
                    File dir = new File(extractDir + File.separator + dirPath);
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
                    }
                }
                if (f.isDirectory()) continue;
                out = new FileOutputStream(f);
                byte[] buf = new byte[40960];
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the InputStream ", (Throwable)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the OutputStream ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipDir(File zipDir, ZipOutputStream zos) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        int bytesIn = 0;
        if (dirList != null) {
            for (String dir : dirList) {
                File f = new File(zipDir, dir);
                zos.putNextEntry(new ZipEntry(this.getZipEntryPath(f)));
                if (f.isDirectory()) {
                    this.zipDir(f, zos);
                    continue;
                }
                FileInputStream fis = new FileInputStream(f);
                try {
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Unable to close the FileInputStream ", (Throwable)e);
                    }
                }
            }
        }
    }

    protected String getZipEntryPath(File f) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(this.archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }
}

