/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.testlisteners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.IExecutionListener;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.extensions.TestNGExtensionExecutor;
import org.wso2.carbon.automation.engine.frameworkutils.TestFrameworkUtils;

public class TestExecutionListener
implements IExecutionListener {
    private static final Log log = LogFactory.getLog(TestExecutionListener.class);

    public void onExecutionStart() {
        try {
            AutomationContext context = new AutomationContext();
            System.setProperty("framework.execution.mode", context.getConfigurationValue("//executionEnvironment/text()"));
            TestFrameworkUtils.setKeyStoreProperties(context);
            TestNGExtensionExecutor testNGExtensionExecutor = new TestNGExtensionExecutor();
            testNGExtensionExecutor.initiate();
            TestNGExtensionExecutor.executeExtensible("platformExecutionManager", "onExecutionStart", false);
            log.info((Object)"Inside Test Execution Listener - On Execution");
        }
        catch (Exception e) {
            this.handleException("Error on initializing test environment ", e);
        }
    }

    public void onExecutionFinish() {
        try {
            log.info((Object)"Inside Test Execution Listener - On Finish");
            TestNGExtensionExecutor.executeExtensible("platformExecutionManager", "onExecutionFinish", true);
        }
        catch (Exception e) {
            this.handleException("Error while tear down the execution environment ", e);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)"Execution error occurred in TestExecutionListener:-", (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

