/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.testlisteners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.wso2.carbon.automation.engine.extensions.TestNGExtensionExecutor;

public class TestManagerListener
implements ITestListener {
    private static final Log log = LogFactory.getLog(TestManagerListener.class);

    public void onTestStart(ITestResult iTestResult) {
        log.info((Object)("=================== Running the test method " + iTestResult.getTestClass().getName() + "." + iTestResult.getMethod().getMethodName() + " ==================="));
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onTestStart", false);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
    }

    public void onTestSuccess(ITestResult iTestResult) {
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onTestSuccess", false);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
        log.info((Object)("=================== On test success " + iTestResult.getTestClass().getName() + "." + iTestResult.getMethod().getMethodName() + " ==================="));
    }

    public void onTestFailure(ITestResult iTestResult) {
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onTestFailure", false);
            if (iTestResult.getThrowable() != null) {
                StackTraceElement[] stArr = iTestResult.getThrowable().getStackTrace();
                for (int x = 0; x < stArr.length; ++x) {
                    log.error((Object)stArr[x].toString());
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
        log.info((Object)("=================== On test failure " + iTestResult.getTestClass().getName() + "." + iTestResult.getMethod().getMethodName() + " ==================="));
    }

    public void onTestSkipped(ITestResult iTestResult) {
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onTestSkipped", false);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
        log.info((Object)("=================== On test skipped " + iTestResult.getTestClass().getName() + "." + iTestResult.getMethod().getMethodName() + " ==================="));
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        log.info((Object)"On test failed but within success percentage...");
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onTestFailedButWithinSuccessPercentage", false);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
    }

    public void onStart(ITestContext iTestContext) {
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onStart", false);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
    }

    public void onFinish(ITestContext iTestContext) {
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformTestManager", "onFinish", true);
        }
        catch (Exception e) {
            this.handleException("Error while running tests", e);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)"Execution error occurred in TestManagerListener:-", (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

