/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.testlisteners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.wso2.carbon.automation.engine.extensions.TestNGExtensionExecutor;

public class TestSuiteListener
implements ISuiteListener {
    private static final Log log = LogFactory.getLog(TestSuiteListener.class);
    private TestNGExtensionExecutor testNGExtensionExecutor;

    public void onStart(ISuite iSuite) {
        log.info((Object)"Inside Test Suite Listener - On Start");
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformSuiteManager", "onStart", false);
        }
        catch (Exception e) {
            this.handleException("Error when initializing test suite environment ", e);
        }
    }

    public void onFinish(ISuite iSuite) {
        log.info((Object)"Inside Test Suite Listener - On Finish");
        try {
            TestNGExtensionExecutor.executeExtensible("PlatformSuiteManager", "onFinish", true);
        }
        catch (Exception e) {
            this.handleException("Error when tear down test suite environment ", e);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)"Execution error occurred in TestSuiteListener:-", (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

