/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.testlisteners;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.IAnnotationTransformer;
import org.testng.IAnnotationTransformer2;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.TestNGExtensionExecutor;

public class TestTransformerListener
implements IAnnotationTransformer,
IAnnotationTransformer2 {
    private static final Log log = LogFactory.getLog(TestTransformerListener.class);
    private AutomationContext context;

    public void transform(ITestAnnotation iTestAnnotation, Class aClass, Constructor constructor, Method method) {
        if (aClass != null) {
            log.info((Object)("Started Class method transform for " + aClass.getName()));
            try {
                SetEnvironment annotation;
                this.context = new AutomationContext();
                if (aClass.getAnnotation(SetEnvironment.class) != null && !this.annotationComparator((annotation = aClass.getAnnotation(SetEnvironment.class)).toString()) && method != null) {
                    iTestAnnotation.setEnabled(false);
                    log.info((Object)("Skipped test Class method <" + method.getName() + "> on annotation <" + annotation.toString() + ">"));
                }
            }
            catch (Exception e) {
                this.handleException("Error transform custom annotations ", e);
            }
        }
        if (method != null) {
            try {
                this.context = new AutomationContext();
                SetEnvironment classAnnotation = method.getDeclaringClass().getAnnotation(SetEnvironment.class);
                SetEnvironment methodAnnotation = method.getAnnotation(SetEnvironment.class);
                log.info((Object)("Started Test method Transform manager for " + method.getName()));
                if (classAnnotation != null) {
                    if (!this.annotationComparator(classAnnotation.toString())) {
                        iTestAnnotation.setEnabled(false);
                        log.info((Object)("Skipped test method <" + method.getName() + "> on annotation <" + classAnnotation.toString() + ">"));
                    }
                } else if (methodAnnotation != null && !this.annotationComparator(methodAnnotation.toString())) {
                    iTestAnnotation.setEnabled(false);
                    log.info((Object)("Skipped test method <" + method.getName() + "> on annotation <" + methodAnnotation.toString() + ">"));
                }
                TestNGExtensionExecutor.executeExtensible("PlatformAnnotationTransferManager", "transform", false);
            }
            catch (Exception e) {
                this.handleException("Error transform custom annotations ", e);
            }
        }
    }

    private boolean annotationComparator(String annotation) throws AutomationFrameworkException {
        boolean compSetup = false;
        if (annotation.contains(ExecutionEnvironment.ALL.name())) {
            compSetup = true;
        } else {
            try {
                if (annotation.contains(ExecutionEnvironment.STANDALONE.name()) && annotation.toLowerCase().contains(this.context.getConfigurationValue("//executionEnvironment/text()"))) {
                    compSetup = true;
                } else if (annotation.contains(ExecutionEnvironment.PLATFORM.name()) && annotation.toLowerCase().contains(this.context.getConfigurationValue("//executionEnvironment/text()"))) {
                    compSetup = true;
                }
            }
            catch (XPathExpressionException e) {
                throw new AutomationFrameworkException("Error while reading//executionEnvironment/text() from automation.xml ", e);
            }
        }
        return compSetup;
    }

    public void transform(IConfigurationAnnotation iConfigurationAnnotation, Class aClass, Constructor constructor, Method method) {
        if (method != null) {
            try {
                this.context = new AutomationContext();
                SetEnvironment classAnnotation = method.getDeclaringClass().getAnnotation(SetEnvironment.class);
                SetEnvironment methodAnnotation = method.getAnnotation(SetEnvironment.class);
                log.info((Object)("Started Configuration Transform manager  " + method.getName()));
                if (classAnnotation != null) {
                    if (!this.annotationComparator(classAnnotation.toString())) {
                        iConfigurationAnnotation.setEnabled(false);
                        log.info((Object)("Skipped Configuration method <" + method.getName() + "> on annotation <" + classAnnotation.toString() + ">"));
                    }
                } else if (methodAnnotation != null && !this.annotationComparator(methodAnnotation.toString())) {
                    iConfigurationAnnotation.setEnabled(false);
                    log.info((Object)("Skipped Configuration method <" + method.getName() + "> on annotation <" + methodAnnotation.toString() + ">"));
                }
            }
            catch (Exception e) {
                this.handleException("Error transform custom annotations ", e);
            }
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)"Execution error occurred in TestTransformerListener:-", (Throwable)e);
        throw new RuntimeException(msg, e);
    }

    public void transform(IDataProviderAnnotation iDataProviderAnnotation, Method method) {
    }

    public void transform(IFactoryAnnotation iFactoryAnnotation, Method method) {
    }
}

