/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.configurations;

import javax.xml.xpath.XPathExpressionException;
import org.wso2.carbon.automation.engine.configurations.AutomationConfiguration;
import org.wso2.carbon.automation.engine.context.InstanceType;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.context.beans.Tenant;

public class UrlGenerationUtil {
    public static String getBackendURL(Instance instance) {
        String backendUrl;
        boolean webContextEnabled = instance.getProperties().containsKey("webContext");
        boolean portDisabled = instance.getPorts().isEmpty();
        String hostName = UrlGenerationUtil.getManagerHost(instance);
        if (!portDisabled) {
            String webContextRoot = instance.getProperty("webContext");
            String httpsPort = instance.getPorts().get("https");
            backendUrl = webContextRoot != null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + webContextRoot + "/" + "services/" : (webContextRoot == null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + "services/" : (webContextRoot == null ? "https://" + hostName + "/" + "services/" : "https://" + hostName + "/" + webContextRoot + "/" + "services/"));
        } else if (webContextEnabled) {
            String webContextRoot = instance.getProperty("webContext");
            backendUrl = "https://" + hostName + "/" + webContextRoot + "/" + "services/";
        } else {
            String httpsPort = instance.getPorts().get("https");
            backendUrl = "https://" + hostName + ":" + httpsPort + "/" + "services/";
        }
        return backendUrl;
    }

    public static String getServiceURL(Tenant tenant, Instance instance, boolean isSecured) throws XPathExpressionException {
        String serviceURL;
        boolean webContextEnabled = instance.getProperties().containsKey("webContext");
        boolean portEnabled = !instance.getPorts().isEmpty();
        boolean isNonBlockingEnabled = instance.isNonBlockingTransportEnabled();
        String hostName = UrlGenerationUtil.getWorkerHost(instance);
        String protocol = isSecured ? "https" : "http";
        String port = isSecured ? (isNonBlockingEnabled ? instance.getPorts().get("nhttps") : instance.getPorts().get("https")) : (isNonBlockingEnabled ? instance.getPorts().get("nhttp") : instance.getPorts().get("http"));
        if (tenant.getDomain().equals(AutomationConfiguration.getConfigurationValue("//superTenant/tenant[@key='superTenant']/@domain"))) {
            if (portEnabled && webContextEnabled) {
                String webContextRoot = instance.getProperty("webContext");
                serviceURL = webContextRoot != null && port != null ? protocol + "://" + hostName + ":" + port + "/" + webContextRoot + "/" + "services" : (webContextRoot == null && port != null ? protocol + "://" + hostName + ":" + port + "/" + "services" : (webContextRoot == null ? protocol + "://" + hostName + "/" + "services" : protocol + "://" + hostName + "/" + webContextRoot + "/" + "services"));
            } else if (!portEnabled && webContextEnabled) {
                String webContextRoot = instance.getProperty("webContext");
                serviceURL = protocol + "://" + hostName + "/" + webContextRoot + "/" + "services";
            } else {
                serviceURL = portEnabled && !webContextEnabled ? protocol + "://" + hostName + ":" + port + "/" + "services" : protocol + "://" + hostName + "/" + "services";
            }
        } else {
            String tenantDomain = tenant.getDomain();
            if (portEnabled && webContextEnabled) {
                String webContextRoot = instance.getProperty("webContext");
                serviceURL = webContextRoot != null && port != null ? protocol + "://" + hostName + ":" + port + "/" + webContextRoot + "/" + "services/t/" + tenantDomain : (webContextRoot == null && port != null ? protocol + "://" + hostName + ":" + port + "/" + "services/t/" + tenantDomain : (webContextRoot == null ? protocol + "://" + hostName + "/" + "services/t/" + tenantDomain : protocol + "://" + hostName + "/" + webContextRoot + "/" + "services/t/" + tenantDomain));
            } else if (!portEnabled && webContextEnabled) {
                String webContextRoot = instance.getProperty("webContext");
                serviceURL = protocol + "://" + hostName + "/" + webContextRoot + "/" + "services/t/" + tenantDomain;
            } else {
                serviceURL = portEnabled && !webContextEnabled ? protocol + "://" + hostName + ":" + port + "/" + "services/t/" + tenantDomain : protocol + "://" + hostName + "/" + "services/t/" + tenantDomain;
            }
        }
        return serviceURL;
    }

    public static String getWebAppURL(Tenant tenant, Instance instance) throws XPathExpressionException {
        String webAppURL = null;
        String httpPort = instance.getPorts().get("http");
        String tenantDomain = tenant.getDomain();
        String hostName = UrlGenerationUtil.getWorkerHost(instance);
        webAppURL = !tenant.getDomain().equals(AutomationConfiguration.getConfigurationValue("//superTenant/tenant[@key='superTenant']/@domain")) ? (httpPort != null ? "http://" + hostName + ":" + httpPort + "/t/" + tenantDomain : "http://" + hostName + "/t/" + tenantDomain) : (httpPort != null ? "http://" + hostName + ":" + httpPort : "http://" + hostName);
        return webAppURL;
    }

    public static String getWebAppURLHttps(Tenant tenant, Instance instance) throws XPathExpressionException {
        String webAppURL = null;
        String httpsPort = instance.getPorts().get("https");
        String tenantDomain = tenant.getDomain();
        String hostName = UrlGenerationUtil.getWorkerHost(instance);
        webAppURL = !tenant.getDomain().equals(AutomationConfiguration.getConfigurationValue("//superTenant/tenant[@key='superTenant']/@domain")) ? (httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/t/" + tenantDomain : "https://" + hostName + "/t/" + tenantDomain) : (httpsPort != null ? "https://" + hostName + ":" + httpsPort : "https://" + hostName);
        return webAppURL;
    }

    public static String getRemoteRegistryURL(Instance instance) {
        String remoteRegistry;
        boolean webContextEnabled = instance.getProperties().containsKey("webContext");
        boolean portDisabled = instance.getPorts().isEmpty();
        String hostName = UrlGenerationUtil.getManagerHost(instance);
        if (!portDisabled) {
            String webContextRoot = instance.getProperty("webContext");
            String httpsPort = instance.getPorts().get("https");
            remoteRegistry = webContextRoot != null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + webContextRoot + "/" + "registry/" : (webContextRoot == null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + "registry/" : (webContextRoot == null ? "https://" + hostName + "/" + "services/" : "https://" + hostName + "/" + webContextRoot + "/" + "registry/"));
        } else if (webContextEnabled) {
            String webContextRoot = instance.getProperty("webContext");
            remoteRegistry = "https://" + hostName + "/" + webContextRoot + "/" + "registry/";
        } else {
            String httpsPort = instance.getPorts().get("https");
            remoteRegistry = "https://" + hostName + ":" + httpsPort + "/" + "registry/";
        }
        return remoteRegistry;
    }

    public static String getLoginURL(Instance instance) {
        String backendUrl;
        boolean webContextEnabled = instance.getProperties().containsKey("webContext");
        boolean portDisabled = instance.getPorts().isEmpty();
        String hostName = UrlGenerationUtil.getManagerHost(instance);
        if (!portDisabled) {
            String webContextRoot = instance.getProperty("webContext");
            String httpsPort = instance.getPorts().get("https");
            backendUrl = webContextRoot != null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + webContextRoot + "/" + "carbon/" : (webContextRoot == null && httpsPort != null ? "https://" + hostName + ":" + httpsPort + "/" + "carbon/" : (webContextRoot == null ? "https://" + hostName + "/" + "services/" : "https://" + hostName + "/" + webContextRoot + "/" + "carbon/"));
        } else if (webContextEnabled) {
            String webContextRoot = instance.getProperty("webContext");
            backendUrl = "https://" + hostName + "/" + webContextRoot + "/" + "carbon/";
        } else {
            String httpsPort = instance.getPorts().get("https");
            backendUrl = "https://" + hostName + ":" + httpsPort + "/" + "carbon/";
        }
        return backendUrl;
    }

    public static String getManagerHost(Instance instance) {
        String managerHost = "";
        String instanceType = instance.getType();
        if (instanceType.equals(InstanceType.standalone.name())) {
            managerHost = instance.getHosts().get("default");
        } else if (instance.getType().equals(InstanceType.lb_worker_manager.name())) {
            managerHost = instance.getHosts().get("manager");
        }
        return managerHost;
    }

    public static String getWorkerHost(Instance instance) {
        String workerHost = "";
        String instanceType = instance.getType();
        if (instanceType.equals(InstanceType.standalone.name())) {
            workerHost = instance.getHosts().get("default");
        } else if (instance.getType().equals(InstanceType.lb_worker_manager.name())) {
            workerHost = instance.getHosts().get("worker");
        }
        return workerHost;
    }
}

