/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.automation.engine.configurations.AutomationConfiguration;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.DefaultInstance;
import org.wso2.carbon.automation.engine.context.InstanceType;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.ContextUrls;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.context.beans.ProductGroup;
import org.wso2.carbon.automation.engine.context.beans.Tenant;
import org.wso2.carbon.automation.engine.context.beans.User;

public class AutomationContext {
    private String productGroupName;
    private String workerInstanceName;
    private String managerInstanceName;
    private boolean isClustered;
    private boolean isSuperTenant;
    private boolean isAdminUser;
    private String tenantDomain;
    private String userKey;
    private Tenant superTenant;
    private Tenant contextTenant;

    public AutomationContext(String productGroupName, String instanceName, String tenantDomainKey, String userKey) throws XPathExpressionException {
        String superTenantReplacement = "tenants";
        this.isSuperTenant = false;
        this.isAdminUser = false;
        if (tenantDomainKey.equals(this.getConfigurationValue("//userManagement/superTenant/tenant/@key"))) {
            this.isSuperTenant = true;
            superTenantReplacement = this.getConfigurationValue("//userManagement/superTenant/tenant/@key");
        }
        if (userKey.equals("superAdmin") || userKey.equals("admin")) {
            this.isAdminUser = true;
        }
        this.productGroupName = productGroupName;
        this.managerInstanceName = instanceName;
        this.isClustered = Boolean.parseBoolean(this.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", productGroupName)));
        this.tenantDomain = this.getConfigurationValue(String.format("//%s/tenant[@key='%s']/@domain", superTenantReplacement, tenantDomainKey));
        this.userKey = userKey;
    }

    public AutomationContext(String productGroupName, String instanceName, TestUserMode userMode) throws XPathExpressionException {
        if (userMode.name().equals("SUPER_TENANT_ADMIN")) {
            this.assignParameters(productGroupName, instanceName, true, true);
        } else if (userMode.name().equals("SUPER_TENANT_USER")) {
            this.assignParameters(productGroupName, instanceName, true, false);
        } else if (userMode.name().equals("TENANT_ADMIN")) {
            this.assignParameters(productGroupName, instanceName, false, true);
        } else if (userMode.name().equals("TENANT_USER")) {
            this.assignParameters(productGroupName, instanceName, false, false);
        }
    }

    public AutomationContext(String productGroupName, TestUserMode testUserMode) throws XPathExpressionException {
        if (testUserMode.name().equals("SUPER_TENANT_ADMIN")) {
            this.assignParameters(productGroupName, null, true, true);
        } else if (testUserMode.name().equals("SUPER_TENANT_USER")) {
            this.assignParameters(productGroupName, null, true, false);
        } else if (testUserMode.name().equals("TENANT_ADMIN")) {
            this.assignParameters(productGroupName, null, false, true);
        } else if (testUserMode.name().equals("TENANT_USER")) {
            this.assignParameters(productGroupName, null, false, false);
        }
    }

    public AutomationContext() throws XPathExpressionException {
        DefaultInstance defaultInstance = new DefaultInstance();
        this.isSuperTenant = true;
        this.isAdminUser = true;
        this.productGroupName = this.getConfigurationValue("//productGroup[@default='true']/@name");
        this.isClustered = Boolean.parseBoolean(this.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", this.productGroupName)));
        this.tenantDomain = defaultInstance.getTenantDomain(true, this.isClustered);
        this.userKey = defaultInstance.getUserKey(this.tenantDomain, true);
        this.managerInstanceName = defaultInstance.getDefaultManager(this.productGroupName);
        this.workerInstanceName = defaultInstance.getDefaultWorker(this.productGroupName);
        System.setProperty("default.product.group", this.productGroupName);
    }

    private void assignParameters(String productGroupName, String instanceName, boolean isSuperTenant, boolean isAdminUser) throws XPathExpressionException {
        DefaultInstance defaultInstance = new DefaultInstance();
        this.isSuperTenant = isSuperTenant;
        this.isAdminUser = isAdminUser;
        this.productGroupName = productGroupName;
        this.isClustered = Boolean.parseBoolean(this.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", productGroupName)));
        this.tenantDomain = defaultInstance.getTenantDomain(isSuperTenant, this.isClustered);
        this.userKey = defaultInstance.getUserKey(this.tenantDomain, isAdminUser);
        if (instanceName == null) {
            this.managerInstanceName = defaultInstance.getDefaultManager(productGroupName);
            this.workerInstanceName = defaultInstance.getDefaultWorker(productGroupName);
        } else {
            this.workerInstanceName = instanceName;
            this.managerInstanceName = instanceName;
        }
    }

    private boolean getIsClustered() throws XPathExpressionException {
        return Boolean.parseBoolean(this.getConfigurationValue(String.format("//productGroup[@name='%s']/@clusteringEnabled", this.productGroupName)));
    }

    public Instance getInstance() throws XPathExpressionException {
        Instance instance = new Instance();
        HashMap<String, String> portMap = new HashMap<String, String>();
        HashMap<String, String> hostMap = new HashMap<String, String>();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Node instanceNode = this.getConfigurationNode(String.format("//productGroup[@name='%s']/instance[@name='%s']", this.productGroupName, this.managerInstanceName));
        NodeList ports = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/ports/port", this.productGroupName, this.managerInstanceName));
        NodeList hosts = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/hosts/host", this.productGroupName, this.managerInstanceName));
        NodeList properties = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/properties/property", this.productGroupName, this.managerInstanceName));
        for (int portNo = 0; portNo <= ports.getLength() - 1; ++portNo) {
            Node portNode = ports.item(portNo);
            String portType = portNode.getAttributes().getNamedItem("type").getNodeValue();
            portMap.put(portType, portNode.getFirstChild().getNodeValue());
        }
        for (int hostNo = 0; hostNo <= hosts.getLength() - 1; ++hostNo) {
            Node hostsNode = hosts.item(hostNo);
            String hostType = hostsNode.getAttributes().getNamedItem("type").getNodeValue();
            hostMap.put(hostType, hostsNode.getFirstChild().getNodeValue());
        }
        for (int propertyNo = 0; propertyNo <= properties.getLength() - 1; ++propertyNo) {
            Node propertyNode = properties.item(propertyNo);
            String propertyType = propertyNode.getAttributes().getNamedItem("name").getNodeValue();
            propertyMap.put(propertyType, propertyNode.getFirstChild().getNodeValue());
        }
        instance.setName(instanceNode.getAttributes().getNamedItem("name").getNodeValue());
        instance.setType(instanceNode.getAttributes().getNamedItem("type").getNodeValue());
        instance.setNonBlockingTransportEnabled(Boolean.parseBoolean(instanceNode.getAttributes().getNamedItem("nonBlockingTransportEnabled").getNodeValue()));
        instance.setPorts(portMap);
        instance.setHosts(hostMap);
        instance.setProperties(propertyMap);
        return instance;
    }

    public Instance getDefaultInstance() throws XPathExpressionException {
        Instance instance = new Instance();
        HashMap<String, String> portMap = new HashMap<String, String>();
        HashMap<String, String> hostMap = new HashMap<String, String>();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Node instanceNode = this.getConfigurationNode("//productGroup[@default='true']/instance[@type='standalone']");
        NodeList ports = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/ports/port", this.productGroupName, this.managerInstanceName));
        NodeList hosts = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/hosts/host", this.productGroupName, this.managerInstanceName));
        NodeList properties = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/properties/property", this.productGroupName, this.managerInstanceName));
        for (int portNo = 0; portNo <= ports.getLength() - 1; ++portNo) {
            Node portNode = ports.item(portNo);
            String portType = portNode.getAttributes().getNamedItem("type").getNodeValue();
            portMap.put(portType, portNode.getFirstChild().getNodeValue());
        }
        for (int hostNo = 0; hostNo <= hosts.getLength() - 1; ++hostNo) {
            Node hostsNode = hosts.item(hostNo);
            String hostType = hostsNode.getAttributes().getNamedItem("type").getNodeValue();
            hostMap.put(hostType, hostsNode.getFirstChild().getNodeValue());
        }
        for (int propertyNo = 0; propertyNo <= properties.getLength() - 1; ++propertyNo) {
            Node propertyNode = properties.item(propertyNo);
            String propertyType = propertyNode.getAttributes().getNamedItem("name").getNodeValue();
            propertyMap.put(propertyType, propertyNode.getFirstChild().getNodeValue());
        }
        instance.setName(instanceNode.getAttributes().getNamedItem("name").getNodeValue());
        instance.setType(instanceNode.getAttributes().getNamedItem("type").getNodeValue());
        instance.setPorts(portMap);
        instance.setHosts(hostMap);
        instance.setProperties(propertyMap);
        return instance;
    }

    public Tenant getSuperTenant() throws XPathExpressionException {
        if (this.superTenant != null) {
            return this.superTenant;
        }
        this.superTenant = new Tenant();
        String superDomain = this.getConfigurationValue("//superTenant/tenant/@domain");
        this.superTenant.setDomain(superDomain);
        Node adminUserNode = this.getConfigurationNode("//superTenant/tenant/admin");
        NodeList adminUserList = adminUserNode.getChildNodes();
        for (int nodeNo = 0; nodeNo <= adminUserList.getLength() - 1; ++nodeNo) {
            Node currentNode = adminUserList.item(nodeNo);
            if (!currentNode.getNodeName().equals("user")) continue;
            this.superTenant.setTenantAdmin(this.extractUser(currentNode, superDomain, true));
        }
        Node userNode = this.getConfigurationNode("//superTenant/tenant/users");
        NodeList childUserList = userNode.getChildNodes();
        for (int nodeNo = 0; nodeNo <= childUserList.getLength() - 1; ++nodeNo) {
            Node currentNode = childUserList.item(nodeNo);
            if (!currentNode.getNodeName().equals("user")) continue;
            User tenantUser = this.extractUser(currentNode, superDomain, true);
            this.superTenant.addTenantUsers(tenantUser);
        }
        this.superTenant.setContextUser(this.getUser());
        return this.superTenant;
    }

    private User extractUser(Node currentNode, String tenantDomain, boolean isTenantSuper) {
        User tenantUser = new User();
        String userName = null;
        NodeList userNodeList = currentNode.getChildNodes();
        tenantUser.setKey(currentNode.getAttributes().getNamedItem("key").getNodeValue());
        for (int userItem = 0; userItem <= userNodeList.getLength() - 1; ++userItem) {
            if (userNodeList.item(userItem).getNodeName().equals("userName")) {
                userName = userNodeList.item(userItem).getTextContent();
                continue;
            }
            if (userNodeList.item(userItem).getNodeName().equals("password")) {
                tenantUser.setPassword(userNodeList.item(userItem).getTextContent());
                continue;
            }
            if (!userNodeList.item(userItem).getNodeName().equals("roles")) continue;
            NodeList roleList = userNodeList.item(userItem).getChildNodes();
            for (int i = 0; i < roleList.getLength(); ++i) {
                tenantUser.addRole(roleList.item(i).getTextContent());
            }
        }
        if (tenantDomain.equals("carbon.super")) {
            tenantUser.setUserName(userName);
        } else {
            tenantUser.setUserName(userName + "@" + tenantDomain);
        }
        return tenantUser;
    }

    public Tenant getContextTenant() throws XPathExpressionException {
        Tenant tenant = this.isSuperTenant ? this.getSuperTenant() : this.getNonSuperTenant();
        return tenant;
    }

    private Tenant getNonSuperTenant() throws XPathExpressionException {
        if (this.contextTenant != null) {
            return this.contextTenant;
        }
        this.contextTenant = new Tenant();
        this.contextTenant.setDomain(this.tenantDomain);
        Node adminUserNode = this.getConfigurationNode(String.format("//tenants/tenant[@domain='%s']/admin", this.tenantDomain));
        NodeList adminUserList = adminUserNode.getChildNodes();
        for (int nodeNo = 0; nodeNo <= adminUserList.getLength() - 1; ++nodeNo) {
            Node currentNode = adminUserList.item(nodeNo);
            if (!currentNode.getNodeName().equals("user")) continue;
            this.contextTenant.setTenantAdmin(this.extractUser(currentNode, this.tenantDomain, true));
        }
        Node userNode = this.getConfigurationNode(String.format("//tenants/tenant[@domain='%s']/users", this.tenantDomain));
        NodeList childUserList = userNode.getChildNodes();
        for (int nodeNo = 0; nodeNo <= childUserList.getLength() - 1; ++nodeNo) {
            Node currentNode = childUserList.item(nodeNo);
            if (!currentNode.getNodeName().equals("user")) continue;
            User tenantUser = this.extractUser(currentNode, this.tenantDomain, this.isSuperTenant);
            this.contextTenant.addTenantUsers(tenantUser);
        }
        this.contextTenant.setContextUser(this.getUser());
        return this.contextTenant;
    }

    public ProductGroup getProductGroup() throws XPathExpressionException {
        ProductGroup productGroup = new ProductGroup();
        Node productGroupNode = this.getConfigurationNode(String.format("//productGroup[@name='%s']", this.productGroupName));
        productGroup.setGroupName(productGroupNode.getAttributes().getNamedItem("name").getNodeValue());
        productGroup.setClusterEnabled(Boolean.valueOf(productGroupNode.getAttributes().getNamedItem("clusteringEnabled").getNodeValue()));
        NodeList childProductGroupList = productGroupNode.getChildNodes();
        for (int nodeNo = 0; nodeNo <= childProductGroupList.getLength() - 1; ++nodeNo) {
            if (!childProductGroupList.item(nodeNo).getNodeName().equals("instance")) continue;
            String instanceName = childProductGroupList.item(nodeNo).getAttributes().getNamedItem("name").getNodeValue();
            productGroup.addInstance(this.getInstance(this.productGroupName, instanceName));
        }
        productGroup.setInstanceMapByType(this.setInstanceMapByType(childProductGroupList));
        return productGroup;
    }

    private User getUser() throws XPathExpressionException {
        User tenantUser = this.isAdminUser ? this.getAdminUser() : this.getOtherUser();
        return tenantUser;
    }

    private User getOtherUser() throws XPathExpressionException {
        String superUserReplacement = "tenants";
        if (this.isSuperTenant) {
            superUserReplacement = "superTenant";
        }
        User tenantUser = new User();
        Node tenantUserNode = this.getConfigurationNode(String.format("//%s/tenant[@domain='%s']/users/user[@key='%s']", superUserReplacement, this.tenantDomain, this.userKey));
        String userName = this.getConfigurationValue(String.format("//%s/tenant[@domain='%s']/users/user[@key='%s']/userName", superUserReplacement, this.tenantDomain, this.userKey));
        String password = this.getConfigurationValue(String.format("//%s/tenant[@domain='%s']/users/user[@key='%s']/password", superUserReplacement, this.tenantDomain, this.userKey));
        tenantUser.setUserName(userName + "@" + this.tenantDomain);
        tenantUser.setPassword(password);
        tenantUser.setKey(tenantUserNode.getAttributes().getNamedItem("key").getNodeValue());
        NodeList roleList = this.getConfigurationNodeList(String.format("//%s/tenant[@domain='%s']/users/user[@key='%s']/roles/role", superUserReplacement, this.tenantDomain, this.userKey));
        for (int i = 0; i < roleList.getLength(); ++i) {
            tenantUser.addRole(roleList.item(i).getTextContent());
        }
        return tenantUser;
    }

    private User getAdminUser() throws XPathExpressionException {
        String superUserReplacement = "tenants";
        if (this.isSuperTenant) {
            superUserReplacement = "superTenant";
        }
        User tenantUser = new User();
        String userName = this.getConfigurationValue(String.format("//%s/tenant[@domain='%s']/admin/user[@key='%s']/userName", superUserReplacement, this.tenantDomain, this.userKey));
        String password = this.getConfigurationValue(String.format("//%s/tenant[@domain='%s']/admin/user[@key='%s']/password", superUserReplacement, this.tenantDomain, this.userKey));
        if (this.isSuperTenant) {
            tenantUser.setUserName(userName);
        } else {
            tenantUser.setUserName(userName + "@" + this.tenantDomain);
        }
        tenantUser.setPassword(password);
        tenantUser.setKey(this.userKey);
        return tenantUser;
    }

    public ContextUrls getContextUrls() throws XPathExpressionException {
        ContextUrls contextUrls = new ContextUrls();
        try {
            contextUrls.setBackEndUrl(UrlGenerationUtil.getBackendURL(this.getInstance()));
            contextUrls.setServiceUrl(UrlGenerationUtil.getServiceURL(this.getContextTenant(), this.getInstance(), false));
            contextUrls.setSecureServiceUrl(UrlGenerationUtil.getServiceURL(this.getContextTenant(), this.getInstance(), true));
            contextUrls.setWebAppURL(UrlGenerationUtil.getWebAppURL(this.getContextTenant(), this.getInstance()));
            contextUrls.setWebAppURLHttps(UrlGenerationUtil.getWebAppURLHttps(this.getContextTenant(), this.getInstance()));
        }
        catch (XPathExpressionException e) {
            throw new XPathExpressionException("configuration retrieve failed");
        }
        return contextUrls;
    }

    private Map<String, ArrayList<Instance>> setInstanceMapByType(NodeList childProductGroupList) throws XPathExpressionException {
        HashMap<String, ArrayList<Instance>> instanceMapByType = new HashMap<String, ArrayList<Instance>>();
        for (InstanceType dir : InstanceType.values()) {
            ArrayList<Instance> instanceList = new ArrayList<Instance>();
            for (int nodeNo = 0; nodeNo <= childProductGroupList.getLength() - 1; ++nodeNo) {
                if (!childProductGroupList.item(nodeNo).getNodeName().equals("instance")) continue;
                String instanceName = childProductGroupList.item(nodeNo).getAttributes().getNamedItem("name").getNodeValue();
                String type = childProductGroupList.item(nodeNo).getAttributes().getNamedItem("type").getNodeValue();
                if (!type.equals(dir.name())) continue;
                instanceList.add(this.getInstance(this.productGroupName, instanceName));
            }
            if (instanceList.isEmpty()) continue;
            instanceMapByType.put(dir.name(), instanceList);
        }
        return instanceMapByType;
    }

    private Instance getInstance(String groupName, String instName) throws XPathExpressionException {
        Instance instance = new Instance();
        HashMap<String, String> portMap = new HashMap<String, String>();
        HashMap<String, String> hostMap = new HashMap<String, String>();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Node instanceNode = this.getConfigurationNode(String.format("//productGroup[@name='%s']/instance[ @name='%s']", groupName, instName));
        NodeList ports = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/ports/port", groupName, instName));
        NodeList hosts = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/hosts/host", groupName, instName));
        NodeList properties = this.getConfigurationNodeList(String.format("//productGroup[@name='%s']/instance[@name='%s']/properties/property", groupName, instName));
        for (int portNo = 0; portNo <= ports.getLength() - 1; ++portNo) {
            Node portNode = ports.item(portNo);
            String portType = portNode.getAttributes().getNamedItem("type").getNodeValue();
            portMap.put(portType, portNode.getFirstChild().getNodeValue());
        }
        for (int hostNo = 0; hostNo <= hosts.getLength() - 1; ++hostNo) {
            Node hostsNode = hosts.item(hostNo);
            String hostType = hostsNode.getAttributes().getNamedItem("type").getNodeValue();
            hostMap.put(hostType, hostsNode.getFirstChild().getNodeValue());
        }
        for (int propertyNo = 0; propertyNo <= properties.getLength() - 1; ++propertyNo) {
            Node propertyNode = properties.item(propertyNo);
            String propertyType = propertyNode.getAttributes().getNamedItem("name").getNodeValue();
            propertyMap.put(propertyType, propertyNode.getFirstChild().getNodeValue());
        }
        instance.setName(instanceNode.getAttributes().getNamedItem("name").getNodeValue());
        instance.setType(instanceNode.getAttributes().getNamedItem("type").getNodeValue());
        instance.setPorts(portMap);
        instance.setHosts(hostMap);
        instance.setProperties(propertyMap);
        return instance;
    }

    public String getConfigurationValue(String expression) throws XPathExpressionException {
        Document xmlDocument = AutomationConfiguration.getConfigurationDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.compile(expression).evaluate(xmlDocument);
    }

    public Node getConfigurationNode(String expression) throws XPathExpressionException {
        Document xmlDocument = AutomationConfiguration.getConfigurationDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (Node)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODE);
    }

    public NodeList getConfigurationNodeList(String expression) throws XPathExpressionException {
        Document xmlDocument = AutomationConfiguration.getConfigurationDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
    }

    public void replaceDocumentValue(String expression, String replaceBy) throws XPathExpressionException {
        Document xmlDocument = AutomationConfiguration.getConfigurationDocument();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile(expression).evaluate(xmlDocument, XPathConstants.NODE);
        node.setTextContent(replaceBy);
    }

    public String getWorkerInstanceName() {
        return this.workerInstanceName;
    }

    public List<String> getTenantList() throws XPathExpressionException {
        ArrayList<String> tenantList = new ArrayList<String>();
        tenantList.add("carbon.super");
        NodeList tenantNodeList = this.getConfigurationNodeList("//tenants").item(0).getChildNodes();
        for (int i = 0; i < tenantNodeList.getLength(); ++i) {
            tenantList.add(tenantNodeList.item(i).getAttributes().getNamedItem("domain").getNodeValue());
        }
        return tenantList;
    }

    public List<String> getUserList(String tenantDomain) throws XPathExpressionException {
        ArrayList<String> userList = new ArrayList<String>();
        String tenantType = "tenants";
        if (tenantDomain.equals("carbon.super")) {
            tenantType = "superTenant";
        }
        NodeList userNodeList = this.getConfigurationNodeList(String.format("//%s/tenant[@domain='%s']/users/user", tenantType, tenantDomain));
        for (int i = 0; i < userNodeList.getLength(); ++i) {
            userList.add(userNodeList.item(i).getAttributes().getNamedItem("key").getNodeValue());
        }
        return userList;
    }
}

