/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jacoco.core.tools.ExecFileLoader;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.ArchiveExtractorUtil;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public final class CodeCoverageUtils {
    private static final Log log = LogFactory.getLog(CodeCoverageUtils.class);
    private static final String DEFAULT_INCLUDES = "**";
    private static final String DEFAULT_EXCLUDES = "";
    private static final long COVERAGE_DUMP_WAIT_TIME = 10000L;

    private CodeCoverageUtils() {
    }

    public static ArrayList<String> searchDirectoryByName(String baseDir, ArrayList<String> directoryLists, String dirName) {
        File baseDirName = new File(baseDir);
        File[] fileArray = baseDirName.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File name = fileArray[i];
                if (name.isDirectory()) {
                    if (name.toString().subSequence(name.toString().lastIndexOf("/") + 1, name.toString().length()).equals(dirName)) {
                        directoryLists.add(name.getAbsolutePath());
                    }
                    CodeCoverageUtils.searchDirectoryByName(fileArray[i].getAbsolutePath(), directoryLists, dirName);
                    continue;
                }
                if (fileArray.length != i) continue;
                return null;
            }
        }
        return directoryLists;
    }

    public static String getJacocoAgentJarLocation() throws IOException {
        File jacocoHome = new File(System.getProperty("basedir") + File.separator + "target" + File.separator + "jacoco");
        String jacocoAgentFilePath = DEFAULT_EXCLUDES;
        if (jacocoHome.exists()) {
            File[] files = jacocoHome.listFiles();
            if (files != null) {
                for (File fileName : files) {
                    if (!fileName.getName().contains("org.jacoco.agent")) continue;
                    ArchiveExtractorUtil.extractFile(fileName.getAbsolutePath(), jacocoHome.getAbsolutePath() + File.separator + "agent");
                    File[] agentJars = new File(jacocoHome.getAbsolutePath() + File.separator + "agent").listFiles();
                    if (agentJars == null) continue;
                    for (File agentJar : agentJars) {
                        if (!agentJar.getName().contains("jacocoagent.jar")) continue;
                        jacocoAgentFilePath = agentJar.getAbsolutePath();
                    }
                }
            }
        } else {
            throw new FileNotFoundException("File cannot be found at " + jacocoHome.getAbsolutePath());
        }
        if (jacocoAgentFilePath.isEmpty()) {
            throw new FileNotFoundException("Jacoco Agent file path is empty and agent jar missing " + jacocoHome.getAbsolutePath());
        }
        return jacocoAgentFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertStringToFile(File inFile, File tmpFile, String lineToBeChecked, String lineToBeInserted) throws IOException {
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
        PrintWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(tmpFile);
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), true);
            String thisLine = DEFAULT_EXCLUDES;
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.contains(lineToBeChecked)) {
                    out.println(lineToBeInserted);
                }
                out.println(thisLine);
            }
            in.close();
            out.close();
            Files.move(tmpFile.toPath(), inFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (tmpFile.exists()) {
                throw new IOException("Failed to move file " + tmpFile.getAbsolutePath() + " as " + inFile.getAbsolutePath());
            }
            log.info((Object)("File " + inFile.getName() + " has been modified and inserted new line after " + lineToBeChecked));
            log.info((Object)("New line inserted into : " + inFile.getName()));
            log.info((Object)("Content of the line inserted : " + lineToBeInserted));
        }
        finally {
            if (tmpFile.exists() && !tmpFile.delete()) {
                log.warn((Object)("Failed to delete temporary file - " + tmpFile.getAbsolutePath()));
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertJacocoAgentToStartupBat(File inFile, File tmpFile, String lineToBeChecked, String lineToBeInserted) throws IOException {
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
        PrintWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(tmpFile);
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), true);
            String thisLine = DEFAULT_EXCLUDES;
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.contains(lineToBeChecked)) {
                    out.println(thisLine + " " + lineToBeInserted);
                    continue;
                }
                out.println(thisLine);
            }
            in.close();
            out.close();
            Files.move(tmpFile.toPath(), inFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (tmpFile.exists()) {
                throw new IOException("Failed to move file " + tmpFile.getAbsolutePath() + " as " + inFile.getAbsolutePath());
            }
            log.info((Object)("File " + inFile.getName() + " has been modified and inserted new line after " + lineToBeChecked));
            log.info((Object)("New line inserted into : " + inFile.getName()));
            log.info((Object)("Content of the line inserted : " + lineToBeInserted));
        }
        finally {
            if (tmpFile.exists() && !tmpFile.delete()) {
                log.warn((Object)("Failed to delete temporary file - " + tmpFile.getAbsolutePath()));
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getInstrumentationJarList(File patternList) throws IOException {
        ArrayList<String> filePatterns = new ArrayList<String>();
        if (patternList.exists()) {
            try (RandomAccessFile rf = new RandomAccessFile(patternList, "r");){
                String line;
                while ((line = rf.readLine()) != null) {
                    if (line.endsWith("_") || line.endsWith("-")) {
                        filePatterns.add(line.replace(line.substring(line.length() - 1), "*"));
                        continue;
                    }
                    if (line.startsWith("-") || line.startsWith("+")) {
                        filePatterns.add(line.replaceFirst(line.substring(0, 1), "*"));
                        continue;
                    }
                    filePatterns.add(line);
                }
            }
        }
        return filePatterns;
    }

    public static String buildStringArrayOfJarList(List<String> jarList, String delimiter) throws IOException {
        StringBuilder jarListOfPatternsBuffer = new StringBuilder();
        for (String jarPattern : jarList) {
            if (!jarList.get(jarList.size() - 1).equals(jarPattern)) {
                jarListOfPatternsBuffer.append(jarPattern).append(delimiter);
                continue;
            }
            jarListOfPatternsBuffer.append(jarPattern);
        }
        return jarListOfPatternsBuffer.toString();
    }

    public static String getInclusionJarsPattern(String delimiter) throws IOException {
        File instrumentationTxt;
        log.info((Object)"Building jar list for Jacoco coverage inclusion...");
        File file = instrumentationTxt = System.getProperty("instr.file") != null ? new File(System.getProperty("instr.file")) : new File(System.getProperty("basedir") + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "instrumentation.txt");
        if (instrumentationTxt.exists()) {
            return CodeCoverageUtils.buildStringArrayOfJarList(CodeCoverageUtils.getInstrumentationJarList(instrumentationTxt), delimiter);
        }
        log.warn((Object)("Jacoco Instrumentation file " + System.getProperty("instr.file") + " does not exist"));
        return DEFAULT_INCLUDES;
    }

    public static String getExclusionJarsPattern(String delimiter) throws IOException {
        log.info((Object)"Building jar list for Jacoco coverage exclusion...");
        String jacocoFilters = System.getProperty("filters.file");
        if (jacocoFilters == null) {
            jacocoFilters = System.getProperty("basedir") + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "filters.txt";
        } else if (!new File(jacocoFilters).exists()) {
            log.warn((Object)("Jacoco filters file " + jacocoFilters + " does not exist"));
        }
        if (new File(jacocoFilters).exists()) {
            return CodeCoverageUtils.buildStringArrayOfJarList(CodeCoverageUtils.getInstrumentationJarList(new File(jacocoFilters)), delimiter);
        }
        return DEFAULT_EXCLUDES;
    }

    public static String getJacocoReportDirectory() {
        String jacocoReportDir = System.getProperty("report.dir");
        if (jacocoReportDir == null) {
            jacocoReportDir = FrameworkPathUtil.getCoverageDirPath();
        }
        return jacocoReportDir;
    }

    public static void executeMerge(String dataFilePath, String coverageMergeFilePath) throws AutomationFrameworkException {
        ExecFileLoader loader = new ExecFileLoader();
        CodeCoverageUtils.load(loader, dataFilePath);
        CodeCoverageUtils.save(loader, coverageMergeFilePath);
    }

    private static void load(ExecFileLoader loader, String dataFilePath) throws AutomationFrameworkException {
        Collection<File> fileSetsCollection = CodeCoverageUtils.getJacocoDataFiles(dataFilePath);
        if (fileSetsCollection.size() == 0) {
            throw new AutomationFrameworkException("Couldn't find coverage data files at " + dataFilePath);
        }
        for (File inputFile : fileSetsCollection) {
            if (inputFile.isDirectory()) continue;
            try {
                CodeCoverageUtils.waitForCoverageDumpFileCreation(inputFile);
                log.info((Object)("Loading execution data file " + inputFile.getAbsolutePath()));
                loader.load(inputFile);
            }
            catch (IOException e) {
                throw new AutomationFrameworkException("Unable to read " + inputFile.getAbsolutePath(), e);
            }
        }
    }

    private static void save(ExecFileLoader loader, String coverageMergeFilePath) throws AutomationFrameworkException {
        File destinationFile = coverageMergeFilePath == null || coverageMergeFilePath.isEmpty() ? new File(FrameworkPathUtil.getCoverageMergeFilePath()) : new File(coverageMergeFilePath);
        if (loader.getExecutionDataStore().getContents().isEmpty()) {
            log.warn((Object)"Execution data is empty skipping coverage generation");
            return;
        }
        log.info((Object)("Writing merged execution data to " + destinationFile.getAbsolutePath()));
        try {
            loader.save(destinationFile, true);
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Unable to write merged file " + destinationFile.getAbsolutePath(), e);
        }
    }

    private static Collection<File> getJacocoDataFiles(String filePath) {
        return FileUtils.listFiles((File)new File(filePath), (IOFileFilter)new RegexFileFilter("[^s]+(.(?i)(exec))$"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
    }

    public static String[] scanDirectory(String jarExtractedDir, String[] includes, String[] excludes) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        ds.setExcludes(excludes);
        ds.setBasedir(new File(jarExtractedDir));
        ds.setCaseSensitive(true);
        ds.scan();
        return ds.getIncludedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String extractJarFile(String jarFilePath) throws IOException {
        if (!jarFilePath.endsWith(".jar")) {
            throw new IllegalArgumentException("Jar file should have the extension .jar. " + jarFilePath + " is invalid");
        }
        JarFile jarFile = new JarFile(jarFilePath);
        String fileSeparator = File.separatorChar == '\\' ? "\\" : File.separator;
        String jarFileName = jarFilePath;
        if (jarFilePath.lastIndexOf(fileSeparator) != -1) {
            jarFileName = jarFilePath.substring(jarFilePath.lastIndexOf(fileSeparator) + 1);
        }
        String tempExtractedDir = null;
        try {
            tempExtractedDir = FrameworkPathUtil.getJarExtractedFilePath() + File.separator + jarFileName.substring(0, jarFileName.lastIndexOf(46));
            ArchiveExtractorUtil.extractFile(jarFilePath, tempExtractedDir);
        }
        catch (IOException e) {
            log.warn((Object)("Could not extract the file " + jarFileName));
        }
        finally {
            jarFile.close();
        }
        return tempExtractedDir;
    }

    public static String[] getMatches(String[] classFiles, String[] regexArray) {
        ArrayList<String> matches = null;
        for (String regex : regexArray) {
            Pattern p = Pattern.compile(regex);
            matches = new ArrayList<String>();
            for (String s : classFiles) {
                if (p.matcher(s).matches()) continue;
                matches.add(s);
            }
        }
        return (String[])matches.toArray();
    }

    private static boolean waitForCoverageDumpFileCreation(File file) {
        long currentTime = System.currentTimeMillis();
        long waitTime = currentTime + 10000L;
        boolean status = false;
        while (waitTime > System.currentTimeMillis()) {
            if (file.length() > 0L) {
                status = true;
                log.info((Object)("Execution data file non empty file size in KB : " + file.length() / 1024L));
                break;
            }
            try {
                status = false;
                log.warn((Object)("Execution data file is empty file size in KB : " + file.length() / 1024L));
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {
                log.warn((Object)"Sleep interrupted ", (Throwable)ignored);
            }
        }
        return status;
    }
}

