/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.enums.OperatingSystems;

public class FrameworkPathUtil {
    public static final String SYSTEM_ARTIFACT_RESOURCE_LOCATION = "framework.resource.location";
    private static final Log log = LogFactory.getLog(FrameworkPathUtil.class);

    public static String getSystemResourceLocation() {
        String resourceLocation = System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name().toLowerCase()) ? System.getProperty(SYSTEM_ARTIFACT_RESOURCE_LOCATION).replace("/", "\\") : System.getProperty(SYSTEM_ARTIFACT_RESOURCE_LOCATION).replace("/", "/");
        return resourceLocation;
    }

    public static String getSystemSettingsLocation() {
        String settingsLocation = System.getProperty("automation.settings.location") != null ? (System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name().toLowerCase()) ? System.getProperty("automation.settings.location").replace("/", "\\") : System.getProperty("automation.settings.location").replace("/", "/")) : FrameworkPathUtil.getSystemResourceLocation();
        return settingsLocation;
    }

    public static String getReportLocation() {
        String reportLocation = System.getProperty("basedir", ".") + File.separator + "target";
        return reportLocation;
    }

    public static String getCarbonZipLocation() {
        return System.getProperty("carbon.zip");
    }

    public static String getCarbonTempLocation() {
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        return new File(baseDir).getAbsolutePath() + File.separator + extractDir;
    }

    public static String getCarbonServerAxisServiceDirectory() {
        return FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "axis2services";
    }

    public static String getCarbonServerLibLocation() {
        return FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "components" + File.separator + "lib";
    }

    public static String getCarbonServerConfLocation() {
        return FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "conf";
    }

    public static String getCoverageDirPath() {
        return System.getProperty("basedir") + File.separator + "target" + File.separator + "jacoco" + File.separator + "coverage";
    }

    public static String getJacocoCoverageHome() {
        return System.getProperty("basedir") + File.separator + "target" + File.separator + "jacoco";
    }

    public static String getTargetDirectory() {
        return System.getProperty("basedir") + File.separator + "target";
    }

    public static String getCoverageDumpFilePath() {
        return FrameworkPathUtil.getJacocoCoverageHome() + File.separator + "jacoco" + System.currentTimeMillis() + ".exec";
    }

    public static String getCoverageMergeFilePath() {
        return FrameworkPathUtil.getJacocoCoverageHome() + File.separator + "jacoco-data-merge" + ".exec";
    }

    public static String getJarExtractedFilePath() {
        return System.getProperty("basedir") + File.separator + "target" + File.separator + "jar";
    }

    public static String getCarbonHome() {
        if (System.getProperty("carbon.home") != null) {
            return System.getProperty("carbon.home");
        }
        log.error((Object)"Cannot read carbon.home property ");
        return null;
    }
}

