/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;
import org.wso2.carbon.automation.engine.frameworkutils.CodeCoverageUtils;

public class ReportGenerator {
    private static final Log log = LogFactory.getLog(ReportGenerator.class);
    public static final String OUTPUT_ENCODING = "UTF-8";
    private final File executionDataFile;
    private final File classesDirectory;
    private final File sourceDirectory;
    private final File reportDirectory;
    private ExecFileLoader execFileLoader;

    public ReportGenerator(File executionDataFile, File classesDirectory, File reportDirectory, File sourceDirectory) {
        this.executionDataFile = executionDataFile;
        this.classesDirectory = classesDirectory;
        this.reportDirectory = reportDirectory;
        this.sourceDirectory = sourceDirectory;
    }

    public void create() throws IOException {
        this.loadExecutionData();
        IBundleCoverage bundleCoverage = this.analyzeStructure();
        this.createReport(bundleCoverage);
    }

    private void createReport(IBundleCoverage bundleCoverage) throws IOException {
        IReportVisitor visitor = this.createVisitor(Locale.getDefault());
        visitor.visitInfo(this.execFileLoader.getSessionInfoStore().getInfos(), this.execFileLoader.getExecutionDataStore().getContents());
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)new DirectorySourceFileLocator(this.sourceDirectory, OUTPUT_ENCODING, 4));
        visitor.visitEnd();
    }

    IReportVisitor createVisitor(Locale locale) throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        if (this.getOutputDirectoryFile().exists()) {
            FileUtils.deleteDirectory((File)new File(this.getOutputDirectoryFile().getAbsolutePath()));
        }
        if (!this.getOutputDirectoryFile().mkdirs()) {
            throw new IOException("Failed to create coverage report directory - " + this.getOutputDirectoryFile());
        }
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(OUTPUT_ENCODING);
        htmlFormatter.setLocale(locale);
        visitors.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.getOutputDirectoryFile())));
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(OUTPUT_ENCODING);
        visitors.add(xmlFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.getOutputDirectoryFile(), "jacoco.xml"))));
        CSVFormatter csvFormatter = new CSVFormatter();
        csvFormatter.setOutputEncoding(OUTPUT_ENCODING);
        visitors.add(csvFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.getOutputDirectoryFile(), "jacoco.csv"))));
        return new MultiReportVisitor(visitors);
    }

    private File getOutputDirectoryFile() {
        return this.reportDirectory;
    }

    private void loadExecutionData() throws IOException {
        this.execFileLoader = new ExecFileLoader();
        this.execFileLoader.load(this.executionDataFile);
    }

    private IBundleCoverage analyzeStructure() throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        String[] includes = new String[]{"**/*.class"};
        String exclusionList = CodeCoverageUtils.getExclusionJarsPattern(",");
        String[] excludes = exclusionList.split(",");
        List filesToAnalyze = FileUtils.getFiles((File)this.classesDirectory, (String)CodeCoverageUtils.getInclusionJarsPattern(","), (String)exclusionList);
        for (File file : filesToAnalyze) {
            String[] classFiles;
            String extractedDir = CodeCoverageUtils.extractJarFile(file.getAbsolutePath());
            log.info((Object)("Jar file analyzed for coverage : " + file.getName()));
            for (String classFile : classFiles = CodeCoverageUtils.scanDirectory(extractedDir, includes, excludes)) {
                analyzer.analyzeAll(new File(extractedDir + File.separator + classFile));
            }
            FileUtils.forceDelete((File)new File(extractedDir));
        }
        return coverageBuilder.getBundle("Overall Coverage Summary");
    }
}

