/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.engine.frameworkutils;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.ArchiveExtractorUtil;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class TestFrameworkUtils {
    private static final Log log = LogFactory.getLog(ArchiveExtractorUtil.class);

    public static void setKeyStoreProperties(AutomationContext context) throws XPathExpressionException {
        System.setProperty("javax.net.ssl.trustStore", FrameworkPathUtil.getSystemResourceLocation() + context.getConfigurationValue("//keystore/fileName/text()"));
        System.setProperty("javax.net.ssl.trustStorePassword", context.getConfigurationValue("//keystore/keyPassword/text()"));
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.net.ssl.trustStore :" + System.getProperty("javax.net.ssl.trustStore")));
            log.debug((Object)("javax.net.ssl.trustStorePassword :" + System.getProperty("javax.net.ssl.trustStorePassword")));
            log.debug((Object)("javax.net.ssl.trustStoreType :" + System.getProperty("javax.net.ssl.trustStoreType")));
        }
    }

    public static String getStartupScriptFileName(String carbonHome) throws FileNotFoundException {
        File[] allScripts = new File(carbonHome + File.separator + "bin").listFiles();
        String scriptName = null;
        if (allScripts != null) {
            for (File scriptFileName : allScripts) {
                if (scriptFileName.getName().contains("wso2server")) {
                    scriptName = scriptFileName.getAbsoluteFile().getName();
                } else {
                    if (!scriptFileName.getName().contains("server")) continue;
                    scriptName = scriptFileName.getName();
                }
                break;
            }
        } else {
            throw new FileNotFoundException("Server startup script not found at " + carbonHome + File.separator + "bin");
        }
        return FilenameUtils.removeExtension(scriptName);
    }
}

