/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.axis2client;

import java.io.File;
import java.io.IOException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class AxisOperationClient {
    private static final Log log = LogFactory.getLog(AxisOperationClient.class);
    private MessageContext outMsgCtx;
    private ConfigurationContext cfgCtx;
    private ServiceClient serviceClient;
    private OperationClient operationClient;
    private SOAPFactory fac;
    private SOAPEnvelope envelope;

    public AxisOperationClient() {
        String repositoryPath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "client";
        File repository = new File(repositoryPath);
        log.info((Object)("Using the Axis2 repository path: " + repository.getAbsolutePath()));
        try {
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getCanonicalPath(), null);
            this.serviceClient = new ServiceClient(this.cfgCtx, null);
            log.info((Object)"Sample client initialized successfully...");
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the Operational Client", (Throwable)e);
        }
    }

    public OMElement sendMultipleQuoteRequest(String trpUrl, String addUrl, String symbol, int iterations) throws IOException {
        return this.createMultipleQuoteRequest(trpUrl, addUrl, symbol, iterations);
    }

    public OMElement send(String trpUrl, String addUrl, OMElement payload, String action) throws AxisFault {
        this.operationClient = this.serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        this.setMessageContext(addUrl, trpUrl, action);
        this.outMsgCtx.setEnvelope(this.createSOAPEnvelope(payload));
        this.operationClient.addMessageContext(this.outMsgCtx);
        this.operationClient.execute(true);
        MessageContext inMsgtCtx = this.operationClient.getMessageContext("In");
        SOAPEnvelope response = inMsgtCtx.getEnvelope();
        return response;
    }

    private OMElement createMultipleQuoteRequestBody(String symbol, int iterations) {
        OMNamespace omNs = this.fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = this.fac.createOMElement("getQuote", omNs);
        for (int i = 0; i < iterations; ++i) {
            OMElement value1 = this.fac.createOMElement("request", omNs);
            OMElement value2 = this.fac.createOMElement("symbol", omNs);
            value2.addChild((OMNode)this.fac.createOMText((OMContainer)value1, symbol));
            value1.addChild((OMNode)value2);
            method.addChild((OMNode)value1);
        }
        return method;
    }

    private OMElement createMultipleQuoteRequest(String trpUrl, String addUrl, String symbol, int iterations) throws IOException {
        this.operationClient = this.serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        this.setMessageContext(addUrl, trpUrl, null);
        this.outMsgCtx.setEnvelope(this.createSOAPEnvelope(symbol, iterations));
        this.operationClient.addMessageContext(this.outMsgCtx);
        this.operationClient.execute(true);
        MessageContext inMsgtCtx = this.operationClient.getMessageContext("In");
        SOAPEnvelope response = inMsgtCtx.getEnvelope();
        return response;
    }

    private void setMessageContext(String addUrl, String trpUrl, String action) {
        this.outMsgCtx = new MessageContext();
        Options options = this.outMsgCtx.getOptions();
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        if (addUrl != null && !"null".equals(addUrl)) {
            options.setTo(new EndpointReference(addUrl));
        }
        if (action != null && !"null".equals(action)) {
            options.setAction(action);
        }
    }

    private SOAPEnvelope createSOAPEnvelope(String symbol, int iterations) {
        this.fac = OMAbstractFactory.getSOAP11Factory();
        this.envelope = this.fac.getDefaultEnvelope();
        this.envelope.getBody().addChild((OMNode)this.createMultipleQuoteRequestBody(symbol, iterations));
        return this.envelope;
    }

    private SOAPEnvelope createSOAPEnvelope(OMElement payload) {
        this.fac = OMAbstractFactory.getSOAP11Factory();
        this.envelope = this.fac.getDefaultEnvelope();
        this.envelope.getBody().addChild((OMNode)payload);
        return this.envelope;
    }

    public void destroy() {
        try {
            this.serviceClient.cleanup();
            this.cfgCtx.cleanupContexts();
            this.cfgCtx.terminate();
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while cleaning up the service client", (Throwable)axisFault);
        }
        this.outMsgCtx = null;
        this.serviceClient = null;
        this.operationClient = null;
        this.cfgCtx = null;
        this.envelope = null;
        this.fac = null;
    }
}

