/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.axis2client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;

public class AxisServiceClientUtils {
    public static final boolean TWO_WAY = true;
    public static final boolean ONE_WAY = false;
    private static final Log log = LogFactory.getLog(AxisServiceClientUtils.class);

    public static OMElement sendRequest(String payloadStr, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        OMElement result = sender.sendReceive(payload);
        return result;
    }

    public static void sendRequestOneWay(String payloadStr, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        sender.fireAndForget(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceAvailable(String serviceUrl) throws IOException {
        InputStream wsdlIS;
        URL wsdlURL;
        try {
            wsdlURL = new URL(serviceUrl + "?wsdl");
        }
        catch (MalformedURLException e) {
            return false;
        }
        try {
            wsdlIS = wsdlURL.openStream();
        }
        catch (IOException e) {
            return false;
        }
        BufferedReader in = null;
        if (wsdlIS != null) {
            try {
                String inputLine;
                in = new BufferedReader(new InputStreamReader(wsdlIS, Charset.forName("UTF-8")));
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.contains("definitions")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return false;
    }

    public static void waitForServiceDeployment(String serviceUrl) throws IOException {
        int serviceTimeOut = 0;
        while (!AxisServiceClientUtils.isServiceAvailable(serviceUrl)) {
            if (serviceTimeOut != 0 && serviceTimeOut > 100) {
                Assert.fail((String)(serviceUrl + " service is not found"));
                break;
            }
            try {
                Thread.sleep(500L);
                ++serviceTimeOut;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void sendRequest(String eprUrl, String operation, String payload, int numberOfInstances, List<String> expectedStrings, boolean twoWay) throws AutomationFrameworkException {
        try {
            AxisServiceClientUtils.waitForServiceDeployment(eprUrl);
            Assert.assertFalse((!AxisServiceClientUtils.isServiceAvailable(eprUrl) ? 1 : 0) != 0);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new AutomationFrameworkException("Service not available ", (Throwable)e);
        }
        for (int i = 0; i < numberOfInstances; ++i) {
            try {
                EndpointReference epr = new EndpointReference(eprUrl + "/" + operation);
                if (twoWay) {
                    OMElement result = AxisServiceClientUtils.sendRequest(payload, epr);
                    if (expectedStrings == null) continue;
                    for (String expectedString : expectedStrings) {
                        Assert.assertFalse((!result.toString().contains(expectedString) ? 1 : 0) != 0);
                    }
                    continue;
                }
                AxisServiceClientUtils.sendRequestOneWay(payload, epr);
                continue;
            }
            catch (XMLStreamException e) {
                log.error((Object)e);
                throw new AutomationFrameworkException("cannot read xml stream ", (Throwable)e);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage());
                throw new AutomationFrameworkException("cannot read xml stream " + axisFault.getMessage());
            }
        }
    }

    public static void sendRequest(String eprUrl, String operation, String payload, int numberOfInstances, String expectedException, boolean twoWay) throws XMLStreamException, IOException {
        Assert.assertFalse((!AxisServiceClientUtils.isServiceAvailable(eprUrl) ? 1 : 0) != 0);
        for (int i = 0; i < numberOfInstances; ++i) {
            block7: {
                try {
                    EndpointReference epr = new EndpointReference(operation);
                    if (twoWay) {
                        OMElement result = AxisServiceClientUtils.sendRequest(payload, epr);
                        Assert.fail((String)("Exception expected!!! : " + result.toString()));
                    } else {
                        AxisServiceClientUtils.sendRequestOneWay(payload, epr);
                    }
                }
                catch (XMLStreamException e) {
                    if (!e.getClass().getSimpleName().equals(expectedException)) {
                        throw new XMLStreamException(e);
                    }
                }
                catch (AxisFault axisFault) {
                    if (((Object)((Object)axisFault)).getClass().getSimpleName().equals(expectedException)) break block7;
                    throw new AxisFault(axisFault.getMessage());
                }
            }
            if (expectedException == null) continue;
            Assert.fail((String)"Exception expected. But not found!!");
        }
    }

    public static void waitForServiceUnDeployment(String serviceUrl) throws AutomationFrameworkException {
        int serviceTimeOut = 0;
        try {
            while (AxisServiceClientUtils.isServiceAvailable(serviceUrl)) {
                if (serviceTimeOut != 0 && serviceTimeOut > 60) {
                    throw new AutomationFrameworkException("Service undeployment fail");
                }
                try {
                    Thread.sleep(500L);
                    ++serviceTimeOut;
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (IOException e) {
            log.error((Object)"Service not available ", (Throwable)e);
            throw new AutomationFrameworkException("Service not available ", (Throwable)e);
        }
    }

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://test.com", "test");
        OMElement method = fac.createOMElement("add", omNs);
        OMElement valueOfa = fac.createOMElement("a", omNs);
        OMElement valueOfb = fac.createOMElement("b", omNs);
        valueOfa.addChild((OMNode)fac.createOMText((OMContainer)valueOfa, "200"));
        valueOfb.addChild((OMNode)fac.createOMText((OMContainer)valueOfb, "220"));
        method.addChild((OMNode)valueOfa);
        method.addChild((OMNode)valueOfb);
        return method;
    }
}

