/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.axis2client;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class ConfigurationContextProvider {
    private static final Log log = LogFactory.getLog(ConfigurationContextProvider.class);
    private static ConfigurationContext configurationContext = null;
    private static ConfigurationContextProvider instance = new ConfigurationContextProvider();

    private ConfigurationContextProvider() {
        try {
            configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(FrameworkPathUtil.getSystemResourceLocation() + File.separator + "client"), null);
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(25);
            poolingHttpClientConnectionManager.setMaxTotal(5);
            CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
            configurationContext.setProperty("CACHED_HTTP_CLIENT", (Object)client);
            configurationContext.setProperty("REUSE_HTTP_CLIENT", (Object)"true");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while creating axis2 configuration context", (Throwable)axisFault);
        }
    }

    public static ConfigurationContextProvider getInstance() {
        return instance;
    }

    public ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }
}

