/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.common;

import java.io.File;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class TestConfigurationProvider {
    private static Log log = LogFactory.getLog(TestConfigurationProvider.class);
    private AutomationContext context;
    private static TestConfigurationProvider instance = new TestConfigurationProvider();

    private TestConfigurationProvider() {
        try {
            this.context = new AutomationContext();
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Loading Automation Configuration failed", (Throwable)e);
        }
    }

    public static String getResourceLocation(String productName) {
        return FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + productName;
    }

    public static String getSecurityPolicyLocation() {
        return TestConfigurationProvider.getResourceLocation() + File.separator + "security" + File.separator + "policies";
    }

    public static String getKeyStoreLocation() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//keystore/fileName/text()");
    }

    public static String getKeyStorePassword() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//keystore/password/text()");
    }

    public static String getKeyStoreType() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//keystore/type/text()");
    }

    public static String getTrustStoreLocation() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//truststore/fileName/text()");
    }

    public static String getTrustStorePassword() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//truststore/password/text()");
    }

    public static String getTrustStoreType() throws XPathExpressionException {
        return TestConfigurationProvider.getResourceLocation() + File.separator + TestConfigurationProvider.instance.context.getConfigurationValue("//truststore/type/text()");
    }

    public static String getResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation();
    }

    public static String getExecutionEnvironment() throws XPathExpressionException {
        return TestConfigurationProvider.instance.context.getConfigurationValue("//executionEnvironment");
    }

    public static int getServiceDeploymentDelay() {
        try {
            return Integer.parseInt(TestConfigurationProvider.instance.context.getConfigurationValue("//deploymentDelay"));
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error reading deploymentDelay from automation.xml", (Throwable)e);
            log.warn((Object)"Service deployment Delay configuration not found. Running with default value 30000 mils");
            return 30000;
        }
    }

    public static boolean isIntegration() throws XPathExpressionException {
        return "Product".equalsIgnoreCase(TestConfigurationProvider.getExecutionEnvironment());
    }

    public static boolean isPlatform() throws XPathExpressionException {
        return "platform".equalsIgnoreCase(TestConfigurationProvider.getExecutionEnvironment());
    }

    public static AutomationContext getAutomationContext() {
        return TestConfigurationProvider.instance.context;
    }
}

